/*
 * Decompiled with CFR 0.152.
 */
package org.aya.terck;

import java.util.stream.IntStream;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Docile;
import org.aya.terck.CallMatrix;
import org.aya.terck.Relation;
import org.jetbrains.annotations.NotNull;

public record Diagonal<T, P>(@NotNull CallMatrix<T, P> matrix, @NotNull ImmutableSeq<Relation> diagonal) implements Docile
{
    @NotNull
    public static <T, P> Diagonal<T, P> create(@NotNull CallMatrix<T, P> matrix) {
        assert (matrix.rows() == matrix.cols());
        ImmutableSeq diag = (ImmutableSeq)IntStream.range(0, matrix.rows()).mapToObj(i -> matrix.matrix()[i][i]).collect(ImmutableSeq.factory());
        return new Diagonal<T, P>(matrix, (ImmutableSeq<Relation>)diag);
    }

    @NotNull
    public Doc toDoc() {
        return Doc.stickySep((SeqLike)this.diagonal.view().map(Relation::toDoc));
    }
}

