/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import java.util.function.Consumer;
import org.aya.core.term.Term;
import org.aya.core.visitor.Zonker;
import org.aya.generic.util.NormalizeMode;
import org.aya.tyck.TyckState;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.unify.Unifier;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Tycker {
    @NotNull
    public final Reporter reporter;
    @NotNull
    public final TyckState state;
    @Nullable
    public final Trace.Builder traceBuilder;

    protected Tycker(@NotNull Reporter reporter, @NotNull TyckState state, @Nullable Trace.Builder traceBuilder) {
        this.reporter = reporter;
        this.state = state;
        this.traceBuilder = traceBuilder;
    }

    @NotNull
    public Term zonk(@NotNull Term term) {
        return Zonker.make(this).apply(term);
    }

    public void solveMetas() {
        this.state.solveMetas(this.reporter, this.traceBuilder);
    }

    @NotNull
    public Term whnf(@NotNull Term term) {
        return term.normalize(this.state, NormalizeMode.WHNF);
    }

    protected void tracing(@NotNull @NotNull Consumer<@NotNull Trace.Builder> consumer) {
        if (this.traceBuilder != null) {
            consumer.accept(this.traceBuilder);
        }
    }

    @NotNull
    public Unifier unifier(@NotNull SourcePos pos, @NotNull Ordering ord, @NotNull LocalCtx ctx) {
        return new Unifier(ord, this.reporter, false, true, this.traceBuilder, this.state, pos, ctx);
    }
}

