/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.control.Either;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.core.def.FieldDef;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.generic.ExprProblem;
import org.aya.generic.util.NormalizeMode;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.ref.DefVar;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.TyckError;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public record BadTypeError(@NotNull Expr expr, @NotNull Term actualType, @NotNull Doc action, @NotNull Doc thing, @NotNull AyaDocile desired, @NotNull TyckState state) implements ExprProblem,
TyckError
{
    @NotNull
    public Doc describe(@NotNull DistillerOptions options) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unable to"), this.action, Doc.english((String)"the expression")}), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.sep((Doc[])new Doc[]{Doc.english((String)"because the type"), this.thing, Doc.english((String)"is not a"), Doc.cat((Doc[])new Doc[]{this.desired.toDoc(options), Doc.plain((String)",")}), Doc.english((String)"but instead:")}), Doc.par((int)1, (Doc)this.actualType.toDoc(options)), Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), this.actualType.normalize(this.state, NormalizeMode.NF).toDoc(options)})))});
    }

    @NotNull
    public Doc hint(@NotNull DistillerOptions options) {
        Expr.RefExpr ref;
        Expr.AppExpr app;
        Object object = this.expr;
        if (object instanceof Expr.AppExpr && (object = (app = (Expr.AppExpr)object).function()) instanceof Expr.RefExpr && (object = (ref = (Expr.RefExpr)object).resolvedVar()) instanceof DefVar) {
            DefVar defVar = (DefVar)object;
            if (defVar.core instanceof FieldDef) {
                Expr.ProjExpr fix = new Expr.ProjExpr(SourcePos.NONE, app.argument().expr(), (Either<Integer, QualifiedID>)Either.right((Object)new QualifiedID(SourcePos.NONE, defVar.name())));
                return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Did you mean"), Doc.styled((Style)Style.code(), (Doc)fix.toDoc(options)), Doc.english((String)"?")});
            }
        }
        return Doc.empty();
    }

    @NotNull
    public static BadTypeError pi(@NotNull TyckState state, @NotNull Expr expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.plain((String)"apply"), Doc.english((String)"of what you applied"), options -> Doc.english((String)"Pi type"), state);
    }

    @NotNull
    public static BadTypeError sigmaAcc(@NotNull TyckState state, @NotNull Expr expr, int ix, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.english((String)"project the"), Doc.ordinal((int)ix), Doc.english((String)"element of")}), Doc.english((String)"of what you projected on"), options -> Doc.english((String)"Sigma type"), state);
    }

    @NotNull
    public static BadTypeError sigmaCon(@NotNull TyckState state, @NotNull Expr expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.plain((String)"construct")}), Doc.english((String)"you checks it against"), options -> Doc.english((String)"Sigma type"), state);
    }

    @NotNull
    public static BadTypeError structAcc(@NotNull TyckState state, @NotNull Expr expr, @NotNull String fieldName, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.english((String)"access field"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)fieldName)), Doc.plain((String)"of")}), Doc.english((String)"of what you accessed"), options -> Doc.english((String)"struct type"), state);
    }

    @NotNull
    public static BadTypeError structCon(@NotNull TyckState state, @NotNull Expr expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.plain((String)"construct")}), Doc.english((String)"you gave"), options -> Doc.english((String)"struct type"), state);
    }

    @NotNull
    public static BadTypeError univ(@NotNull TyckState state, @NotNull Expr expr, @NotNull Term actual) {
        return new BadTypeError(expr, actual, Doc.english((String)"make sense of"), Doc.english((String)"provided"), options -> Doc.english((String)"universe"), state);
    }

    @NotNull
    public static BadTypeError lamParam(@NotNull TyckState state, @NotNull Expr lamExpr, @NotNull AyaDocile paramType, @NotNull Term actualParamType) {
        return new BadTypeError(lamExpr, actualParamType, Doc.english((String)"apply or construct"), Doc.english((String)"of the lambda parameter"), paramType, state);
    }

    @NotNull
    public static BadTypeError partTy(@NotNull TyckState state, @NotNull Expr expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.plain((String)"fill the shape composed by"), Doc.english((String)"of the partial element"), options -> Doc.english((String)"Partial type"), state);
    }
}

