/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import org.aya.concrete.Expr;
import org.aya.core.term.Term;
import org.aya.generic.ExprProblem;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LicitError
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @NotNull
    default public Problem.Stage stage() {
        return Problem.Stage.TYCK;
    }

    public record UnexpectedImplicitArg(@NotNull Expr.NamedArg expr) implements LicitError
    {
        @NotNull
        public SourcePos sourcePos() {
            return this.expr.expr().sourcePos();
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unexpected implicit argument"), Doc.styled((Style)Style.code(), (Doc)this.expr.toDoc(options))});
        }
    }

    public record LicitMismatch(@NotNull Expr expr, @NotNull Term type) implements LicitError,
    ExprProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot check"), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.english((String)"against the Pi type"), Doc.par((int)1, (Doc)this.type.toDoc(options)), Doc.english((String)"because explicitness do not match")});
        }
    }
}

