/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import org.aya.concrete.stmt.TeleDecl;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.tyck.error.TyckError;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PrimError
extends TyckError {

    public record BadInterval(@NotNull SourcePos sourcePos, int integer) implements TyckError
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The point"), Doc.styled((Style)Style.code(), (String)String.valueOf(this.integer)), Doc.english((String)"does not live in interval")});
        }

        @NotNull
        public Doc hint(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Did you mean: "), Doc.styled((Style)Style.code(), (String)"0"), Doc.plain((String)"or"), Doc.styled((Style)Style.code(), (String)"1")});
        }
    }

    public record NoResultType(@NotNull TeleDecl.PrimDecl prim) implements PrimError
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{this.prim.toDoc(options), Doc.english((String)"is expected to have a type")});
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.prim.sourcePos();
        }
    }
}

