/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.order;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.Def;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.UserDef;
import org.aya.core.term.Term;
import org.aya.generic.util.InterruptException;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.terck.CallGraph;
import org.aya.terck.CallResolver;
import org.aya.terck.Diagonal;
import org.aya.terck.error.BadRecursion;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.StmtTycker;
import org.aya.tyck.error.CounterexampleError;
import org.aya.tyck.error.TyckOrderError;
import org.aya.tyck.order.SigRefFinder;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.tyck.trace.Trace;
import org.aya.util.reporter.BufferReporter;
import org.aya.util.reporter.CollectingReporter;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.aya.util.terck.MutableGraph;
import org.aya.util.tyck.SCCTycker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AyaSccTycker(@NotNull StmtTycker tycker, @NotNull CountingReporter reporter, @NotNull ResolveInfo resolveInfo, @NotNull @NotNull MutableList<@NotNull GenericDef> wellTyped, @NotNull MutableMap<Decl.TopLevel, ExprTycker> tyckerReuse, @NotNull MutableMap<Decl.TopLevel, CollectingReporter> sampleReporters) implements SCCTycker<TyckOrder, SCCTyckingFailed>
{
    @NotNull
    public static AyaSccTycker create(ResolveInfo resolveInfo, @Nullable Trace.Builder builder, @NotNull Reporter outReporter) {
        CountingReporter counting = CountingReporter.delegate((Reporter)outReporter);
        return new AyaSccTycker(new StmtTycker((Reporter)counting, builder), counting, resolveInfo, (MutableList<GenericDef>)MutableList.create(), (MutableMap<Decl.TopLevel, ExprTycker>)MutableMap.create(), (MutableMap<Decl.TopLevel, CollectingReporter>)MutableMap.create());
    }

    @NotNull
    public ImmutableSeq<TyckOrder> tyckSCC(@NotNull ImmutableSeq<TyckOrder> scc) {
        try {
            if (scc.isEmpty()) {
                return ImmutableSeq.empty();
            }
            if (scc.sizeEquals(1)) {
                this.checkUnit((TyckOrder)scc.first());
            } else {
                this.checkMutual(scc);
            }
            return ImmutableSeq.empty();
        }
        catch (SCCTyckingFailed failed) {
            this.reporter.clear();
            return failed.what;
        }
    }

    private void checkMutual(@NotNull ImmutableSeq<TyckOrder> scc) {
        ImmutableSeq unit = (ImmutableSeq)scc.stream().map(TyckOrder::unit).distinct().collect(ImmutableSeq.factory());
        ImmutableSeq<TyckUnit> headerOrder = this.headerOrder(scc, (ImmutableSeq<TyckUnit>)unit);
        if (headerOrder.sizeEquals(1)) {
            this.checkUnit(new TyckOrder.Body((TyckUnit)headerOrder.first()));
        } else {
            ImmutableSeq tyckTasks = headerOrder.view().map(TyckOrder.Head::new).appendedAll((Iterable)headerOrder.map(TyckOrder.Body::new)).toImmutableSeq();
            tyckTasks.forEach(this::check);
            this.terck((SeqView<TyckOrder>)tyckTasks.view());
        }
    }

    @NotNull
    public ImmutableSeq<TyckUnit> headerOrder(@NotNull ImmutableSeq<TyckOrder> forError, @NotNull ImmutableSeq<TyckUnit> stmts) {
        MutableGraph graph = MutableGraph.create();
        stmts.forEach(stmt -> {
            MutableList reference = MutableList.create();
            SigRefFinder.HEADER_ONLY.visit((TyckUnit)stmt, (MutableList<TyckUnit>)reference);
            ImmutableSeq filter = reference.filter(unit -> unit.needTyck(this.resolveInfo.thisModule().moduleName()));
            if (filter.contains(stmt)) {
                this.reporter.report((Problem)new TyckOrderError.SelfReference((TyckUnit)stmt));
                throw new SCCTyckingFailed(forError);
            }
            graph.sucMut(stmt).appendAll((Iterable)filter);
        });
        ImmutableSeq order = graph.topologicalOrder();
        ImmutableSeq cycle = order.filter(s -> s.sizeGreaterThan(1));
        if (cycle.isNotEmpty()) {
            cycle.forEach(c -> this.reporter.report((Problem)new TyckOrderError.CircularSignature((ImmutableSeq<TyckUnit>)c)));
            throw new SCCTyckingFailed(forError);
        }
        return order.flatMap(Function.identity());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkUnit(@NotNull TyckOrder order) {
        TyckUnit tyckUnit;
        if (order instanceof TyckOrder.Body && (tyckUnit = order.unit()) instanceof TeleDecl.FnDecl) {
            TeleDecl.FnDecl fn = (TeleDecl.FnDecl)tyckUnit;
            if (fn.body.isLeft()) {
                this.checkSimpleFn(order, fn);
                return;
            }
        }
        this.check(order);
        if (!(order instanceof TyckOrder.Body)) return;
        TyckOrder.Body body = (TyckOrder.Body)order;
        this.terck((SeqView<TyckOrder>)SeqView.of((Object)body));
    }

    private <T> boolean hasSuc(@NotNull MutableGraph<T> G, @NotNull MutableSet<T> book, @NotNull T vertex, @NotNull T suc) {
        if (book.contains(vertex)) {
            return false;
        }
        book.add(vertex);
        for (Object test : G.suc(vertex)) {
            if (test.equals(suc)) {
                return true;
            }
            if (!this.hasSuc(G, book, test, suc)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean selfReferencing(@NotNull MutableGraph<T> graph, @NotNull T unit) {
        return this.hasSuc(graph, MutableSet.create(), unit, unit);
    }

    private void checkSimpleFn(@NotNull TyckOrder order, @NotNull TeleDecl.FnDecl fn) {
        if (this.selfReferencing(this.resolveInfo.depGraph(), order)) {
            this.reporter.report((Problem)new BadRecursion(fn.sourcePos, fn.ref, null));
            throw new SCCTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
        this.decideTyckResult(fn, fn, this.tycker.simpleFn(this.newExprTycker(), fn));
    }

    private void check(@NotNull TyckOrder tyckOrder) {
        TyckOrder tyckOrder2 = tyckOrder;
        Objects.requireNonNull(tyckOrder2);
        TyckOrder tyckOrder3 = tyckOrder2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TyckOrder.Head.class, TyckOrder.Body.class}, (Object)tyckOrder3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                TyckOrder.Head head = (TyckOrder.Head)tyckOrder3;
                this.checkHeader(tyckOrder, head.unit());
                break;
            }
            case 1: {
                TyckOrder.Body body = (TyckOrder.Body)tyckOrder3;
                this.checkBody(tyckOrder, body.unit());
            }
        }
    }

    private void checkHeader(@NotNull TyckOrder order, @NotNull TyckUnit stmt) {
        if (stmt instanceof Decl) {
            Decl decl = (Decl)stmt;
            this.tycker.tyckHeader(decl, this.reuse(decl));
        }
        if (this.reporter.anyError()) {
            throw new SCCTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
    }

    private void checkBody(@NotNull TyckOrder order, @NotNull TyckUnit stmt) {
        TyckUnit tyckUnit = stmt;
        Objects.requireNonNull(tyckUnit);
        TyckUnit tyckUnit2 = tyckUnit;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Remark.class}, (Object)tyckUnit2, n)) {
            case 0: {
                Decl decl = (Decl)tyckUnit2;
                GenericDef def = this.tycker.tyck(decl, this.reuse(decl));
                if (!(decl instanceof Decl.TopLevel)) break;
                Decl.TopLevel topLevel = (Decl.TopLevel)((Object)decl);
                this.decideTyckResult(decl, topLevel, def);
                break;
            }
            case 1: {
                Remark remark = (Remark)tyckUnit2;
                Option.ofNullable((Object)remark.literate).forEach(l -> l.tyck(this.newExprTycker()));
                break;
            }
        }
        if (this.reporter.anyError()) {
            throw new SCCTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
    }

    private void decideTyckResult(@NotNull Decl decl, @NotNull Decl.TopLevel proof, @NotNull GenericDef def) {
        assert (decl == proof);
        switch (proof.personality()) {
            case NORMAL: {
                this.wellTyped.append((Object)def);
                this.resolveInfo.shapeFactory().bonjour(def);
                break;
            }
            case COUNTEREXAMPLE: {
                CollectingReporter sampleReporter = (CollectingReporter)this.sampleReporters.getOrPut((Object)proof, BufferReporter::new);
                ImmutableSeq problems = sampleReporter.problems().toImmutableSeq();
                if (problems.isEmpty()) {
                    this.reporter.report((Problem)new CounterexampleError(decl.sourcePos(), decl.ref()));
                }
                if (!(def instanceof UserDef)) break;
                UserDef userDef = (UserDef)def;
                userDef.problems = problems;
            }
        }
    }

    @NotNull
    private ExprTycker reuse(@NotNull Decl decl) {
        Decl decl2 = decl;
        Objects.requireNonNull(decl2);
        Decl decl3 = decl2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.TopLevel.class, TeleDecl.DataCtor.class, TeleDecl.StructField.class}, (Object)decl3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Decl.TopLevel topLevel = (Decl.TopLevel)((Object)decl3);
                yield this.reuseTopLevel(topLevel);
            }
            case 1 -> {
                TeleDecl.DataCtor ctor = (TeleDecl.DataCtor)decl3;
                yield this.reuseTopLevel((Decl.TopLevel)ctor.dataRef.concrete);
            }
            case 2 -> {
                TeleDecl.StructField field = (TeleDecl.StructField)decl3;
                yield this.reuseTopLevel((Decl.TopLevel)field.structRef.concrete);
            }
        };
    }

    @NotNull
    private ExprTycker reuseTopLevel(@NotNull Decl.TopLevel decl) {
        if (decl.personality() == Decl.Personality.COUNTEREXAMPLE) {
            CollectingReporter reporter = (CollectingReporter)this.sampleReporters.getOrPut((Object)decl, BufferReporter::new);
            return (ExprTycker)this.tyckerReuse.getOrPut((Object)decl, () -> this.newExprTycker((Reporter)reporter));
        }
        return (ExprTycker)this.tyckerReuse.getOrPut((Object)decl, this::newExprTycker);
    }

    @NotNull
    private ExprTycker newExprTycker() {
        return this.tycker.newTycker(this.resolveInfo.primFactory(), this.resolveInfo.shapeFactory());
    }

    @NotNull
    private ExprTycker newExprTycker(@NotNull Reporter reporter) {
        return new ExprTycker(this.resolveInfo.primFactory(), this.resolveInfo.shapeFactory(), reporter, this.tycker.traceBuilder());
    }

    private void terck(@NotNull SeqView<TyckOrder> units) {
        SeqView recDefs = units.filterIsInstance(TyckOrder.Body.class).filter(u -> this.selfReferencing(this.resolveInfo.depGraph(), u)).map(TyckOrder::unit);
        if (recDefs.isEmpty()) {
            return;
        }
        SeqView fn = recDefs.filterIsInstance(TeleDecl.FnDecl.class).map(f -> (FnDef)f.ref.core);
        this.terckRecursiveFn((SeqView<FnDef>)fn);
    }

    private void terckRecursiveFn(@NotNull SeqView<FnDef> fn) {
        MutableSet targets = MutableSet.from(fn);
        if (targets.isEmpty()) {
            return;
        }
        CallGraph graph = CallGraph.create();
        fn.forEach(def -> new CallResolver((FnDef)def, (MutableSet<Def>)targets, graph).accept((GenericDef)def));
        ImmutableSeq bads = graph.findBadRecursion();
        bads.view().sorted(Comparator.comparing(a -> ((Def)a.matrix().domain()).ref().concrete.sourcePos())).forEach(f -> {
            DefVar<? extends Def, ? extends Decl> ref = ((Def)f.matrix().domain()).ref();
            this.reporter.report((Problem)new BadRecursion(ref.concrete.sourcePos(), ref, (Diagonal<Def, Term.Param>)f));
        });
    }

    public static class SCCTyckingFailed
    extends InterruptException {
        @NotNull
        public final ImmutableSeq<TyckOrder> what;

        public SCCTyckingFailed(@NotNull ImmutableSeq<TyckOrder> what) {
            this.what = what;
        }

        @Override
        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Tycking;
        }
    }
}

