/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.trace;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.tyck.trace.Trace;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.NotNull;

public class MdUnicodeTrace {
    public final int indent;
    @NotNull
    public final DistillerOptions options;
    @NotNull
    public static final Doc plus = Doc.symbol((String)"+");
    @NotNull
    public static final Doc colon = Doc.symbol((String)":");

    public MdUnicodeTrace(int indent, @NotNull DistillerOptions options) {
        this.indent = indent;
        this.options = options;
    }

    public MdUnicodeTrace() {
        this(2, DistillerOptions.informative());
    }

    @NotNull
    private Doc indentedChildren(MutableList<@NotNull Trace> children) {
        return Doc.nest((int)this.indent, (Doc)Doc.vcat((SeqLike)children.view().map(this::docify)));
    }

    @NotNull
    public Doc docify(@NotNull Trace trace) {
        Trace trace2 = trace;
        Objects.requireNonNull(trace2);
        Trace trace3 = trace2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Trace.DeclT.class, Trace.LabelT.class, Trace.ExprT.class, Trace.PatT.class, Trace.TyckT.class, Trace.UnifyT.class}, (Object)trace3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Trace.DeclT t = (Trace.DeclT)trace3;
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, BaseDistiller.varDoc(t.var())}), this.indentedChildren(t.children())});
            }
            case 1 -> {
                Trace.LabelT t = (Trace.LabelT)trace3;
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, Doc.english((String)t.label())}), this.indentedChildren(t.children())});
            }
            case 2 -> {
                Trace.ExprT t = (Trace.ExprT)trace3;
                MutableList buf = MutableList.of((Object)plus, (Object)Doc.symbol((String)"\u22a2"), (Object)Doc.styled((Style)Style.code(), (Doc)t.expr().toDoc(this.options)));
                if (t.term() != null) {
                    buf.append((Object)colon);
                    buf.append((Object)Doc.styled((Style)Style.code(), (Doc)t.term().toDoc(this.options)));
                }
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((SeqLike)buf), this.indentedChildren(t.children())});
            }
            case 3 -> {
                Trace.PatT t = (Trace.PatT)trace3;
                yield Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, Doc.plain((String)"pat"), Doc.symbol((String)"\u22a2"), Doc.styled((Style)Style.code(), (Doc)t.pat().toDoc(this.options)), colon, Doc.styled((Style)Style.code(), (Doc)t.type().toDoc(this.options))}), this.indentedChildren(t.children())});
            }
            case 4 -> {
                Trace.TyckT t = (Trace.TyckT)trace3;
                if (!$assertionsDisabled && !t.children().isEmpty()) {
                    throw new AssertionError();
                }
                yield Doc.sep((Doc[])new Doc[]{plus, Doc.plain((String)"result"), Doc.symbol((String)"\u22a2"), Doc.styled((Style)Style.code(), (Doc)t.term().toDoc(this.options)), Doc.symbol((String)"\u2191"), Doc.styled((Style)Style.code(), (Doc)t.type().toDoc(this.options))});
            }
            case 5 -> {
                Trace.UnifyT t = (Trace.UnifyT)trace3;
                MutableList buf = MutableList.of((Object)plus, (Object)Doc.symbol((String)"\u22a2"), (Object)Doc.styled((Style)Style.code(), (Doc)t.lhs().toDoc(this.options)), (Object)Doc.symbol((String)"\u2261"), (Object)t.rhs().toDoc(this.options));
                if (t.type() != null) {
                    buf.append((Object)colon);
                    buf.append((Object)Doc.styled((Style)Style.code(), (Doc)t.type().toDoc(this.options)));
                }
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((SeqLike)buf), this.indentedChildren(t.children())});
            }
        };
    }

    @NotNull
    public Doc docify(@NotNull Trace.Builder traceBuilder) {
        return Doc.vcatNonEmpty((SeqLike)traceBuilder.root().view().map(this::docify));
    }
}

