/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Either;
import kala.tuple.Tuple2;
import kala.value.MutableValue;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.visitor.ExprView;
import org.aya.core.pat.Pat;
import org.aya.distill.BaseDistiller;
import org.aya.distill.ConcreteDistiller;
import org.aya.generic.AyaDocile;
import org.aya.generic.ParamLike;
import org.aya.generic.SortKind;
import org.aya.guest0x0.cubical.Restr;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.ExprTycker;
import org.aya.util.binop.BinOpParser;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Expr
extends AyaDocile,
SourceNode,
Restr.TermLike<Expr> {
    @Contract(pure=true)
    default public Expr resolve(@NotNull ModuleContext context) {
        ExprResolver exprResolver = new ExprResolver(ExprResolver.RESTRICTIVE);
        exprResolver.enterBody();
        return exprResolver.resolve(this, context);
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new ConcreteDistiller(options).term(BaseDistiller.Outer.Free, this);
    }

    @NotNull
    public static Expr unapp(@NotNull Expr expr, @Nullable MutableList<NamedArg> args) {
        while (expr instanceof AppExpr) {
            AppExpr app = (AppExpr)expr;
            if (args != null) {
                args.append((Object)app.argument);
            }
            expr = app.function;
        }
        if (args != null) {
            args.reverse();
        }
        return expr;
    }

    @NotNull
    default public ExprView view() {
        return () -> this;
    }

    public record AppExpr(@NotNull SourcePos sourcePos, @NotNull Expr function, @NotNull NamedArg argument) implements Expr
    {
    }

    public static final class NamedArg
    extends Record
    implements AyaDocile,
    SourceNode,
    BinOpParser.Elem<Expr> {
        private final boolean explicit;
        @Nullable
        private final String name;
        @NotNull
        private final Expr expr;

        public NamedArg(boolean explicit, @NotNull Expr expr) {
            this(explicit, null, expr);
        }

        public NamedArg(boolean explicit, @Nullable String name, @NotNull Expr expr) {
            this.explicit = explicit;
            this.name = name;
            this.expr = expr;
        }

        @Override
        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            Doc doc = this.name == null ? this.expr.toDoc(options) : Doc.braced((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)this.name), Doc.symbol((String)"=>"), this.expr.toDoc(options)}));
            return Doc.bracedUnless((Doc)doc, (boolean)this.explicit);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.expr.sourcePos();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NamedArg.class, "explicit;name;expr", "explicit", "name", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NamedArg.class, "explicit;name;expr", "explicit", "name", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NamedArg.class, "explicit;name;expr", "explicit", "name", "expr"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @Nullable
        public String name() {
            return this.name;
        }

        @NotNull
        public Expr expr() {
            return this.expr;
        }
    }

    public record Array(@NotNull SourcePos sourcePos, @NotNull Either<CompBlock, ElementList> arrayBlock) implements Expr
    {
        public static Array newList(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Expr> exprs, @NotNull Expr nilCtor, @NotNull Expr consCtor) {
            return new Array(sourcePos, (Either<CompBlock, ElementList>)Either.right((Object)new ElementList(exprs, nilCtor, consCtor)));
        }

        public static Array newGenerator(@NotNull SourcePos sourcePos, @NotNull Expr generator, @NotNull ImmutableSeq<DoBind> bindings, @NotNull Expr bindName, @NotNull Expr pureName) {
            return new Array(sourcePos, (Either<CompBlock, ElementList>)Either.left((Object)new CompBlock(generator, bindings, bindName, pureName)));
        }

        public record ElementList(@NotNull ImmutableSeq<Expr> exprList, @NotNull Expr nilCtor, @NotNull Expr consCtor) {
        }

        public record CompBlock(@NotNull Expr generator, @NotNull ImmutableSeq<DoBind> binds, @NotNull Expr bindName, @NotNull Expr pureName) {
        }
    }

    public static final class Param
    extends Record
    implements ParamLike<Expr> {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final LocalVar ref;
        @NotNull
        private final Expr type;
        private final boolean explicit;

        public Param(@NotNull Param param, @NotNull Expr type) {
            this(param.sourcePos, param.ref, type, param.explicit);
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar var, boolean explicit) {
            this(sourcePos, var, new HoleExpr(sourcePos, false, null), explicit);
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar ref, @NotNull Expr type, boolean explicit) {
            this.sourcePos = sourcePos;
            this.ref = ref;
            this.type = type;
            this.explicit = explicit;
        }

        @NotNull
        public Param mapExpr(@NotNull @NotNull Function<@NotNull Expr, @NotNull Expr> mapper) {
            return new Param(this.sourcePos, this.ref, mapper.apply(this.type), this.explicit);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Param.class, "sourcePos;ref;type;explicit", "sourcePos", "ref", "type", "explicit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Param.class, "sourcePos;ref;type;explicit", "sourcePos", "ref", "type", "explicit"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Param.class, "sourcePos;ref;type;explicit", "sourcePos", "ref", "type", "explicit"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @Override
        @NotNull
        public LocalVar ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public Expr type() {
            return this.type;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }
    }

    public record Path(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<LocalVar> params, @NotNull Expr type, @NotNull PartEl partial) implements Expr
    {
    }

    public record PartEl(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Tuple2<Expr, Expr>> clauses) implements Expr
    {
    }

    public record BinOpSeq(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<NamedArg> seq) implements Expr
    {
    }

    public record MetaPat(@NotNull SourcePos sourcePos, Pat.Meta meta) implements Expr
    {
    }

    public record LitStringExpr(@NotNull SourcePos sourcePos, @NotNull String string) implements Expr
    {
    }

    public record LitIntExpr(@NotNull SourcePos sourcePos, int integer) implements Expr
    {
    }

    public record Field(@NotNull WithPos<String> name, @NotNull ImmutableSeq<WithPos<LocalVar>> bindings, @NotNull Expr body, @NotNull MutableValue<AnyVar> resolvedField) {
    }

    public record NewExpr(@NotNull SourcePos sourcePos, @NotNull Expr struct, @NotNull ImmutableSeq<Field> fields) implements Expr
    {
    }

    public record ProjExpr(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, QualifiedID> ix, @Nullable AnyVar resolvedIx, @NotNull MutableValue<ExprTycker.Result> theCore) implements Expr,
    WithTerm
    {
        public ProjExpr(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, QualifiedID> ix) {
            this(sourcePos, tup, ix, null, (MutableValue<ExprTycker.Result>)MutableValue.create());
        }
    }

    public record TupExpr(@NotNull SourcePos sourcePos, @NotNull @NotNull ImmutableSeq<@NotNull Expr> items) implements Expr
    {
    }

    public record ISetExpr(@NotNull SourcePos sourcePos) implements SortExpr
    {
        @Override
        public int lift() {
            return 0;
        }

        @Override
        public SortKind kind() {
            return SortKind.ISet;
        }
    }

    public record PropExpr(@NotNull SourcePos sourcePos) implements SortExpr
    {
        @Override
        public int lift() {
            return 0;
        }

        @Override
        public SortKind kind() {
            return SortKind.Prop;
        }
    }

    public record SetExpr(@NotNull SourcePos sourcePos, int lift) implements SortExpr
    {
        @Override
        public SortKind kind() {
            return SortKind.Set;
        }
    }

    public record TypeExpr(@NotNull SourcePos sourcePos, int lift) implements SortExpr
    {
        @Override
        public SortKind kind() {
            return SortKind.Type;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SortExpr
    extends Expr {
        public int lift();

        public SortKind kind();
    }

    public record RawSortExpr(@NotNull SourcePos sourcePos, @NotNull SortKind kind) implements Expr
    {
    }

    public record LiftExpr(@NotNull SourcePos sourcePos, @NotNull Expr expr, int lift) implements Expr
    {
    }

    public record RefExpr(@NotNull SourcePos sourcePos, @NotNull AnyVar resolvedVar, @NotNull MutableValue<ExprTycker.Result> theCore) implements Expr,
    WithTerm
    {
        public RefExpr(@NotNull SourcePos sourcePos, @NotNull AnyVar resolvedVar) {
            this(sourcePos, resolvedVar, (MutableValue<ExprTycker.Result>)MutableValue.create());
        }
    }

    public record SigmaExpr(@NotNull SourcePos sourcePos, boolean co, @NotNull @NotNull ImmutableSeq<@NotNull Param> params) implements Expr
    {
    }

    public record LamExpr(@NotNull SourcePos sourcePos, @NotNull Param param, @NotNull Expr body) implements Expr
    {
    }

    public record IdiomNames(@NotNull Expr alternativeEmpty, @NotNull Expr alternativeOr, @NotNull Expr applicativeAp, @NotNull Expr applicativePure) {
        public IdiomNames fmap(@NotNull Function<Expr, Expr> f) {
            return new IdiomNames(f.apply(this.alternativeEmpty), f.apply(this.alternativeOr), f.apply(this.applicativeAp), f.apply(this.applicativePure));
        }

        public boolean identical(@NotNull IdiomNames names) {
            return this.alternativeEmpty == names.alternativeEmpty && this.alternativeOr == names.alternativeOr && this.applicativeAp == names.applicativeAp && this.applicativePure == names.applicativePure;
        }
    }

    public record Idiom(@NotNull SourcePos sourcePos, @NotNull IdiomNames names, @NotNull ImmutableSeq<Expr> barredApps) implements Expr
    {
    }

    public record DoBind(@NotNull SourcePos sourcePos, @NotNull LocalVar var, @NotNull Expr expr) {
    }

    public record Do(@NotNull SourcePos sourcePos, @NotNull Expr bindName, @NotNull ImmutableSeq<DoBind> binds) implements Expr
    {
    }

    public record PiExpr(@NotNull SourcePos sourcePos, boolean co, @NotNull Param param, @NotNull Expr last) implements Expr
    {
    }

    public record HoleExpr(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling, MutableValue<ImmutableSeq<LocalVar>> accessibleLocal) implements Expr
    {
        public HoleExpr(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling) {
            this(sourcePos, explicit, filling, (MutableValue<ImmutableSeq<LocalVar>>)MutableValue.create());
        }
    }

    public record ErrorExpr(@NotNull SourcePos sourcePos, @NotNull AyaDocile description) implements Expr
    {
        public ErrorExpr(@NotNull SourcePos sourcePos, @NotNull Doc description) {
            this(sourcePos, (DistillerOptions options) -> description);
        }
    }

    public record UnresolvedExpr(@NotNull SourcePos sourcePos, @NotNull QualifiedID name) implements Expr
    {
        public UnresolvedExpr(@NotNull SourcePos sourcePos, @NotNull String name) {
            this(sourcePos, new QualifiedID(sourcePos, name));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WithTerm
    extends Expr {
        @NotNull
        public MutableValue<ExprTycker.Result> theCore();

        @Nullable
        default public ExprTycker.Result core() {
            return (ExprTycker.Result)this.theCore().get();
        }
    }
}

