/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import kala.collection.SeqLike;
import kala.tuple.Unit;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.desugar.Desugarer;
import org.aya.distill.ConcreteDistiller;
import org.aya.generic.AyaDocile;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.module.ModuleLoader;
import org.aya.resolve.visitor.StmtResolver;
import org.aya.resolve.visitor.StmtShallowResolver;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Stmt
extends AyaDocile,
TyckUnit {
    @Contract(pure=true)
    @NotNull
    public Accessibility accessibility();

    @Contract(mutates="param1")
    public static void resolve(@NotNull SeqLike<Stmt> statements, @NotNull ResolveInfo resolveInfo, @NotNull ModuleLoader loader) {
        StmtShallowResolver shallowResolver = new StmtShallowResolver(loader, resolveInfo);
        shallowResolver.resolveStmt(statements, resolveInfo.thisModule());
        StmtResolver.resolveStmt(statements, resolveInfo);
        StmtResolver.resolveBind(statements, resolveInfo);
        AyaBinOpSet opSet = resolveInfo.opSet();
        opSet.reportIfCyclic();
        statements.forEach(s -> s.desugar(resolveInfo));
    }

    default public void desugar(@NotNull ResolveInfo resolveInfo) {
        new Desugarer(resolveInfo).visit(this, Unit.unit());
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new ConcreteDistiller(options).stmt(this);
    }

    public static enum Accessibility {
        Private("private"),
        Public("public");

        @NotNull
        public final String keyword;

        private Accessibility(String keyword) {
            this.keyword = keyword;
        }
    }
}

