/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.concrete.Expr;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public interface ExprView {
    @NotNull
    public Expr initial();

    @NotNull
    default public Expr pre(@NotNull Expr expr) {
        return expr;
    }

    @NotNull
    default public Expr post(@NotNull Expr expr) {
        return expr;
    }

    @NotNull
    private Expr commit(@NotNull Expr expr) {
        return this.post(this.traverse(this.pre(expr)));
    }

    private @NotNull Expr.Param commit(@NotNull Expr.Param param) {
        Expr type = this.commit(param.type());
        if (type == param.type()) {
            return param;
        }
        return new Expr.Param(param, type);
    }

    private @NotNull Expr.NamedArg commit(@NotNull Expr.NamedArg arg) {
        Expr expr = this.commit(arg.expr());
        if (expr == arg.expr()) {
            return arg;
        }
        return new Expr.NamedArg(arg.explicit(), expr);
    }

    private @NotNull Expr.PartEl commit(@NotNull Expr.PartEl partial) {
        ImmutableSeq clauses = partial.clauses().map(cls -> Tuple.of((Object)this.commit((Expr)cls._1), (Object)this.commit((Expr)cls._2)));
        if (clauses.allMatchWith(partial.clauses(), (l, r) -> l._1 == r._1 && l._2 == r._2)) {
            return partial;
        }
        return new Expr.PartEl(partial.sourcePos(), (ImmutableSeq<Tuple2<Expr, Expr>>)clauses);
    }

    @NotNull
    private Expr traverse(@NotNull Expr expr) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.RefExpr.class, Expr.UnresolvedExpr.class, Expr.LamExpr.class, Expr.PiExpr.class, Expr.SigmaExpr.class, Expr.RawSortExpr.class, Expr.LiftExpr.class, Expr.SortExpr.class, Expr.AppExpr.class, Expr.HoleExpr.class, Expr.TupExpr.class, Expr.ProjExpr.class, Expr.NewExpr.class, Expr.PartEl.class, Expr.Path.class, Expr.LitIntExpr.class, Expr.LitStringExpr.class, Expr.BinOpSeq.class, Expr.ErrorExpr.class, Expr.MetaPat.class, Expr.Idiom.class, Expr.Do.class, Expr.Array.class}, (Object)expr3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Expr.RefExpr ref;
                yield ref = (Expr.RefExpr)expr3;
            }
            case 1 -> {
                Expr.UnresolvedExpr unresolved = (Expr.UnresolvedExpr)expr3;
                yield unresolved;
            }
            case 2 -> {
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                Expr.Param param = this.commit(lam.param());
                Expr body = this.commit(lam.body());
                if (param == lam.param() && body == lam.body()) {
                    yield lam;
                }
                yield new Expr.LamExpr(lam.sourcePos(), param, body);
            }
            case 3 -> {
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                Expr.Param param = this.commit(pi.param());
                Expr last = this.commit(pi.last());
                if (param == pi.param() && last == pi.last()) {
                    yield pi;
                }
                yield new Expr.PiExpr(pi.sourcePos(), pi.co(), param, last);
            }
            case 4 -> {
                Expr.SigmaExpr sigma = (Expr.SigmaExpr)expr3;
                ImmutableSeq params = sigma.params().map(this::commit);
                if (params.sameElements(sigma.params(), true)) {
                    yield sigma;
                }
                yield new Expr.SigmaExpr(sigma.sourcePos(), sigma.co(), (ImmutableSeq<Expr.Param>)params);
            }
            case 5 -> {
                Expr.RawSortExpr rawType = (Expr.RawSortExpr)expr3;
                yield rawType;
            }
            case 6 -> {
                Expr.LiftExpr lift = (Expr.LiftExpr)expr3;
                Expr inner = this.commit(lift.expr());
                if (inner == lift.expr()) {
                    yield lift;
                }
                yield new Expr.LiftExpr(lift.sourcePos(), inner, lift.lift());
            }
            case 7 -> {
                Expr.SortExpr univ = (Expr.SortExpr)expr3;
                yield univ;
            }
            case 8 -> {
                Object var15_18;
                SourcePos pos = var15_18 = ExprView.$proxy$sourcePos((Expr.AppExpr)expr3);
                Object f = var15_18 = ExprView.$proxy$function((Expr.AppExpr)expr3);
                Object a = var15_18 = ExprView.$proxy$argument((Expr.AppExpr)expr3);
                Expr func = this.commit((Expr)f);
                Expr.NamedArg arg = this.commit((Expr.NamedArg)a);
                if (func == f && arg == a) {
                    yield expr;
                }
                yield new Expr.AppExpr(pos, func, arg);
            }
            case 9 -> {
                Expr committed;
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                Expr filling = hole.filling();
                Expr v2 = committed = filling != null ? this.commit(filling) : null;
                if (committed == filling) {
                    yield hole;
                }
                yield new Expr.HoleExpr(hole.sourcePos(), hole.explicit(), committed, hole.accessibleLocal());
            }
            case 10 -> {
                Expr.TupExpr tup = (Expr.TupExpr)expr3;
                ImmutableSeq items = tup.items().map(this::commit);
                if (items.sameElements(tup.items(), true)) {
                    yield tup;
                }
                yield new Expr.TupExpr(tup.sourcePos(), (ImmutableSeq<Expr>)items);
            }
            case 11 -> {
                Expr.ProjExpr proj = (Expr.ProjExpr)expr3;
                Expr tup = this.commit(proj.tup());
                if (tup == proj.tup()) {
                    yield proj;
                }
                yield new Expr.ProjExpr(proj.sourcePos(), tup, proj.ix(), proj.resolvedIx(), proj.theCore());
            }
            case 12 -> {
                Expr.NewExpr neu = (Expr.NewExpr)expr3;
                Expr struct = this.commit(neu.struct());
                ImmutableSeq fields = neu.fields().map(field -> new Expr.Field(field.name(), field.bindings(), this.commit(field.body()), field.resolvedField()));
                if (struct == neu.struct() && fields.sameElements(neu.fields(), true)) {
                    yield neu;
                }
                yield new Expr.NewExpr(neu.sourcePos(), struct, (ImmutableSeq<Expr.Field>)fields);
            }
            case 13 -> {
                Expr.PartEl el = (Expr.PartEl)expr3;
                yield this.commit(el);
            }
            case 14 -> {
                Expr.Path path = (Expr.Path)expr3;
                Expr.PartEl partial = this.commit(path.partial());
                Expr type = this.commit(path.type());
                if (partial == path.partial() && type == path.type()) {
                    yield path;
                }
                yield new Expr.Path(path.sourcePos(), path.params(), type, partial);
            }
            case 15 -> {
                Expr.LitIntExpr litInt = (Expr.LitIntExpr)expr3;
                yield litInt;
            }
            case 16 -> {
                Expr.LitStringExpr litStr = (Expr.LitStringExpr)expr3;
                yield litStr;
            }
            case 17 -> {
                Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr3;
                ImmutableSeq seq = binOpSeq.seq().map(this::commit);
                if (seq.sameElements(binOpSeq.seq(), true)) {
                    yield binOpSeq;
                }
                yield new Expr.BinOpSeq(binOpSeq.sourcePos(), (ImmutableSeq<Expr.NamedArg>)seq);
            }
            case 18 -> {
                Expr.ErrorExpr error = (Expr.ErrorExpr)expr3;
                yield error;
            }
            case 19 -> {
                Expr.MetaPat meta = (Expr.MetaPat)expr3;
                yield meta;
            }
            case 20 -> {
                Expr.Idiom idiom = (Expr.Idiom)expr3;
                ImmutableSeq newInner = idiom.barredApps().map(this::commit);
                Expr.IdiomNames newNames = idiom.names().fmap(this::commit);
                if (newInner.sameElements(idiom.barredApps()) && newNames.identical(idiom.names())) {
                    yield expr;
                }
                yield new Expr.Idiom(idiom.sourcePos(), newNames, (ImmutableSeq<Expr>)newInner);
            }
            case 21 -> {
                Expr.Do doNotation = (Expr.Do)expr3;
                ImmutableSeq lamExprs = doNotation.binds().map(x -> new Expr.DoBind(x.sourcePos(), x.var(), this.commit(x.expr())));
                Expr bindName = this.commit(doNotation.bindName());
                if (lamExprs.sameElements(doNotation.binds()) && bindName == doNotation.bindName()) {
                    yield doNotation;
                }
                yield new Expr.Do(doNotation.sourcePos(), bindName, (ImmutableSeq<Expr.DoBind>)lamExprs);
            }
            case 22 -> {
                Expr.Array arrayExpr = (Expr.Array)expr3;
                yield (Expr.Array)arrayExpr.arrayBlock().fold(left -> {
                    Expr generator = this.commit(left.generator());
                    ImmutableSeq bindings = left.binds().map(binding -> new Expr.DoBind(binding.sourcePos(), binding.var(), this.commit(binding.expr())));
                    Expr bindName = this.commit(left.bindName());
                    Expr pureName = this.commit(left.pureName());
                    if (generator == left.generator() && bindings.sameElements(left.binds()) && bindName == left.bindName() && pureName == left.pureName()) {
                        return arrayExpr;
                    }
                    return Expr.Array.newGenerator(arrayExpr.sourcePos(), generator, (ImmutableSeq<Expr.DoBind>)bindings, bindName, pureName);
                }, right -> {
                    ImmutableSeq exprs = right.exprList().map(this::commit);
                    Expr nilCtor = this.commit(right.nilCtor());
                    Expr consCtor = this.commit(right.consCtor());
                    if (exprs.sameElements(right.exprList()) && nilCtor == right.nilCtor() && consCtor == right.consCtor()) {
                        return arrayExpr;
                    }
                    return Expr.Array.newList(arrayExpr.sourcePos(), (ImmutableSeq<Expr>)exprs, nilCtor, consCtor);
                });
            }
        };
    }

    @NotNull
    default public Expr commit() {
        return this.commit(this.initial());
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Expr.AppExpr arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Expr $proxy$function(Expr.AppExpr arg0) {
        try {
            return arg0.function();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Expr.NamedArg $proxy$argument(Expr.AppExpr arg0) {
        try {
            return arg0.argument();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }
}

