/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.core.def.Def;
import org.aya.core.def.GenericDef;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ShapeMatcher;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AyaShape {
    @NotNull
    public static final AyaShape NAT_SHAPE = new AyaIntLitShape();
    @NotNull
    public static final ImmutableSeq<AyaShape> LITERAL_SHAPES = ImmutableSeq.of((Object)NAT_SHAPE);

    @NotNull
    public CodeShape codeShape();

    public record AyaIntLitShape() implements AyaShape
    {
        @NotNull
        public static final CodeShape DATA_NAT = new CodeShape.DataShape((ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.empty(), (ImmutableSeq<CodeShape.CtorShape>)ImmutableSeq.of((Object)new CodeShape.CtorShape((ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.empty()), (Object)new CodeShape.CtorShape((ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.of((Object)CodeShape.ParamShape.ex(new CodeShape.TermShape.Call(0))))));

        @Override
        @NotNull
        public CodeShape codeShape() {
            return DATA_NAT;
        }
    }

    public static class Factory {
        @NotNull
        public MutableMap<GenericDef, AyaShape> discovered = MutableLinkedHashMap.of();

        @NotNull
        public ImmutableSeq<GenericDef> findImpl(@NotNull AyaShape shape) {
            return this.discovered.view().map(Tuple::of).filter(t -> t._2 == shape).map(t -> (GenericDef)t._1).toImmutableSeq();
        }

        @NotNull
        public Option<AyaShape> find(@NotNull Def def) {
            return this.discovered.getOption((Object)def);
        }

        public void bonjour(@NotNull GenericDef def, @NotNull AyaShape shape) {
            this.discovered.put((Object)def, (Object)shape);
        }

        public void bonjour(@NotNull GenericDef def) {
            LITERAL_SHAPES.view().filter(shape -> ShapeMatcher.match(shape.codeShape(), def)).forEach(shape -> this.bonjour(def, (AyaShape)shape));
        }

        public void importAll(@NotNull Factory other) {
            this.discovered.putAll(other.discovered);
        }
    }
}

