/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.pat.Pat;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerTerm;
import org.aya.ref.DefVar;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SerPat
extends Serializable {
    @NotNull
    public Pat de(@NotNull SerTerm.DeState var1);

    public record ShapedInt(int integer, boolean explicit, @NotNull SerDef.SerAyaShape shape, @NotNull SerTerm.DataCall type) implements SerPat
    {
        @Override
        @NotNull
        public Pat de(@NotNull SerTerm.DeState state) {
            return new Pat.ShapedInt(this.integer, this.shape.de(), this.type.de(state), this.explicit);
        }
    }

    public record End(boolean isOne, boolean explicit) implements SerPat
    {
        @Override
        @NotNull
        public Pat de(@NotNull SerTerm.DeState state) {
            return new Pat.End(this.isOne, this.explicit);
        }
    }

    public record Ctor(boolean explicit, @NotNull SerDef.QName name, @NotNull ImmutableSeq<SerPat> params, @NotNull SerTerm.DataCall ty) implements SerPat
    {
        @Override
        @NotNull
        public Pat de(@NotNull SerTerm.DeState state) {
            return new Pat.Ctor(this.explicit, (DefVar<CtorDef, TeleDecl.DataCtor>)state.resolve(this.name), (ImmutableSeq<Pat>)this.params.map(param -> param.de(state)), this.ty.de(state));
        }
    }

    public record Bind(boolean explicit, @NotNull SerTerm.SimpVar var, @NotNull SerTerm ty) implements SerPat
    {
        @Override
        @NotNull
        public Pat de(@NotNull SerTerm.DeState state) {
            return new Pat.Bind(this.explicit, this.var.de(state), this.ty.de(state));
        }
    }

    public record Tuple(boolean explicit, @NotNull ImmutableSeq<SerPat> pats) implements SerPat
    {
        @Override
        @NotNull
        public Pat de(@NotNull SerTerm.DeState state) {
            return new Pat.Tuple(this.explicit, (ImmutableSeq<Pat>)this.pats.map(pat -> pat.de(state)));
        }
    }

    public record Absurd(boolean explicit) implements SerPat
    {
        @Override
        @NotNull
        public Pat de(@NotNull SerTerm.DeState state) {
            return new Pat.Absurd(this.explicit);
        }
    }

    public record Matchy(@NotNull ImmutableSeq<SerPat> pats, @NotNull SerTerm body) implements Serializable
    {
        @NotNull
        public Matching de(@NotNull SerTerm.DeState state) {
            return new Matching(SourcePos.SER, (ImmutableSeq<Pat>)this.pats.map(pat -> pat.de(state)), this.body.de(state));
        }
    }
}

