/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.serde.SerDef;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.LitTerm;
import org.aya.core.term.PrimTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.generic.Arg;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SerTerm
extends Serializable,
Restr.TermLike<SerTerm> {
    @NotNull
    public Term de(@NotNull DeState var1);

    public record SerCube(@NotNull ImmutableSeq<SimpVar> params, @NotNull SerTerm type, @NotNull Partial<SerTerm> partial) implements Serializable
    {
        @NotNull
        public FormTerm.Cube de(@NotNull DeState state) {
            return new FormTerm.Cube((ImmutableSeq<LocalVar>)this.params.map(p -> p.de(state)), this.type.de(state), (Partial<Term>)this.partial.fmap(t -> t.de(state)));
        }
    }

    public record Coe(@NotNull SerTerm type, @NotNull Restr<SerTerm> restr) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PrimTerm.Coe(this.type.de(state), (Restr<Term>)this.restr.fmap(t -> t.de(state)));
        }
    }

    public record PathApp(@NotNull SerTerm of, @NotNull ImmutableSeq<SerArg> args, @NotNull SerCube cube) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ElimTerm.PathApp(this.of.de(state), (ImmutableSeq<Arg<Term>>)this.args.map(arg -> arg.de(state)), this.cube.de(state));
        }
    }

    public record PathLam(@NotNull ImmutableSeq<SimpVar> params, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.PathLam((ImmutableSeq<LocalVar>)this.params.map(p -> p.de(state)), this.body.de(state));
        }
    }

    public record Path(@NotNull SerCube cube) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Path(this.cube.de(state));
        }
    }

    public record PartTy(@NotNull SerTerm type, @NotNull Restr<SerTerm> restr) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.PartTy(this.type.de(state), (Restr<Term>)this.restr.fmap(t -> t.de(state)));
        }
    }

    public record PartEl(@NotNull Partial<SerTerm> partial, @NotNull SerTerm rhsType) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.PartEl((Partial<Term>)this.partial.fmap(t -> t.de(state)), this.rhsType.de(state));
        }
    }

    public record Str(@NotNull String string) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PrimTerm.Str(this.string);
        }
    }

    public record ShapedInt(int integer, @NotNull SerDef.SerAyaShape shape, @NotNull SerTerm type) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new LitTerm.ShapedInt(this.integer, this.shape.de(), this.type.de(state));
        }
    }

    public record Mula(@NotNull Formula<SerTerm> formula) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PrimTerm.Mula((Formula<Term>)this.formula.fmap(t -> t.de(state)));
        }
    }

    public record Interval() implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return PrimTerm.Interval.INSTANCE;
        }
    }

    public record FieldRef(@NotNull SerDef.QName name) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm.Field((DefVar<FieldDef, TeleDecl.StructField>)state.resolve(this.name));
        }
    }

    public record Access(@NotNull SerTerm of, @NotNull SerDef.QName ref, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> structArgs, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> fieldArgs) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Access(this.of.de(state), (DefVar<FieldDef, TeleDecl.StructField>)state.resolve(this.ref), (ImmutableSeq<Arg<Term>>)this.structArgs.map(arg -> arg.de(state)), (ImmutableSeq<Arg<Term>>)this.fieldArgs.map(arg -> arg.de(state)));
        }
    }

    public record Tup(@NotNull ImmutableSeq<SerTerm> components) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.Tuple((ImmutableSeq<Term>)this.components.map(t -> t.de(state)));
        }
    }

    public record ConCall(@NotNull SerDef.QName dataRef, @NotNull SerDef.QName selfRef, @NotNull CallData dataArgs, @NotNull ImmutableSeq<SerArg> conArgs) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Con((DefVar<DataDef, TeleDecl.DataDecl>)state.resolve(this.dataRef), (DefVar<CtorDef, TeleDecl.DataCtor>)state.resolve(this.selfRef), this.dataArgs.de(state), this.dataArgs.ulift, (ImmutableSeq<Arg<Term>>)this.conArgs.map(arg -> arg.de(state)));
        }
    }

    public record PrimCall(@NotNull SerDef.QName name, @NotNull PrimDef.ID id, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Prim((DefVar<PrimDef, TeleDecl.PrimDecl>)state.resolve(this.name), this.id, this.data.ulift, this.data.de(state));
        }
    }

    public record DataCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public CallTerm.Data de(@NotNull DeState state) {
            return new CallTerm.Data((DefVar<DataDef, TeleDecl.DataDecl>)state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record FnCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Fn((DefVar<FnDef, TeleDecl.FnDecl>)state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record StructCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public CallTerm.Struct de(@NotNull DeState state) {
            return new CallTerm.Struct((DefVar<StructDef, TeleDecl.StructDecl>)state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record CallData(int ulift, @NotNull ImmutableSeq<SerArg> args) implements Serializable
    {
        @NotNull
        public ImmutableSeq<Arg<Term>> de(@NotNull DeState state) {
            return this.args.map(arg -> arg.de(state));
        }
    }

    public record App(@NotNull SerTerm of, @NotNull SerArg arg) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ElimTerm.App(this.of.de(state), this.arg.de(state));
        }
    }

    public record SerArg(@NotNull SerTerm arg, boolean explicit) implements Serializable
    {
        @NotNull
        public Arg<Term> de(@NotNull DeState state) {
            return new Arg<Term>(this.arg.de(state), this.explicit);
        }
    }

    public record Proj(@NotNull SerTerm of, int ix) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ElimTerm.Proj(this.of.de(state), this.ix);
        }
    }

    public record New(@NotNull StructCall call, @NotNull ImmutableMap<SerDef.QName, SerTerm> map) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.New(this.call.de(state), (ImmutableMap<DefVar<FieldDef, TeleDecl.StructField>, Term>)ImmutableMap.from((Iterable)this.map.view().map((k, v) -> Tuple.of(state.resolve((SerDef.QName)k), (Object)v.de(state)))));
        }
    }

    public record Lam(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.Lambda(this.param.de(state), this.body.de(state));
        }
    }

    public record Ref(@NotNull SimpVar var) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm(this.var.de(state));
        }
    }

    public record ISet() implements Sort
    {
        @Override
        @NotNull
        public FormTerm.ISet de(@NotNull DeState state) {
            return FormTerm.ISet.INSTANCE;
        }
    }

    public record Prop() implements Sort
    {
        @Override
        @NotNull
        public FormTerm.Prop de(@NotNull DeState state) {
            return FormTerm.Prop.INSTANCE;
        }
    }

    public record Set(int ulift) implements Sort
    {
        @Override
        @NotNull
        public FormTerm.Set de(@NotNull DeState state) {
            return new FormTerm.Set(this.ulift);
        }
    }

    public record Type(int ulift) implements Sort
    {
        @Override
        @NotNull
        public FormTerm.Type de(@NotNull DeState state) {
            return new FormTerm.Type(this.ulift);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Sort
    extends SerTerm {
        @Override
        @NotNull
        public FormTerm.Sort de(@NotNull DeState var1);
    }

    public record Sigma(@NotNull ImmutableSeq<SerParam> params) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Sigma((ImmutableSeq<Term.Param>)this.params.map(p -> p.de(state)));
        }
    }

    public record Pi(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Pi(this.param.de(state), this.body.de(state));
        }
    }

    public record SerParam(boolean explicit, @NotNull SimpVar var, @NotNull SerTerm term) implements Serializable
    {
        @NotNull
        public Term.Param de(@NotNull DeState state) {
            return new Term.Param(this.var.de(state), this.term.de(state), this.explicit);
        }
    }

    public record SimpVar(int var, @NotNull String name) implements Serializable
    {
        @NotNull
        public LocalVar de(@NotNull DeState state) {
            return state.var(this);
        }
    }

    public record DeState(@NotNull MutableMap<Seq<String>, MutableMap<String, DefVar<?, ?>>> defCache, @NotNull MutableMap<Integer, LocalVar> localCache, @NotNull PrimDef.Factory primFactory) {
        public DeState(@NotNull PrimDef.Factory primFactory) {
            this(MutableMap.create(), (MutableMap<Integer, LocalVar>)MutableMap.create(), primFactory);
        }

        @NotNull
        public LocalVar var(@NotNull SimpVar var) {
            return (LocalVar)this.localCache.getOrPut((Object)var.var, () -> new LocalVar(var.name));
        }

        @NotNull
        public <V extends DefVar<?, ?>> V resolve(@NotNull SerDef.QName name) {
            DefVar dv = (DefVar)((MutableMap)this.defCache.getOrThrow(name.mod(), () -> new SerDef.DeserializeException("Unable to find module: " + String.valueOf(name.mod())))).getOrThrow((Object)name.name(), () -> new SerDef.DeserializeException("Unable to find DefVar: " + String.valueOf(name)));
            assert (Objects.equals(name.name(), dv.name()));
            return (V)dv;
        }

        @NotNull
        <V extends DefVar<?, ?>> V newDef(@NotNull SerDef.QName name) {
            DefVar defVar = DefVar.empty(name.name());
            Option old = ((MutableMap)this.defCache.getOrPut(name.mod(), MutableHashMap::new)).put((Object)name.name(), defVar);
            if (old.isDefined()) {
                throw new SerDef.DeserializeException("Same definition deserialized twice: " + String.valueOf(name));
            }
            defVar.module = name.mod();
            return (V)defVar;
        }

        public void putPrim(@NotNull ImmutableSeq<String> mod, @NotNull PrimDef.ID id, @NotNull DefVar<?, ?> defVar) {
            Option old = ((MutableMap)this.defCache.getOrPut(mod, MutableHashMap::new)).put((Object)id.id, defVar);
            if (old.isDefined()) {
                throw new SerDef.DeserializeException("Same prim deserialized twice: " + id.id);
            }
            defVar.module = mod;
        }
    }
}

