/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.core.term.CallTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermConsumer;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public interface VarConsumer
extends TermConsumer {
    public void var(@NotNull AnyVar var1);

    @Override
    default public void accept(@NotNull Term term) {
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.class, RefTerm.Field.class, CallTerm.Hole.class, CallTerm.Fn.class, CallTerm.Prim.class, CallTerm.Data.class, CallTerm.Con.class, CallTerm.Struct.class}, (Object)term3, n)) {
            case 0: {
                RefTerm ref = (RefTerm)term3;
                this.var(ref.var());
                break;
            }
            case 1: {
                RefTerm.Field field = (RefTerm.Field)term3;
                this.var(field.ref());
                break;
            }
            case 2: {
                CallTerm.Hole hole = (CallTerm.Hole)term3;
                this.var(hole.ref());
                break;
            }
            case 3: {
                CallTerm.Fn fn = (CallTerm.Fn)term3;
                this.var(fn.ref());
                break;
            }
            case 4: {
                CallTerm.Prim prim = (CallTerm.Prim)term3;
                this.var(prim.ref());
                break;
            }
            case 5: {
                CallTerm.Data data = (CallTerm.Data)term3;
                this.var(data.ref());
                break;
            }
            case 6: {
                CallTerm.Con con = (CallTerm.Con)term3;
                this.var(con.ref());
                break;
            }
            case 7: {
                CallTerm.Struct struct = (CallTerm.Struct)term3;
                this.var(struct.ref());
                break;
            }
        }
        TermConsumer.super.accept(term);
    }

    public static final class ScopeChecker
    implements VarConsumer {
        @NotNull
        public final ImmutableSeq<LocalVar> allowed;
        @NotNull
        public final MutableList<LocalVar> invalid;
        @NotNull
        public final MutableList<LocalVar> confused;
        @NotNull
        private final MutableList<LocalVar> bound = MutableList.create();

        @Contract(pure=true)
        public ScopeChecker(@NotNull ImmutableSeq<LocalVar> allowed) {
            this(allowed, (MutableList<LocalVar>)MutableList.create(), (MutableList<LocalVar>)MutableList.create());
        }

        @Contract(pure=true)
        private ScopeChecker(@NotNull ImmutableSeq<LocalVar> allowed, @NotNull MutableList<LocalVar> confused, @NotNull MutableList<LocalVar> invalid) {
            this.allowed = allowed;
            this.confused = confused;
            this.invalid = invalid;
        }

        @TestOnly
        @VisibleForTesting
        public boolean isCleared() {
            return this.bound.isEmpty();
        }

        @Override
        public void accept(@NotNull Term term) {
            Term term2 = term;
            Objects.requireNonNull(term2);
            Term term3 = term2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntroTerm.Lambda.class, FormTerm.Pi.class, FormTerm.Sigma.class, FormTerm.Path.class, IntroTerm.PathLam.class, CallTerm.Hole.class}, (Object)term3, n)) {
                case 0: {
                    IntroTerm.Lambda lambda = (IntroTerm.Lambda)term3;
                    this.bound.append((Object)lambda.param().ref());
                    VarConsumer.super.accept(lambda);
                    this.bound.removeLast();
                    break;
                }
                case 1: {
                    FormTerm.Pi pi = (FormTerm.Pi)term3;
                    this.bound.append((Object)pi.param().ref());
                    VarConsumer.super.accept(pi);
                    this.bound.removeLast();
                    break;
                }
                case 2: {
                    FormTerm.Sigma sigma = (FormTerm.Sigma)term3;
                    int start = this.bound.size();
                    sigma.params().forEach(param -> {
                        this.bound.append((Object)param.ref());
                        this.accept(param.type());
                    });
                    this.bound.removeInRange(start, start + sigma.params().size());
                    break;
                }
                case 3: {
                    FormTerm.Path path = (FormTerm.Path)term3;
                    int start = this.bound.size();
                    path.cube().params().forEach(arg_0 -> this.bound.append(arg_0));
                    this.accept(path.cube().type());
                    path.cube().partial().termsView().forEach((Consumer)this);
                    this.bound.removeInRange(start, start + path.cube().params().size());
                    break;
                }
                case 4: {
                    IntroTerm.PathLam lam = (IntroTerm.PathLam)term3;
                    int start = this.bound.size();
                    lam.params().forEach(arg_0 -> this.bound.append(arg_0));
                    this.accept(lam.body());
                    this.bound.removeInRange(start, start + lam.params().size());
                    break;
                }
                case 5: {
                    CallTerm.Hole hole = (CallTerm.Hole)term3;
                    ScopeChecker checker = new ScopeChecker((ImmutableSeq<LocalVar>)this.allowed.appendedAll(this.bound), this.confused, this.confused);
                    hole.contextArgs().forEach(arg -> checker.accept((Term)arg.term()));
                    hole.args().forEach(arg -> this.accept((Term)arg.term()));
                    break;
                }
                default: {
                    VarConsumer.super.accept(term);
                }
            }
        }

        @Override
        @Contract(mutates="this")
        public void var(@NotNull AnyVar v) {
            LocalVar local;
            if (v instanceof LocalVar && !this.allowed.contains((Object)(local = (LocalVar)v)) && !this.bound.contains((Object)local) && !this.invalid.contains((Object)local)) {
                this.invalid.append((Object)local);
            }
        }
    }
}

