/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.term.FormTerm;
import org.aya.generic.Arg;
import org.aya.generic.AyaDocile;
import org.aya.generic.ParamLike;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDistiller<Term extends AyaDocile> {
    @NotNull
    public static final Style KEYWORD = Style.preset((String)"aya:Keyword");
    @NotNull
    public static final Style PRIM_CALL = Style.preset((String)"aya:PrimCall");
    @NotNull
    public static final Style FN_CALL = Style.preset((String)"aya:FnCall");
    @NotNull
    public static final Style DATA_CALL = Style.preset((String)"aya:DataCall");
    @NotNull
    public static final Style STRUCT_CALL = Style.preset((String)"aya:StructCall");
    @NotNull
    public static final Style CON_CALL = Style.preset((String)"aya:ConCall");
    @NotNull
    public static final Style FIELD_CALL = Style.preset((String)"aya:FieldCall");
    @NotNull
    public static final Style GENERALIZED = Style.preset((String)"aya:Generalized");
    @NotNull
    public final DistillerOptions options;

    protected BaseDistiller(@NotNull DistillerOptions options) {
        this.options = options;
    }

    @NotNull
    protected abstract Doc term(@NotNull Outer var1, @NotNull Term var2);

    @NotNull
    public Doc visitCalls(boolean infix, @NotNull Doc fn, @NotNull @NotNull SeqView<@NotNull Arg<Term>> args, @NotNull Outer outer, boolean showImplicits) {
        return this.visitCalls(infix, fn, this::term, outer, args, showImplicits);
    }

    @NotNull
    public Doc visitCalls(@NotNull DefVar<?, ?> var, @NotNull Style style, @NotNull @NotNull SeqLike<@NotNull Arg<Term>> args, @NotNull Outer outer, boolean showImplicits) {
        return this.visitCalls(var.isInfix(), BaseDistiller.linkRef(var, style), args.view(), outer, showImplicits);
    }

    @NotNull
    public Doc visitArgsCalls(@NotNull DefVar<?, ?> var, @NotNull Style style, @NotNull @NotNull SeqLike<@NotNull Arg<Term>> args, @NotNull Outer outer) {
        return this.visitCalls(var, style, args, outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
    }

    @NotNull
    <T extends AyaDocile> Doc visitCalls(boolean infix, @NotNull Doc fn, @NotNull Fmt<T> fmt, Outer outer, @NotNull @NotNull SeqView<@NotNull Arg<@NotNull T>> args, boolean showImplicits) {
        ImmutableSeq visibleArgs = (showImplicits ? args : args.filter(Arg::explicit)).toImmutableSeq();
        if (visibleArgs.isEmpty()) {
            return infix ? Doc.parened((Doc)fn) : fn;
        }
        if (infix) {
            Arg firstArg = (Arg)visibleArgs.first();
            if (!firstArg.explicit()) {
                return this.prefix(Doc.parened((Doc)fn), fmt, outer, visibleArgs.view());
            }
            Doc first = (Doc)fmt.apply(Outer.BinOp, firstArg.term());
            if (visibleArgs.sizeEquals(1)) {
                return BaseDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{first, fn}), Outer.BinOp);
            }
            Doc triple = Doc.sep((Doc[])new Doc[]{first, fn, this.visitArg(fmt, (Arg)visibleArgs.get(1), Outer.BinOp)});
            if (visibleArgs.sizeEquals(2)) {
                return BaseDistiller.checkParen(outer, triple, Outer.BinOp);
            }
            return this.prefix(Doc.parened((Doc)triple), fmt, outer, visibleArgs.view().drop(2));
        }
        return this.prefix(fn, fmt, outer, visibleArgs.view());
    }

    @NotNull
    private <T extends AyaDocile> Doc prefix(@NotNull Doc fn, @NotNull Fmt<T> fmt, Outer outer, SeqView<Arg<T>> args) {
        Doc call = Doc.sep((Doc[])new Doc[]{fn, Doc.sep((SeqLike)args.map(arg -> this.visitArg(fmt, (Arg)arg, Outer.AppSpine)))});
        return BaseDistiller.checkParen(outer, call, Outer.AppSpine);
    }

    private <T extends AyaDocile> Doc visitArg(@NotNull Fmt<T> fmt, @NotNull Arg<T> arg, @NotNull Outer outer) {
        if (arg.explicit()) {
            return (Doc)fmt.apply(outer, arg.term());
        }
        return Doc.braced((Doc)((Doc)fmt.apply(Outer.Free, arg.term())));
    }

    @NotNull
    public static Doc checkParen(@NotNull Outer outer, @NotNull Doc binApp, @NotNull Outer binOp) {
        return outer.ordinal() >= binOp.ordinal() ? Doc.parened((Doc)binApp) : binApp;
    }

    @NotNull
    Doc ctorDoc(@NotNull Outer outer, boolean ex, Doc ctorDoc, @Nullable LocalVar ctorAs, boolean noParams) {
        Doc withAs;
        boolean as = ctorAs != null;
        Doc withEx = Doc.bracedUnless((Doc)ctorDoc, (boolean)ex);
        Doc doc = withAs = !as ? withEx : Doc.sep((Doc[])new Doc[]{Doc.parened((Doc)withEx), Doc.plain((String)"as"), BaseDistiller.linkDef(ctorAs)});
        return !ex && !as ? withAs : (outer != Outer.Free && !noParams ? Doc.parened((Doc)withAs) : withAs);
    }

    @NotNull
    public Doc visitTele(@NotNull Seq<? extends ParamLike<Term>> telescope) {
        return this.visitTele(telescope, null, (t, v) -> 1);
    }

    @NotNull
    public Doc visitTele(@NotNull Seq<? extends ParamLike<Term>> telescope, @Nullable Term body, @NotNull ToIntBiFunction<Term, AnyVar> altF7) {
        if (telescope.isEmpty()) {
            return Doc.empty();
        }
        ParamLike last = (ParamLike)telescope.first();
        MutableList buf = MutableList.create();
        MutableList names = MutableList.of((Object)last.ref());
        for (int i = 1; i < telescope.size(); ++i) {
            ParamLike param = (ParamLike)telescope.get(i);
            if (!Objects.equals(param.type(), last.type())) {
                if (body != null && names.sizeEquals(1)) {
                    LocalVar ref = (LocalVar)names.first();
                    boolean used = telescope.sliceView(i + 1, telescope.size()).map(ParamLike::type).appended(body).anyMatch(p -> altF7.applyAsInt(p, ref) > 0);
                    if (!used) {
                        buf.append((Object)this.justType(last, Outer.ProjHead));
                    } else {
                        buf.append((Object)this.mutableListNames((MutableList<LocalVar>)names, last));
                    }
                } else {
                    buf.append((Object)this.mutableListNames((MutableList<LocalVar>)names, last));
                }
                names.clear();
                last = param;
            }
            names.append((Object)param.ref());
        }
        if (body != null && names.sizeEquals(1) && altF7.applyAsInt(body, (AnyVar)names.first()) == 0) {
            buf.append((Object)this.justType(last, Outer.ProjHead));
        } else {
            buf.append((Object)this.mutableListNames((MutableList<LocalVar>)names, last));
        }
        return Doc.sep((SeqLike)buf);
    }

    @NotNull
    Doc justType(@NotNull ParamLike<Term> monika, Outer outer) {
        return monika.explicit() ? this.term(outer, monika.type()) : Doc.braced((Doc)monika.type().toDoc(this.options));
    }

    private Doc mutableListNames(MutableList<LocalVar> names, ParamLike<?> param) {
        return param.toDoc(Doc.sep((SeqLike)names.view().map(BaseDistiller::linkDef).toImmutableSeq()), this.options);
    }

    @NotNull
    Doc lambdaParam(@NotNull ParamLike<?> param) {
        return (Boolean)this.options.map.get(DistillerOptions.Key.ShowLambdaTypes) != false ? param.toDoc(this.options) : Doc.bracedUnless((Doc)param.nameDoc(), (boolean)param.explicit());
    }

    @NotNull
    public static Doc varDoc(@NotNull AnyVar ref) {
        if (ref == LocalVar.IGNORED) {
            return Doc.plain((String)"_");
        }
        return Doc.linkRef((Doc)Doc.plain((String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    static Doc coe(boolean coerce) {
        return coerce ? Doc.styled((Style)KEYWORD, (String)"coerce") : Doc.empty();
    }

    @NotNull
    static Doc primDoc(AnyVar ref) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"prim"), BaseDistiller.linkDef(ref, PRIM_CALL)});
    }

    @NotNull
    public static Doc linkDef(@NotNull AnyVar ref, @NotNull Style color) {
        return Doc.linkDef((Doc)Doc.styled((Style)color, (String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    public static Doc linkRef(@NotNull AnyVar ref, @NotNull Style color) {
        return Doc.linkRef((Doc)Doc.styled((Style)color, (String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    public static Doc linkLit(int literal, @NotNull AnyVar ref, @NotNull Style color) {
        return Doc.linkRef((Doc)Doc.styled((Style)color, (Doc)Doc.plain((String)String.valueOf(literal))), (int)ref.hashCode());
    }

    @NotNull
    public static Doc linkDef(@NotNull AnyVar ref) {
        return Doc.linkDef((Doc)Doc.plain((String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    public static Doc defVar(DefVar<?, ?> ref) {
        Style style = BaseDistiller.chooseStyle(ref.concrete);
        return style != null ? BaseDistiller.linkDef(ref, style) : BaseDistiller.varDoc(ref);
    }

    @NotNull
    public static Doc cube(@NotNull DistillerOptions options, @NotNull FormTerm.Cube cube) {
        return Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"[|"), Doc.commaList((SeqLike)cube.params().map(BaseDistiller::linkDef)), Doc.symbol((String)"|]"), cube.type().toDoc(options), BaseDistiller.partial(options, cube.partial())});
    }

    @NotNull
    public Doc formula(@NotNull Outer outer, @NotNull Formula<Term> formula) {
        Formula<Term> formula2 = formula;
        Objects.requireNonNull(formula2);
        Formula<Term> formula3 = formula2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Formula.Conn.class, Formula.Inv.class, Formula.Lit.class}, formula3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Formula.Conn cnn = (Formula.Conn)formula3;
                Outer here = cnn.isAnd() ? Outer.IMin : Outer.IMax;
                yield BaseDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{this.term(here, (AyaDocile)cnn.l()), cnn.isAnd() ? Doc.symbol((String)"/\\") : Doc.symbol((String)"\\/"), this.term(here, (AyaDocile)cnn.r())}), cnn.isAnd() ? Outer.AppHead : Outer.IMin);
            }
            case 1 -> {
                Formula.Inv inv = (Formula.Inv)formula3;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"~"), this.term(Outer.AppSpine, (AyaDocile)inv.i())});
            }
            case 2 -> {
                Formula.Lit lit = (Formula.Lit)formula3;
                yield Doc.plain((String)(lit.isOne() ? "1" : "0"));
            }
        };
    }

    @NotNull
    public static <T extends Restr.TermLike<T> & AyaDocile> Doc partial(@NotNull DistillerOptions options, @NotNull Partial<T> partial) {
        Partial<T> partial2 = partial;
        Objects.requireNonNull(partial2);
        Partial<T> partial3 = partial2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Partial.Const.class, Partial.Split.class}, partial3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Partial.Const sad = (Partial.Const)partial3;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{|"), ((AyaDocile)sad.u()).toDoc(options), Doc.symbol((String)"|}")});
            }
            case 1 -> {
                Partial.Split hap = (Partial.Split)partial3;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{|"), Doc.join((Doc)Doc.spaced((Doc)Doc.symbol((String)"|")), (SeqLike)hap.clauses().map(s -> BaseDistiller.side(options, s))), Doc.symbol((String)"|}")});
            }
        };
    }

    @NotNull
    public static <T extends Restr.TermLike<T> & AyaDocile> Doc restr(@NotNull DistillerOptions options, @NotNull Restr<T> restr) {
        Restr<T> restr2 = restr;
        Objects.requireNonNull(restr2);
        Restr<T> restr3 = restr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Restr.Const.class, Restr.Disj.class}, restr3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Restr.Const con = (Restr.Const)restr3;
                if (con.isOne()) {
                    yield Doc.symbol((String)"top");
                }
                yield Doc.symbol((String)"_|_");
            }
            case 1 -> {
                Restr.Disj v = (Restr.Disj)restr3;
                yield Doc.join((Doc)Doc.spaced((Doc)Doc.symbol((String)"\\/")), (SeqLike)v.orz().view().map(or -> or.ands().sizeGreaterThan(1) && v.orz().sizeGreaterThan(1) ? Doc.parened((Doc)BaseDistiller.cofib(options, or)) : BaseDistiller.cofib(options, or)));
            }
        };
    }

    @NotNull
    public static <T extends Restr.TermLike<T> & AyaDocile> Doc side(@NotNull DistillerOptions options, @NotNull Restr.Side<T> side) {
        return Doc.sep((Doc[])new Doc[]{BaseDistiller.cofib(options, side.cof()), Doc.symbol((String)":="), ((AyaDocile)side.u()).toDoc(options)});
    }

    @NotNull
    public static <T extends Restr.TermLike<T> & AyaDocile> Doc cofib(@NotNull DistillerOptions options, @NotNull Restr.Conj<T> conj) {
        return Doc.join((Doc)Doc.spaced((Doc)Doc.symbol((String)"/\\")), (SeqLike)conj.ands().view().map(and -> Doc.sepNonEmpty((Doc[])new Doc[]{!and.isOne() ? Doc.symbol((String)"~") : Doc.empty(), ((AyaDocile)((Restr.TermLike)and.inst())).toDoc(options)})));
    }

    @Nullable
    protected static Style chooseStyle(Object concrete) {
        Object object = concrete;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, TeleDecl.DataCtor.class, TeleDecl.StructDecl.class, TeleDecl.StructField.class, TeleDecl.PrimDecl.class}, (Object)object, n)) {
            case 0 -> {
                TeleDecl.FnDecl d = (TeleDecl.FnDecl)object;
                yield FN_CALL;
            }
            case 1 -> {
                TeleDecl.DataDecl d = (TeleDecl.DataDecl)object;
                yield DATA_CALL;
            }
            case 2 -> {
                TeleDecl.DataCtor d = (TeleDecl.DataCtor)object;
                yield CON_CALL;
            }
            case 3 -> {
                TeleDecl.StructDecl d = (TeleDecl.StructDecl)object;
                yield STRUCT_CALL;
            }
            case 4 -> {
                TeleDecl.StructField d = (TeleDecl.StructField)object;
                yield FIELD_CALL;
            }
            case 5 -> {
                TeleDecl.PrimDecl d = (TeleDecl.PrimDecl)object;
                yield PRIM_CALL;
            }
            default -> null;
        };
    }

    @FunctionalInterface
    protected static interface Fmt<T extends AyaDocile>
    extends BiFunction<Outer, T, Doc> {
    }

    public static enum Outer {
        Free,
        Codomain,
        BinOp,
        IMax,
        IMin,
        AppHead,
        AppSpine,
        ProjHead,
        Lifted;

    }
}

