/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import com.intellij.openapi.util.text.StringUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.core.Matching;
import org.aya.core.Meta;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.LitTerm;
import org.aya.core.term.PrimTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.MonoidalVarFolder;
import org.aya.distill.BaseDistiller;
import org.aya.generic.Arg;
import org.aya.generic.AyaDocile;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.NotNull;

public class CoreDistiller
extends BaseDistiller<Term> {
    public CoreDistiller(@NotNull DistillerOptions options) {
        super(options);
    }

    @Override
    @NotNull
    public Doc term(@NotNull BaseDistiller.Outer outer, @NotNull Term preterm) {
        Term term = preterm;
        Objects.requireNonNull(term);
        Term term2 = term;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.class, CallTerm.Hole.class, IntroTerm.Tuple.class, CallTerm.Con.class, CallTerm.Fn.class, FormTerm.Sigma.class, IntroTerm.Lambda.class, FormTerm.Sort.class, PrimTerm.Interval.class, IntroTerm.New.class, CallTerm.Access.class, RefTerm.MetaPat.class, ErrorTerm.class, ElimTerm.App.class, CallTerm.Prim.class, RefTerm.Field.class, ElimTerm.Proj.class, FormTerm.Pi.class, CallTerm.Struct.class, CallTerm.Data.class, LitTerm.ShapedInt.class, PrimTerm.Str.class, FormTerm.PartTy.class, IntroTerm.PartEl.class, PrimTerm.Mula.class, FormTerm.Path.class, IntroTerm.PathLam.class, ElimTerm.PathApp.class, PrimTerm.Coe.class}, (Object)term2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                RefTerm term = (RefTerm)term2;
                yield CoreDistiller.varDoc(term.var());
            }
            case 1 -> {
                CallTerm.Hole term = (CallTerm.Hole)term2;
                Meta name = term.ref();
                Doc inner = CoreDistiller.varDoc(name);
                Boolean showImplicits = (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs);
                if (((Boolean)this.options.map.get(DistillerOptions.Key.InlineMetas)).booleanValue()) {
                    yield this.visitCalls(false, inner, term.args().view(), outer, (boolean)showImplicits);
                }
                yield Doc.wrap((String)"{?", (String)"?}", (Doc)this.visitCalls(false, inner, term.args().view(), BaseDistiller.Outer.Free, (boolean)showImplicits));
            }
            case 2 -> {
                IntroTerm.Tuple term = (IntroTerm.Tuple)term2;
                yield Doc.parened((Doc)Doc.commaList((SeqLike)term.items().view().map(t -> this.term(BaseDistiller.Outer.Free, (Term)t))));
            }
            case 3 -> {
                CallTerm.Con conCall = (CallTerm.Con)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)conCall.ref(), CON_CALL, conCall.conArgs(), outer);
            }
            case 4 -> {
                CallTerm.Fn fnCall = (CallTerm.Fn)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)fnCall.ref(), FN_CALL, fnCall.args(), outer);
            }
            case 5 -> {
                FormTerm.Sigma term = (FormTerm.Sigma)term2;
                Term.Param last = (Term.Param)term.params().last();
                Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele(term.params().dropLast(1), last.type(), Term::findUsages), Doc.symbol((String)"**"), this.justType(last, BaseDistiller.Outer.Codomain)});
                yield CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
            }
            case 6 -> {
                Doc bodyDoc;
                CallTerm call;
                AnyVar var17_24;
                IntroTerm.Lambda term = (IntroTerm.Lambda)term2;
                MutableList params = MutableList.of((Object)term.param());
                Term body = IntroTerm.Lambda.unwrap(term.body(), arg_0 -> ((MutableList)params).append(arg_0));
                if (body instanceof CallTerm && (var17_24 = (call = (CallTerm)body).ref()) instanceof DefVar) {
                    DefVar defVar = (DefVar)var17_24;
                    SeqView args = this.visibleArgsOf(call).view();
                    while (params.isNotEmpty() && args.isNotEmpty() && this.checkUneta((SeqView<Arg<Term>>)args, (Term.Param)params.last())) {
                        args = args.dropLast(1);
                        params.removeLast();
                    }
                    if (call instanceof CallTerm.Access) {
                        CallTerm.Access access = (CallTerm.Access)call;
                        bodyDoc = this.visitAccessHead(access);
                    } else {
                        Style style = CoreDistiller.chooseStyle(defVar);
                        bodyDoc = style != null ? this.visitArgsCalls(defVar, style, args, BaseDistiller.Outer.Free) : this.visitCalls(defVar.isInfix(), CoreDistiller.varDoc(defVar), args, params.isEmpty() ? outer : BaseDistiller.Outer.Free, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
                    }
                } else {
                    bodyDoc = this.term(BaseDistiller.Outer.Free, body);
                }
                if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue()) {
                    params.retainAll(Term.Param::explicit);
                }
                if (params.isEmpty()) {
                    yield bodyDoc;
                }
                MutableList list = MutableList.of((Object)Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")));
                params.forEach(param -> list.append((Object)this.lambdaParam((ParamLike<?>)param)));
                list.append((Object)Doc.symbol((String)"=>"));
                list.append((Object)bodyDoc);
                Doc doc = Doc.sep((SeqLike)list);
                yield CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.AppHead);
            }
            case 7 -> {
                FormTerm.Sort term = (FormTerm.Sort)term2;
                Doc fn = Doc.styled((Style)KEYWORD, (String)term.kind().name());
                if (!term.kind().hasLevel()) {
                    yield fn;
                }
                yield this.visitCalls(false, fn, (nest, t) -> t.toDoc(this.options), outer, SeqView.of(new Arg<AyaDocile>(o -> Doc.plain((String)String.valueOf(term.lift())), true)), (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs));
            }
            case 8 -> {
                PrimTerm.Interval term = (PrimTerm.Interval)term2;
                yield Doc.styled((Style)KEYWORD, (String)"I");
            }
            case 9 -> {
                IntroTerm.New newTerm = (IntroTerm.New)term2;
                yield Doc.cblock((Doc)Doc.styled((Style)KEYWORD, (String)"new"), (int)2, (Doc)Doc.vcat((SeqLike)newTerm.params().view().map((k, v) -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), CoreDistiller.linkRef(k, FIELD_CALL), Doc.symbol((String)"=>"), this.term(BaseDistiller.Outer.Free, (Term)v)})).toImmutableSeq()));
            }
            case 10 -> {
                CallTerm.Access term = (CallTerm.Access)term2;
                yield this.visitCalls(false, this.visitAccessHead(term), term.fieldArgs().view(), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
            }
            case 11 -> {
                RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term2;
                Pat.Meta ref = metaPat.ref();
                if (ref.solution().get() == null) {
                    yield CoreDistiller.varDoc(ref.fakeBind());
                }
                yield Doc.wrap((String)"<", (String)">", (Doc)this.pat(ref, outer));
            }
            case 12 -> {
                ErrorTerm term = (ErrorTerm)term2;
                Doc doc = term.description().toDoc(this.options);
                if (term.isReallyError()) {
                    yield Doc.angled((Doc)doc);
                }
                yield doc;
            }
            case 13 -> {
                DefVar var;
                CallTerm call;
                AnyVar var24_44;
                ElimTerm.App term = (ElimTerm.App)term2;
                MutableList args = MutableList.of(term.arg());
                Term head = ElimTerm.unapp(term.of(), (MutableList<Arg<Term>>)args);
                if (head instanceof RefTerm.Field) {
                    RefTerm.Field fieldRef = (RefTerm.Field)head;
                    yield this.visitArgsCalls(fieldRef.ref(), FIELD_CALL, args, outer);
                }
                Boolean implicits = (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs);
                if (head instanceof CallTerm && (var24_44 = (call = (CallTerm)head).ref()) instanceof DefVar && (var = (DefVar)var24_44).isInfix()) {
                    yield this.visitCalls(true, CoreDistiller.defVar(var), call.args().view().appendedAll((Iterable)args), outer, (boolean)implicits);
                }
                yield this.visitCalls(false, this.term(BaseDistiller.Outer.AppHead, head), args.view(), outer, (boolean)implicits);
            }
            case 14 -> {
                CallTerm.Prim prim = (CallTerm.Prim)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)prim.ref(), PRIM_CALL, prim.args(), outer);
            }
            case 15 -> {
                RefTerm.Field term = (RefTerm.Field)term2;
                yield CoreDistiller.linkRef(term.ref(), FIELD_CALL);
            }
            case 16 -> {
                ElimTerm.Proj term = (ElimTerm.Proj)term2;
                yield Doc.cat((Doc[])new Doc[]{this.term(BaseDistiller.Outer.ProjHead, term.of()), Doc.symbol((String)"."), Doc.plain((String)String.valueOf(term.ix()))});
            }
            case 17 -> {
                FormTerm.Pi term = (FormTerm.Pi)term2;
                if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue() && !term.param().explicit()) {
                    yield this.term(outer, term.body());
                }
                if (term.body().findUsages(term.param().ref()) == 0) {
                    yield CoreDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{Doc.bracedUnless((Doc)term.param().type().toDoc(this.options), (boolean)term.param().explicit()), Doc.symbol((String)"->"), this.term(BaseDistiller.Outer.Codomain, term.body())}), BaseDistiller.Outer.BinOp);
                }
                MutableList params = MutableList.of((Object)term.param());
                Term body = FormTerm.unpi(term.body(), (MutableList<Term.Param>)params);
                Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), this.visitTele(params, body, Term::findUsages), Doc.symbol((String)"->"), this.term(BaseDistiller.Outer.Codomain, body)});
                yield CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
            }
            case 18 -> {
                CallTerm.Struct structCall = (CallTerm.Struct)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)structCall.ref(), STRUCT_CALL, structCall.args(), outer);
            }
            case 19 -> {
                CallTerm.Data dataCall = (CallTerm.Data)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)dataCall.ref(), DATA_CALL, dataCall.args(), outer);
            }
            case 20 -> {
                LitTerm.ShapedInt shaped = (LitTerm.ShapedInt)term2;
                yield (Doc)shaped.with((zero, suc) -> shaped.repr() == 0 ? CoreDistiller.linkLit(0, zero.ref, CON_CALL) : CoreDistiller.linkLit(shaped.repr(), suc.ref, CON_CALL), () -> Doc.plain((String)String.valueOf(shaped.repr())));
            }
            case 21 -> {
                PrimTerm.Str str = (PrimTerm.Str)term2;
                yield Doc.plain((String)("\"" + StringUtil.escapeStringCharacters((String)str.string()) + "\""));
            }
            case 22 -> {
                FormTerm.PartTy ty = (FormTerm.PartTy)term2;
                yield CoreDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"Partial"), this.term(BaseDistiller.Outer.AppSpine, ty.type()), Doc.parened((Doc)CoreDistiller.restr(this.options, ty.restr()))}), BaseDistiller.Outer.AppSpine);
            }
            case 23 -> {
                IntroTerm.PartEl el = (IntroTerm.PartEl)term2;
                yield CoreDistiller.partial(this.options, el.partial());
            }
            case 24 -> {
                PrimTerm.Mula mula = (PrimTerm.Mula)term2;
                yield this.formula(outer, mula.asFormula());
            }
            case 25 -> {
                FormTerm.Path path = (FormTerm.Path)term2;
                yield CoreDistiller.cube(this.options, path.cube());
            }
            case 26 -> {
                IntroTerm.PathLam lam = (IntroTerm.PathLam)term2;
                yield Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"\\"), Doc.sep((SeqLike)lam.params().map(BaseDistiller::varDoc)), Doc.symbol((String)"=>"), lam.body().toDoc(this.options)});
            }
            case 27 -> {
                ElimTerm.PathApp app = (ElimTerm.PathApp)term2;
                yield this.visitCalls(false, this.term(BaseDistiller.Outer.AppHead, app.of()), app.args().view(), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
            }
            case 28 -> {
                PrimTerm.Coe coe = (PrimTerm.Coe)term2;
                yield CoreDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"coe"), this.term(BaseDistiller.Outer.AppSpine, coe.type()), Doc.parened((Doc)CoreDistiller.restr(this.options, coe.restr()))}), BaseDistiller.Outer.AppSpine);
            }
        };
    }

    private boolean checkUneta(SeqView<Arg<Term>> args, Term.Param param) {
        Arg arg = (Arg)args.last();
        if (arg.explicit() != param.explicit()) {
            return false;
        }
        Object t = arg.term();
        if (!(t instanceof RefTerm)) {
            return false;
        }
        RefTerm argRef = (RefTerm)t;
        if (argRef.var() != param.ref()) {
            return false;
        }
        MonoidalVarFolder.Usages counter = new MonoidalVarFolder.Usages(param.ref());
        return args.dropLast(1).allMatch(a -> (Integer)counter.apply((Term)a.term()) == 0);
    }

    private ImmutableSeq<Arg<Term>> visibleArgsOf(CallTerm call) {
        ImmutableSeq<Arg<Term>> immutableSeq;
        if (call instanceof CallTerm.Con) {
            CallTerm.Con con = (CallTerm.Con)call;
            immutableSeq = con.conArgs();
        } else if (call instanceof CallTerm.Access) {
            CallTerm.Access access = (CallTerm.Access)call;
            immutableSeq = access.fieldArgs();
        } else {
            immutableSeq = call.args();
        }
        return immutableSeq;
    }

    @NotNull
    private Doc visitAccessHead(@NotNull CallTerm.Access term) {
        return Doc.cat((Doc[])new Doc[]{this.term(BaseDistiller.Outer.ProjHead, term.of()), Doc.symbol((String)"."), CoreDistiller.linkRef(term.ref(), FIELD_CALL)});
    }

    @NotNull
    public Doc pat(@NotNull Pat pat, BaseDistiller.Outer outer) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Meta.class, Pat.Bind.class, Pat.Ctor.class, Pat.Absurd.class, Pat.Tuple.class, Pat.End.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pat.Meta meta = (Pat.Meta)pat3;
                Pat sol = (Pat)meta.solution().get();
                if (sol != null) {
                    yield this.pat(sol, outer);
                }
                yield Doc.bracedUnless((Doc)CoreDistiller.linkDef(meta.fakeBind()), (boolean)meta.explicit());
            }
            case 1 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                yield Doc.bracedUnless((Doc)CoreDistiller.linkDef(bind.bind()), (boolean)bind.explicit());
            }
            case 2 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                Doc ctorDoc = this.visitCalls(ctor.ref(), CON_CALL, ctor.params().view().map(Pat::toArg), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)));
                yield this.ctorDoc(outer, ctor.explicit(), ctorDoc, null, ctor.params().isEmpty());
            }
            case 3 -> {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                yield Doc.bracedUnless((Doc)Doc.styled((Style)KEYWORD, (String)"()"), (boolean)absurd.explicit());
            }
            case 4 -> {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                yield Doc.licit((boolean)tuple.explicit(), (Doc)Doc.commaList((SeqLike)tuple.pats().view().map(sub -> this.pat((Pat)sub, BaseDistiller.Outer.Free))));
            }
            case 5 -> {
                Pat.End end = (Pat.End)pat3;
                yield Doc.bracedUnless((Doc)Doc.styled((Style)KEYWORD, (String)(end.isOne() ? "1" : "0")), (boolean)end.explicit());
            }
            case 6 -> {
                Pat.ShapedInt lit = (Pat.ShapedInt)pat3;
                yield Doc.bracedUnless((Doc)lit.with((zero, suc) -> lit.repr() == 0 ? CoreDistiller.linkLit(0, zero.ref, CON_CALL) : CoreDistiller.linkLit(lit.repr(), suc.ref, CON_CALL), () -> Doc.plain((String)String.valueOf(lit.repr()))), (boolean)lit.explicit());
            }
        };
    }

    @NotNull
    public Doc def(@NotNull GenericDef predef) {
        GenericDef genericDef = predef;
        Objects.requireNonNull(genericDef);
        GenericDef genericDef2 = genericDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDef.class, FnDef.class, FieldDef.class, PrimDef.class, CtorDef.class, StructDef.class, DataDef.class}, (Object)genericDef2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ClassDef classDef = (ClassDef)genericDef2;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 1 -> {
                FnDef def = (FnDef)genericDef2;
                MutableList line1 = MutableList.of((Object)Doc.styled((Style)KEYWORD, (String)"def"));
                def.modifiers.forEach(m -> line1.append((Object)Doc.styled((Style)KEYWORD, (String)m.keyword)));
                line1.appendAll((Object[])new Doc[]{CoreDistiller.linkDef(def.ref(), FN_CALL), this.visitTele(def.telescope()), Doc.symbol((String)":"), this.term(BaseDistiller.Outer.Free, (Term)def.result())});
                yield (Doc)def.body.fold(term -> Doc.sep((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.symbol((String)"=>"), this.term(BaseDistiller.Outer.Free, (Term)term)}), clauses -> Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)clauses))}));
            }
            case 2 -> {
                FieldDef field = (FieldDef)genericDef2;
                yield Doc.sepNonEmpty((Doc[])new Doc[]{Doc.symbol((String)"|"), CoreDistiller.coe(field.coerce), CoreDistiller.linkDef(field.ref(), FIELD_CALL), this.visitTele(field.selfTele), Doc.symbol((String)":"), this.term(BaseDistiller.Outer.Free, field.result)});
            }
            case 3 -> {
                PrimDef def = (PrimDef)genericDef2;
                yield CoreDistiller.primDoc(def.ref());
            }
            case 4 -> {
                Doc line1;
                CtorDef ctor = (CtorDef)genericDef2;
                Doc doc = Doc.sepNonEmpty((Doc[])new Doc[]{CoreDistiller.coe(ctor.coerce), CoreDistiller.linkDef(ctor.ref(), CON_CALL), this.visitTele(ctor.selfTele)});
                if (ctor.pats.isNotEmpty()) {
                    Doc pats = Doc.commaList((SeqLike)ctor.pats.view().map(pat -> this.pat((Pat)pat, BaseDistiller.Outer.Free)));
                    line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.symbol((String)"=>"), doc});
                } else {
                    line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
                }
                yield Doc.cblock((Doc)line1, (int)2, (Doc)this.visitClauses(ctor.clauses));
            }
            case 5 -> {
                StructDef def = (StructDef)genericDef2;
                yield Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"struct"), CoreDistiller.linkDef(def.ref(), STRUCT_CALL), this.visitTele(def.telescope()), Doc.symbol((String)":"), this.term(BaseDistiller.Outer.Free, (Term)def.result())}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.fields.view().map(this::def)))});
            }
            case 6 -> {
                DataDef def = (DataDef)genericDef2;
                MutableList line1 = MutableList.of((Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)CoreDistiller.linkDef(def.ref(), DATA_CALL), (Object)this.visitTele(def.telescope()), (Object)Doc.symbol((String)":"), (Object)this.term(BaseDistiller.Outer.Free, (Term)def.result()));
                yield Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.body.view().map(this::def)))});
            }
        };
    }

    @NotNull
    private Doc visitClauses(@NotNull ImmutableSeq<Matching> clauses) {
        return Doc.vcat((SeqLike)clauses.view().map(matching -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), matching.toDoc(this.options)})));
    }
}

