/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.error;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.def.PrimDef;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public interface PrimResolveError
extends Problem {
    @NotNull
    default public Problem.Stage stage() {
        return Problem.Stage.RESOLVE;
    }

    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public record Dependency(@NotNull String name, @NotNull ImmutableSeq<PrimDef.ID> lack, @NotNull SourcePos sourcePos) implements PrimResolveError
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            assert (this.lack.isNotEmpty());
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The prim"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.name)), Doc.english((String)"depends on undeclared prims:"), Doc.commaList((SeqLike)this.lack.map(name -> Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)name.id))))});
        }
    }

    public record Redefinition(@NotNull String name, @NotNull SourcePos sourcePos) implements PrimResolveError
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Redefinition of primitive"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.name))});
        }
    }

    public record UnknownPrim(@NotNull SourcePos sourcePos, @NotNull String name) implements PrimResolveError
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown primitive"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.name))});
        }
    }
}

