/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.StringConcatFactory;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.Tuple3;
import kala.value.LazyValue;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.repr.AyaShape;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.LitTerm;
import org.aya.core.term.PrimTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.DeltaExpander;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.generic.AyaDocile;
import org.aya.generic.Constants;
import org.aya.generic.Modifier;
import org.aya.generic.util.InternalException;
import org.aya.guest0x0.cubical.CofThy;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.TyckState;
import org.aya.tyck.Tycker;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.env.MapLocalCtx;
import org.aya.tyck.error.BadTypeError;
import org.aya.tyck.error.CubicalError;
import org.aya.tyck.error.FieldError;
import org.aya.tyck.error.Goal;
import org.aya.tyck.error.LevelError;
import org.aya.tyck.error.LicitError;
import org.aya.tyck.error.LiteralError;
import org.aya.tyck.error.NoRuleError;
import org.aya.tyck.error.PrimError;
import org.aya.tyck.error.SortPiError;
import org.aya.tyck.error.TupleError;
import org.aya.tyck.error.UnifyError;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.unify.TermComparator;
import org.aya.tyck.unify.Unifier;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExprTycker
extends Tycker {
    @NotNull
    public LocalCtx localCtx = new MapLocalCtx();
    @NotNull
    public AyaShape.Factory shapeFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Result doSynthesize(@NotNull Expr expr) {
        Result result;
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.LamExpr.class, Expr.SortExpr.class, Expr.RefExpr.class, Expr.PiExpr.class, Expr.SigmaExpr.class, Expr.LiftExpr.class, Expr.NewExpr.class, Expr.ProjExpr.class, Expr.TupExpr.class, Expr.AppExpr.class, Expr.HoleExpr.class, Expr.ErrorExpr.class, Expr.LitIntExpr.class, Expr.LitStringExpr.class, Expr.Path.class}, (Object)expr3, n)) {
            case 0: {
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                Result result2 = this.inherit(lam, this.generatePi(lam));
                result = result2;
                return result;
            }
            case 1: {
                SortResult sortResult;
                Expr.SortExpr sort = (Expr.SortExpr)expr3;
                result = sortResult = this.sort(sort);
                return result;
            }
            case 2: {
                Expr.RefExpr ref = (Expr.RefExpr)expr3;
                AnyVar anyVar = ref.resolvedVar();
                Objects.requireNonNull(anyVar);
                AnyVar anyVar2 = anyVar;
                int n2 = 0;
                Result result3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalVar.class, DefVar.class}, (Object)anyVar2, n2)) {
                    case 0 -> {
                        LocalVar loc = (LocalVar)anyVar2;
                        Term ty = this.localCtx.get(loc);
                        yield new TermResult(new RefTerm(loc), ty);
                    }
                    case 1 -> {
                        DefVar defVar = (DefVar)anyVar2;
                        yield this.inferRef(ref.sourcePos(), defVar);
                    }
                    default -> throw new InternalException("Unknown var: " + String.valueOf(ref.resolvedVar().getClass()));
                };
                result = result3;
                return result;
            }
            case 3: {
                SortResult sortResult;
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                result = sortResult = this.sort(pi);
                return result;
            }
            case 4: {
                SortResult sortResult;
                Expr.SigmaExpr sigma = (Expr.SigmaExpr)expr3;
                result = sortResult = this.sort(sigma);
                return result;
            }
            case 5: {
                Expr.LiftExpr lift = (Expr.LiftExpr)expr3;
                Result result4 = this.synthesize(lift.expr());
                int levels = lift.lift();
                TermResult termResult = new TermResult(result4.wellTyped().lift(levels), result4.type().lift(levels));
                result = termResult;
                return result;
            }
            case 6: {
                Expr.NewExpr newExpr = (Expr.NewExpr)expr3;
                Expr structExpr = newExpr.struct();
                Term struct = this.instImplicits(this.synthesize(structExpr).wellTyped(), structExpr.sourcePos());
                if (!(struct instanceof CallTerm.Struct)) {
                    Result result5 = this.fail(structExpr, struct, BadTypeError.structCon(this.state, newExpr, struct));
                    result = result5;
                    return result;
                }
                CallTerm.Struct structCall = (CallTerm.Struct)struct;
                AnyVar structRef = structCall.ref();
                Subst subst = new Subst((SeqLike<LocalVar>)Def.defTele((DefVar<? extends Def, ? extends Decl.Telescopic>)structRef).map(Term.Param::ref), (SeqLike<? extends Term>)structCall.args().map(Arg::term));
                MutableList fields = MutableList.create();
                MutableList missing = MutableList.create();
                MutableMap conFields = MutableMap.from((Iterable)newExpr.fields().view().map(t -> Tuple.of((Object)((String)t.name().data()), (Object)t)));
                for (FieldDef defField : ((StructDef)((DefVar)structRef).core).fields) {
                    DefVar<FieldDef, TeleDecl.StructField> fieldRef = defField.ref();
                    Option conFieldOpt = conFields.remove((Object)fieldRef.name());
                    if (conFieldOpt.isEmpty()) {
                        if (defField.body.isEmpty()) {
                            missing.append(fieldRef);
                            continue;
                        }
                        Term field = ((Term)defField.body.get()).subst(subst, structCall.ulift());
                        fields.append((Object)Tuple.of(fieldRef, (Object)field));
                        subst.add(fieldRef, field);
                        continue;
                    }
                    Expr.Field conField = (Expr.Field)conFieldOpt.get();
                    conField.resolvedField().set(fieldRef);
                    Term type = Def.defType(fieldRef).subst(subst, structCall.ulift());
                    ImmutableSeq<Term.Param> telescope = Term.Param.subst((ImmutableSeq<Term.Param>)((FieldDef)fieldRef.core).selfTele, subst, structCall.ulift());
                    ImmutableSeq<WithPos<LocalVar>> bindings = conField.bindings();
                    if (telescope.sizeLessThan(bindings.size())) {
                        Result result6 = this.fail(newExpr, structCall, new FieldError.ArgMismatch(newExpr.sourcePos(), defField, bindings.size()));
                        result = result6;
                        return result;
                    }
                    Expr fieldExpr = (Expr)bindings.zipView(telescope).foldRight((Object)conField.body(), (pair, lamExpr) -> new Expr.LamExpr(conField.body().sourcePos(), new Expr.Param(((WithPos)pair._1).sourcePos(), (LocalVar)((WithPos)pair._1).data(), ((Term.Param)pair._2).explicit()), (Expr)lamExpr));
                    Term field = this.inherit(fieldExpr, type).wellTyped();
                    fields.append((Object)Tuple.of(fieldRef, (Object)field));
                    subst.add(fieldRef, field);
                }
                if (missing.isNotEmpty()) {
                    Result result7 = this.fail(newExpr, structCall, new FieldError.MissingField(newExpr.sourcePos(), (ImmutableSeq<AnyVar>)missing.toImmutableSeq()));
                    result = result7;
                    return result;
                }
                if (conFields.isNotEmpty()) {
                    Result result8 = this.fail(newExpr, structCall, new FieldError.NoSuchField(newExpr.sourcePos(), (ImmutableSeq<String>)conFields.keysView().toImmutableSeq()));
                    result = result8;
                    return result;
                }
                TermResult termResult = new TermResult(new IntroTerm.New(structCall, (ImmutableMap<DefVar<FieldDef, TeleDecl.StructField>, Term>)ImmutableMap.from((Iterable)fields)), structCall);
                result = termResult;
                return result;
            }
            case 7: {
                Expr.ProjExpr proj = (Expr.ProjExpr)expr3;
                Expr struct = proj.tup();
                Result projectee = this.instImplicits(this.synthesize(struct), struct.sourcePos());
                Result result9 = (Result)proj.ix().fold(ix -> {
                    Term patt6008$temp = projectee.type();
                    if (!(patt6008$temp instanceof FormTerm.Sigma)) {
                        return this.fail(struct, projectee.type(), BadTypeError.sigmaAcc(this.state, struct, ix, projectee.type()));
                    }
                    FormTerm.Sigma sigma = (FormTerm.Sigma)patt6008$temp;
                    ImmutableSeq<Term.Param> telescope = sigma.params();
                    int index = ix - 1;
                    if (index < 0 || index >= telescope.size()) {
                        return this.fail(proj, new TupleError.ProjIxError(proj, (int)ix, telescope.size()));
                    }
                    Term type = ((Term.Param)telescope.get(index)).type();
                    Subst subst = ElimTerm.Proj.projSubst(projectee.wellTyped(), index, telescope);
                    return new TermResult(new ElimTerm.Proj(projectee.wellTyped(), (int)ix), type.subst(subst));
                }, sp -> {
                    Object patt7150$temp;
                    StructDef structCore;
                    CallTerm.Struct structCall;
                    block6: {
                        String fieldName;
                        block5: {
                            fieldName = sp.justName();
                            Term patt6706$temp = projectee.type();
                            if (!(patt6706$temp instanceof CallTerm.Struct)) {
                                return this.fail(struct, ErrorTerm.unexpected(projectee.type()), BadTypeError.structAcc(this.state, struct, fieldName, projectee.type()));
                            }
                            structCall = (CallTerm.Struct)patt6706$temp;
                            structCore = (StructDef)((DefVar)structCall.ref()).core;
                            if (structCore == null) {
                                throw new UnsupportedOperationException("TODO");
                            }
                            AnyVar patt7104$temp = proj.resolvedIx();
                            if (!(patt7104$temp instanceof DefVar)) break block5;
                            DefVar defVar = (DefVar)patt7104$temp;
                            patt7150$temp = defVar.core;
                            if (patt7150$temp instanceof FieldDef) break block6;
                        }
                        return this.fail(proj, new FieldError.UnknownField(proj, fieldName));
                    }
                    FieldDef field = (FieldDef)patt7150$temp;
                    DefVar<FieldDef, TeleDecl.StructField> fieldRef = field.ref();
                    Subst structSubst = DeltaExpander.buildSubst(structCore.telescope(), structCall.args());
                    ImmutableSeq<Term.Param> tele = Term.Param.subst((ImmutableSeq<Term.Param>)((FieldDef)fieldRef.core).selfTele, structSubst, 0);
                    ImmutableSeq teleRenamed = tele.map(Term.Param::rename);
                    CallTerm.Access access = new CallTerm.Access(projectee.wellTyped(), fieldRef, structCall.args(), (ImmutableSeq<Arg<Term>>)teleRenamed.map(Term.Param::toArg));
                    return new TermResult(IntroTerm.Lambda.make((SeqLike<Term.Param>)teleRenamed, access), FormTerm.Pi.make(tele, field.result().subst(structSubst)));
                });
                result = result9;
                return result;
            }
            case 8: {
                Expr.TupExpr tuple = (Expr.TupExpr)expr3;
                ImmutableSeq items = tuple.items().map(this::synthesize);
                TermResult termResult = new TermResult(new IntroTerm.Tuple((ImmutableSeq<Term>)items.map(Result::wellTyped)), new FormTerm.Sigma((ImmutableSeq<Term.Param>)items.map(item -> new Term.Param(Constants.anonymous(), item.type(), true))));
                result = termResult;
                return result;
            }
            case 9: {
                FormTerm.Cube cube;
                FormTerm.Pi pi;
                Expr.AppExpr appE = (Expr.AppExpr)expr3;
                Result f = this.synthesize(appE.function());
                if (f.wellTyped() instanceof ErrorTerm || f.type() instanceof ErrorTerm) {
                    Result result10 = f;
                    result = result10;
                    return result;
                }
                Term app = f.wellTyped();
                Expr.NamedArg argument = appE.argument();
                Term fTy = this.whnf(f.type());
                boolean argLicit = argument.explicit();
                if (fTy instanceof CallTerm.Hole) {
                    CallTerm.Hole fTyHole = (CallTerm.Hole)fTy;
                    pi = fTyHole.asPi(argLicit);
                    this.unifier(appE.sourcePos(), Ordering.Eq).compare(fTy, pi, null);
                    fTy = this.whnf(fTy);
                }
                Subst subst = new Subst((MutableMap<AnyVar, Term>)MutableMap.create());
                try {
                    Tuple2<FormTerm.Pi, FormTerm.Cube> tup = this.ensurePiOrPath(fTy);
                    pi = (FormTerm.Pi)tup._1;
                    cube = (FormTerm.Cube)tup._2;
                    while (pi.param().explicit() != argLicit || argument.name() != null && !Objects.equals(pi.param().ref().name(), argument.name())) {
                        if (!argLicit && argument.name() == null) {
                            Result result11 = this.fail(appE, new ErrorTerm(pi.body()), new LicitError.UnexpectedImplicitArg(argument));
                            result = result11;
                            return result;
                        }
                        Arg<Term> holeApp = this.mockArg(pi.param().subst(subst), argument.expr().sourcePos());
                        app = ElimTerm.make(app, holeApp);
                        subst.addDirectly(pi.param().ref(), holeApp.term());
                        tup = this.ensurePiOrPath(pi.body());
                        pi = (FormTerm.Pi)tup._1;
                        if (tup._2 == null) continue;
                        cube = (FormTerm.Cube)tup._2;
                    }
                    tup = this.ensurePiOrPath(pi.subst(subst));
                    pi = (FormTerm.Pi)tup._1;
                    if (tup._2 != null) {
                        cube = (FormTerm.Cube)tup._2;
                    }
                }
                catch (NotPi notPi) {
                    Result result12 = this.fail(expr, ErrorTerm.unexpected(notPi.what), BadTypeError.pi(this.state, expr, notPi.what));
                    result = result12;
                    return result;
                }
                Term elabArg = this.inherit(argument.expr(), pi.param().type()).wellTyped();
                subst.addDirectly(pi.param().ref(), elabArg);
                Arg<Term> arg = new Arg<Term>(elabArg, argLicit);
                Term newApp = cube == null ? ElimTerm.make(app, arg) : cube.makeApp(app, arg).subst(subst);
                TermResult termResult = new TermResult(newApp, pi.body().subst(subst));
                result = termResult;
                return result;
            }
            case 10: {
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                Result result13 = this.inherit(hole, (Term)this.localCtx.freshHole(null, (String)Constants.randomName((Object)hole), (SourcePos)hole.sourcePos())._2);
                result = result13;
                return result;
            }
            case 11: {
                Expr.ErrorExpr err = (Expr.ErrorExpr)expr3;
                TermResult termResult = TermResult.error(err.description());
                result = termResult;
                return result;
            }
            case 12: {
                Expr.LitIntExpr lit = (Expr.LitIntExpr)expr3;
                int integer = lit.integer();
                ImmutableSeq<GenericDef> defs = this.shapeFactory.findImpl(AyaShape.NAT_SHAPE);
                if (defs.isEmpty()) {
                    Result result14 = this.fail(expr, new NoRuleError(expr, null));
                    result = result14;
                    return result;
                }
                if (defs.sizeGreaterThan(1)) {
                    Result result15 = this.fail(expr, new LiteralError.AmbiguousLit(expr, defs));
                    result = result15;
                    return result;
                }
                CallTerm.Data type = new CallTerm.Data(((DataDef)defs.first()).ref, 0, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
                TermResult termResult = new TermResult(new LitTerm.ShapedInt(integer, AyaShape.NAT_SHAPE, type), type);
                result = termResult;
                return result;
            }
            case 13: {
                Expr.LitStringExpr litStr = (Expr.LitStringExpr)expr3;
                if (!this.state.primFactory().have(PrimDef.ID.STRING)) {
                    Result result16 = this.fail(expr, new NoRuleError(expr, null));
                    result = result16;
                    return result;
                }
                TermResult termResult = new TermResult(new PrimTerm.Str(litStr.string()), this.state.primFactory().getCall(PrimDef.ID.STRING));
                result = termResult;
                return result;
            }
            case 14: {
                Expr.Path path = (Expr.Path)expr3;
                TermResult termResult = this.localCtx.withIntervals((SeqView<LocalVar>)path.params().view(), () -> {
                    Result type = this.synthesize(path.type());
                    Partial<Term> partial = this.elaboratePartial(path.partial(), type.wellTyped());
                    FormTerm.Cube cube = new FormTerm.Cube(path.params(), type.wellTyped(), partial);
                    return new TermResult(new FormTerm.Path(cube), type.type());
                });
                result = termResult;
                return result;
            }
        }
        Result result17 = this.fail(expr, new NoRuleError(expr, null));
        result = result17;
        return result;
    }

    @NotNull
    public Restr<Term> restr(@NotNull Restr<Expr> restr) {
        return restr.mapCond(this::condition);
    }

    @NotNull
    private Restr.Cond<Term> condition(@NotNull Restr.Cond<Expr> c) {
        return new Restr.Cond((Object)this.inherit((Expr)c.inst(), PrimTerm.Interval.INSTANCE).wellTyped(), c.isOne());
    }

    @NotNull
    private Partial<Term> elaboratePartial(@NotNull Expr.PartEl partial, @NotNull Term type) {
        ClauseTyckState s = new ClauseTyckState();
        ImmutableSeq sides = partial.clauses().flatMap(sys -> this.clause((Expr)sys._1, (Expr)sys._2, type, s));
        this.confluence((ImmutableSeq<Restr.Side<Term>>)sides, partial, type);
        if (s.isConstantFalse) {
            return new Partial.Split(ImmutableSeq.empty());
        }
        if (s.truthValue != null) {
            return new Partial.Const((Restr.TermLike)s.truthValue);
        }
        return new Partial.Split(sides);
    }

    private void confluence(@NotNull ImmutableSeq<Restr.Side<Term>> clauses, @NotNull Expr loc, @NotNull Term type) {
        for (int i = 1; i < clauses.size(); ++i) {
            Restr.Side lhs = (Restr.Side)clauses.get(i);
            for (int j = 0; j < i; ++j) {
                Restr.Side rhs = (Restr.Side)clauses.get(j);
                CofThy.conv((Restr.Conj)lhs.cof().and(rhs.cof()), (CofThy.SubstObj)new Subst(), subst -> this.boundary(loc, (Term)lhs.u(), (Term)rhs.u(), type, (Subst)subst));
            }
        }
    }

    private boolean boundary(@NotNull Expr loc, @NotNull Term lhs, @NotNull Term rhs, @NotNull Term type, Subst subst) {
        Term l = this.whnf(lhs.subst(subst));
        Term r = this.whnf(rhs.subst(subst));
        Term t = this.whnf(type.subst(subst));
        Unifier unifier = this.unifier(loc.sourcePos(), Ordering.Eq);
        boolean happy = unifier.compare(l, r, t);
        if (!happy) {
            this.reporter.report((Problem)new CubicalError.BoundaryDisagree(loc, lhs, rhs, unifier.getFailure(), this.state));
        }
        return happy;
    }

    @NotNull
    private SeqView<Restr.Side<Term>> clause(@NotNull Expr lhs, @NotNull Expr rhs, @NotNull Term rhsType, @NotNull ClauseTyckState clauseState) {
        Restr restr = CofThy.isOne((Restr.TermLike)this.whnf(this.inherit(lhs, PrimTerm.Interval.INSTANCE).wellTyped()));
        Objects.requireNonNull(restr);
        Restr restr2 = restr;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Restr.Disj.class, Restr.Const.class}, (Object)restr2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Restr.Disj restr = (Restr.Disj)restr2;
                MutableList list = MutableList.create();
                for (Restr.Conj cof : restr.orz()) {
                    Option u = CofThy.vdash((Restr.Conj)cof, (CofThy.SubstObj)new Subst(), subst -> this.inherit(rhs, this.whnf(rhsType.subst((Subst)subst))).wellTyped());
                    if (!u.isDefined()) continue;
                    if (u.get() == null) {
                        yield SeqView.empty();
                    }
                    list.append((Object)new Restr.Side(cof, (Restr.TermLike)((Term)u.get())));
                }
                yield list.view();
            }
            case 1 -> {
                Restr.Const c = (Restr.Const)restr2;
                if (c.isOne()) {
                    clauseState.truthValue = this.inherit(rhs, rhsType).wellTyped();
                } else {
                    clauseState.isConstantFalse = true;
                }
                yield SeqView.empty();
            }
        };
    }

    private Term instImplicits(@NotNull Term term, @NotNull SourcePos pos) {
        IntroTerm.Lambda intro;
        term = this.whnf(term);
        while (term instanceof IntroTerm.Lambda && !(intro = (IntroTerm.Lambda)term).param().explicit()) {
            term = this.whnf(ElimTerm.make(intro, this.mockArg(intro.param(), pos)));
        }
        return term;
    }

    private Result instImplicits(@NotNull Result result, @NotNull SourcePos pos) {
        FormTerm.Pi pi;
        Term type = this.whnf(result.type());
        Term term = result.wellTyped();
        while (type instanceof FormTerm.Pi && !(pi = (FormTerm.Pi)type).param().explicit()) {
            Arg<Term> holeApp = this.mockArg(pi.param(), pos);
            term = ElimTerm.make(term, holeApp);
            type = this.whnf(pi.substBody(holeApp.term()));
        }
        return new TermResult(term, type);
    }

    private Tuple2<FormTerm.Pi, @Nullable FormTerm.Cube> ensurePiOrPath(@NotNull Term term) throws NotPi {
        if ((term = this.whnf(term)) instanceof FormTerm.Pi) {
            FormTerm.Pi pi = (FormTerm.Pi)term;
            return Tuple.of((Object)pi, null);
        }
        if (term instanceof FormTerm.Path) {
            FormTerm.Path path = (FormTerm.Path)term;
            return Tuple.of((Object)path.cube().computePi(), (Object)path.cube());
        }
        throw new NotPi(term);
    }

    @NotNull
    private Result doInherit(@NotNull Expr expr, @NotNull Term term) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.TupExpr.class, Expr.HoleExpr.class, Expr.SortExpr.class, Expr.LamExpr.class, Expr.LitIntExpr.class, Expr.PartEl.class}, (Object)expr3, n)) {
            case 0 -> {
                Expr.TupExpr tuple = (Expr.TupExpr)expr3;
                MutableList items = MutableList.create();
                MutableList resultTele = MutableList.create();
                Term typeWHNF = this.whnf(term);
                if (typeWHNF instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)typeWHNF;
                    yield this.unifyTyMaybeInsert(hole, this.synthesize(tuple), tuple);
                }
                if (!(typeWHNF instanceof FormTerm.Sigma)) {
                    yield this.fail(tuple, term, BadTypeError.sigmaCon(this.state, tuple, typeWHNF));
                }
                FormTerm.Sigma dt = (FormTerm.Sigma)typeWHNF;
                SeqView againstTele = dt.params().view();
                Term last = ((Term.Param)dt.params().last()).type();
                Subst subst = new Subst((MutableMap<AnyVar, Term>)MutableMap.create());
                Iterator iter = tuple.items().iterator();
                while (iter.hasNext()) {
                    Expr item = (Expr)iter.next();
                    Term.Param first = ((Term.Param)againstTele.first()).subst(subst);
                    Result result = this.inherit(item, first.type());
                    items.append((Object)result.wellTyped());
                    LocalVar ref = first.ref();
                    resultTele.append((Object)new Term.Param(ref, result.type(), first.explicit()));
                    againstTele = againstTele.drop(1);
                    if (againstTele.isNotEmpty()) {
                        subst.add(ref, result.wellTyped());
                        continue;
                    }
                    if (iter.hasNext()) {
                        yield this.fail(tuple, term, new TupleError.ElemMismatchError(tuple.sourcePos(), dt.params().size(), tuple.items().size()));
                    }
                    items.append((Object)this.inherit(item, last.subst(subst)).wellTyped());
                }
                FormTerm.Sigma resTy = new FormTerm.Sigma((ImmutableSeq<Term.Param>)resultTele.toImmutableSeq());
                yield new TermResult(new IntroTerm.Tuple((ImmutableSeq<Term>)items.toImmutableSeq()), resTy);
            }
            case 1 -> {
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                Tuple2<CallTerm.Hole, Term> freshHole = this.localCtx.freshHole(term, Constants.randomName(hole), hole.sourcePos());
                if (hole.explicit()) {
                    this.reporter.report((Problem)new Goal(this.state, (CallTerm.Hole)freshHole._1, (ImmutableSeq<LocalVar>)((ImmutableSeq)hole.accessibleLocal().get())));
                }
                yield new TermResult((Term)freshHole._2, term);
            }
            case 2 -> {
                Expr.SortExpr sortExpr = (Expr.SortExpr)expr3;
                SortResult result = this.sort(sortExpr);
                Term normTerm = this.whnf(term);
                if (normTerm instanceof FormTerm.Sort) {
                    FormTerm.Sort sort = (FormTerm.Sort)normTerm;
                    Unifier unifier = this.unifier(sortExpr.sourcePos(), Ordering.Lt);
                    unifier.compareSort(result.type(), sort);
                } else {
                    this.unifyTyReported(result.type(), normTerm, sortExpr);
                }
                yield new TermResult(result.wellTyped(), normTerm);
            }
            case 3 -> {
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                if (term instanceof CallTerm.Hole) {
                    this.unifyTy(term, this.generatePi(lam), lam.sourcePos());
                }
                Term v2 = this.whnf(term);
                Objects.requireNonNull(v2);
                Term normTerm = v2;
                int sort = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Pi.class, FormTerm.Path.class}, (Object)normTerm, sort)) {
                    case 0: {
                        FormTerm.Pi dt = (FormTerm.Pi)normTerm;
                        Expr.Param param = lam.param();
                        if (param.explicit() != dt.param().explicit()) {
                            yield this.fail(lam, dt, new LicitError.LicitMismatch(lam, dt));
                        }
                        LocalVar var = param.ref();
                        Expr lamParam = param.type();
                        Term type = dt.param().type();
                        Term result = this.synthesize(lamParam).wellTyped();
                        TermComparator.FailureData comparison = this.unifyTy(result, type, lamParam.sourcePos());
                        if (comparison != null) {
                            yield this.fail(lam, dt, BadTypeError.lamParam(this.state, lam, type, result));
                        }
                        type = result;
                        Term.Param resultParam = new Term.Param(var, type, param.explicit());
                        Term body = dt.substBody(resultParam.toTerm());
                        yield this.localCtx.with(resultParam, () -> {
                            Result rec = this.inherit(lam.body(), body);
                            return new TermResult(new IntroTerm.Lambda(resultParam, rec.wellTyped()), dt);
                        });
                    }
                    case 1: {
                        FormTerm.Path path = (FormTerm.Path)normTerm;
                        yield this.checkBoundaries(expr, path, new Subst(), this.inherit(expr, path.cube().computePi()).wellTyped());
                    }
                }
                yield this.fail(lam, term, BadTypeError.pi(this.state, lam, term));
            }
            case 4 -> {
                Expr.LitIntExpr lit = (Expr.LitIntExpr)expr3;
                Term ty = this.whnf(term);
                if (ty instanceof PrimTerm.Interval) {
                    int end = lit.integer();
                    if (end == 0 || end == 1) {
                        yield new TermResult(end == 0 ? PrimTerm.Mula.LEFT : PrimTerm.Mula.RIGHT, ty);
                    }
                    yield this.fail(expr, new PrimError.BadInterval(lit.sourcePos(), lit.integer()));
                }
                if (ty instanceof CallTerm.Data) {
                    CallTerm.Data dataCall = (CallTerm.Data)ty;
                    DataDef data = (DataDef)((DefVar)dataCall.ref()).core;
                    Option<AyaShape> shape = this.shapeFactory.find(data);
                    if (shape.isDefined()) {
                        yield new TermResult(new LitTerm.ShapedInt(lit.integer(), (AyaShape)shape.get(), dataCall), term);
                    }
                }
                if (ty instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)ty;
                    ImmutableSeq<GenericDef> nat = this.shapeFactory.findImpl(AyaShape.NAT_SHAPE);
                    if (nat.sizeGreaterThan(1)) {
                        yield new TermResult(new LitTerm.ShapedInt(lit.integer(), AyaShape.NAT_SHAPE, hole), term);
                    }
                }
                yield this.unifyTyMaybeInsert(term, this.synthesize(expr), expr);
            }
            case 5 -> {
                Expr.PartEl el = (Expr.PartEl)expr3;
                Term nat = this.whnf(term);
                if (!(nat instanceof FormTerm.PartTy)) {
                    yield this.fail(el, term, BadTypeError.partTy(this.state, el, term));
                }
                FormTerm.PartTy ty = (FormTerm.PartTy)nat;
                Restr<Term> cofTy = ty.restr();
                Term rhsType = ty.type();
                Partial<Term> partial = this.elaboratePartial(el, rhsType);
                Restr face = partial.restr();
                if (!CofThy.conv(cofTy, (CofThy.SubstObj)new Subst(), subst -> CofThy.satisfied(subst.restr(this.state, (Restr<Term>)face)))) {
                    yield this.fail(el, new CubicalError.FaceMismatch(el, (Restr<Term>)face, cofTy));
                }
                yield new TermResult(new IntroTerm.PartEl(partial, rhsType), ty);
            }
            default -> this.unifyTyMaybeInsert(term, this.synthesize(expr), expr);
        };
    }

    private TermResult checkBoundaries(Expr expr, FormTerm.Path path, Subst subst, Term lambda) {
        FormTerm.Cube cube = path.cube();
        Term applied = cube.applyDimsTo(lambda);
        return this.localCtx.withIntervals((SeqView<LocalVar>)cube.params().view(), () -> {
            Partial<Term> partial = cube.partial();
            Objects.requireNonNull(partial);
            Partial<Term> partial2 = partial;
            int n = 0;
            boolean happy = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Partial.Const.class, Partial.Split.class}, partial2, n)) {
                default -> throw new RuntimeException(null, null);
                case 0 -> {
                    Partial.Const sad = (Partial.Const)partial2;
                    yield this.boundary(expr, applied, (Term)sad.u(), cube.type(), subst);
                }
                case 1 -> {
                    Partial.Split hap = (Partial.Split)partial2;
                    yield hap.clauses().allMatch(c -> CofThy.conv((Restr.Conj)c.cof(), (CofThy.SubstObj)subst, s -> this.boundary(expr, applied, (Term)c.u(), cube.type(), (Subst)s)));
                }
            };
            return happy ? new TermResult(new IntroTerm.PathLam(cube.params(), applied), path) : new TermResult(ErrorTerm.unexpected(expr), path);
        });
    }

    @NotNull
    private SortResult doSort(@NotNull Expr expr) {
        FormTerm.Type univ = FormTerm.Type.ZERO;
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.TupExpr.class, Expr.HoleExpr.class, Expr.SortExpr.class, Expr.LamExpr.class, Expr.PartEl.class, Expr.PiExpr.class, Expr.SigmaExpr.class}, (Object)expr3, n)) {
            case 0 -> {
                Expr.TupExpr tuple = (Expr.TupExpr)expr3;
                yield this.failSort(tuple, BadTypeError.sigmaCon(this.state, tuple, univ));
            }
            case 1 -> {
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                Tuple2<CallTerm.Hole, Term> freshHole = this.localCtx.freshHole(univ, Constants.randomName(hole), hole.sourcePos());
                if (hole.explicit()) {
                    this.reporter.report((Problem)new Goal(this.state, (CallTerm.Hole)freshHole._1, (ImmutableSeq<LocalVar>)((ImmutableSeq)hole.accessibleLocal().get())));
                }
                yield new SortResult((Term)freshHole._2, univ);
            }
            case 2 -> {
                Expr.SortExpr sortExpr;
                Expr.SortExpr v2 = sortExpr = (Expr.SortExpr)expr3;
                Objects.requireNonNull(v2);
                Expr.SortExpr var9_9 = v2;
                int var10_11 = 0;
                FormTerm.Sort v3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.TypeExpr.class, Expr.SetExpr.class, Expr.PropExpr.class, Expr.ISetExpr.class}, (Object)var9_9, var10_11)) {
                    default -> throw new RuntimeException(null, null);
                    case 0 -> {
                        Expr.TypeExpr ty = (Expr.TypeExpr)var9_9;
                        yield new FormTerm.Type(ty.lift());
                    }
                    case 1 -> {
                        Expr.SetExpr set = (Expr.SetExpr)var9_9;
                        yield new FormTerm.Set(set.lift());
                    }
                    case 2 -> {
                        Expr.PropExpr prop = (Expr.PropExpr)var9_9;
                        yield FormTerm.Prop.INSTANCE;
                    }
                    case 3 -> {
                        Expr.ISetExpr iset = (Expr.ISetExpr)var9_9;
                        yield FormTerm.ISet.INSTANCE;
                    }
                };
                FormTerm.Sort self = v3;
                yield new SortResult(self, self.succ());
            }
            case 3 -> {
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                yield this.failSort(lam, BadTypeError.pi(this.state, lam, univ));
            }
            case 4 -> {
                Expr.PartEl el = (Expr.PartEl)expr3;
                yield this.failSort(el, BadTypeError.partTy(this.state, el, univ));
            }
            case 5 -> {
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                Expr.Param param = pi.param();
                LocalVar var = param.ref();
                Expr domTy = param.type();
                SortResult domRes = this.sort(domTy);
                Term.Param resultParam = new Term.Param(var, domRes.wellTyped(), param.explicit());
                yield this.localCtx.with(resultParam, () -> {
                    SortResult cod = this.sort(pi.last());
                    return new SortResult(new FormTerm.Pi(resultParam, cod.wellTyped()), this.sortPi(pi, domRes.type(), cod.type()));
                });
            }
            case 6 -> {
                Expr.SigmaExpr sigma = (Expr.SigmaExpr)expr3;
                MutableList resultTele = MutableList.create();
                MutableList resultTypes = MutableList.create();
                for (Expr.Param tuple : sigma.params()) {
                    SortResult result = this.sort(tuple.type());
                    resultTypes.append((Object)result.type());
                    LocalVar ref = tuple.ref();
                    this.localCtx.put(ref, result.wellTyped());
                    resultTele.append((Object)Tuple.of((Object)ref, (Object)tuple.explicit(), (Object)result.wellTyped()));
                }
                Unifier unifier = this.unifier(sigma.sourcePos(), Ordering.Lt);
                FormTerm.Sort maxSort = (FormTerm.Sort)resultTypes.reduce(FormTerm.Sort::max);
                resultTypes.forEach(t -> unifier.compareSort((FormTerm.Sort)t, maxSort));
                this.localCtx.remove((SeqView<LocalVar>)sigma.params().view().map(Expr.Param::ref));
                yield new SortResult(new FormTerm.Sigma(Term.Param.fromBuffer((MutableList<Tuple3<LocalVar, Boolean, Term>>)resultTele)), maxSort);
            }
            default -> {
                Result result = this.synthesize(expr);
                yield new SortResult(result.wellTyped(), this.ty(expr, result.type()));
            }
        };
    }

    @NotNull
    public TyResult ty(@NotNull Expr expr) {
        return new TyResult(this.ty(expr, this.sort(expr).wellTyped()));
    }

    @NotNull
    private FormTerm.Sort ty(@NotNull Expr errorMsg, @NotNull Term term) {
        Term term2 = this.whnf(term);
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Sort.class, CallTerm.Hole.class}, (Object)term3, n)) {
            case 0 -> {
                FormTerm.Sort u;
                yield u = (FormTerm.Sort)term3;
            }
            case 1 -> {
                CallTerm.Hole hole = (CallTerm.Hole)term3;
                this.unifyTyReported(hole, FormTerm.Type.ZERO, errorMsg);
                yield FormTerm.Type.ZERO;
            }
            default -> {
                this.reporter.report((Problem)BadTypeError.univ(this.state, errorMsg, term));
                yield FormTerm.Type.ZERO;
            }
        };
    }

    private void traceExit(Result result, @NotNull Expr expr) {
        LazyValue frozen = LazyValue.of(() -> result.freezeHoles(this.state));
        this.tracing(builder -> {
            builder.append(new Trace.TyckT((Result)frozen.get(), expr.sourcePos()));
            builder.reduce();
        });
        if (expr instanceof Expr.WithTerm) {
            Expr.WithTerm withTerm = (Expr.WithTerm)expr;
            withTerm.theCore().set((Object)((Result)frozen.get()));
        }
    }

    public ExprTycker(@NotNull PrimDef.Factory primFactory, @NotNull AyaShape.Factory shapeFactory, @NotNull Reporter reporter,  @Nullable Trace.Builder traceBuilder) {
        super(reporter, new TyckState(primFactory), traceBuilder);
        this.shapeFactory = shapeFactory;
    }

    @NotNull
    public Result inherit(@NotNull Expr expr, @NotNull Term type) {
        Result result;
        FormTerm.Pi pi;
        this.tracing(builder -> builder.shift(new Trace.ExprT(expr, type.freezeHoles(this.state))));
        if (type instanceof FormTerm.Pi && !(pi = (FormTerm.Pi)type).param().explicit() && ExprTycker.needImplicitParamIns(expr)) {
            Term.Param implicitParam = new Term.Param(new LocalVar("_"), pi.param().type(), false);
            Term body = this.localCtx.with(implicitParam, () -> this.inherit(expr, pi.substBody(implicitParam.toTerm()))).wellTyped();
            result = new TermResult(new IntroTerm.Lambda(implicitParam, body), pi);
        } else {
            result = this.doInherit(expr, type);
        }
        this.traceExit(result, expr);
        return result;
    }

    @NotNull
    public Result synthesize(@NotNull Expr expr) {
        this.tracing(builder -> builder.shift(new Trace.ExprT(expr, null)));
        Result res = this.doSynthesize(expr);
        this.traceExit(res, expr);
        return res;
    }

    @NotNull
    public SortResult sort(@NotNull Expr expr) {
        return this.sort(expr, -1);
    }

    @NotNull
    public SortResult sort(@NotNull Expr expr, int upperBound) {
        this.tracing(builder -> builder.shift(new Trace.ExprT(expr, null)));
        SortResult result = this.doSort(expr);
        if (upperBound != -1 && upperBound < result.type().lift()) {
            this.reporter.report((Problem)new LevelError(expr.sourcePos(), new FormTerm.Type(upperBound), result.type(), true));
        }
        this.traceExit(result, expr);
        return result;
    }

    @NotNull
    public FormTerm.Sort sortPi(@NotNull Expr expr, @NotNull FormTerm.Sort domain, @NotNull FormTerm.Sort codomain) {
        FormTerm.Sort result;
        FormTerm.Sort sort = domain;
        Objects.requireNonNull(sort);
        FormTerm.Sort sort2 = sort;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Type.class, FormTerm.ISet.class, FormTerm.Set.class, FormTerm.Prop.class}, (Object)sort2, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                FormTerm.Sort sort3;
                FormTerm.Type a = (FormTerm.Type)sort2;
                FormTerm.Sort sort4 = codomain;
                Objects.requireNonNull(sort4);
                FormTerm.Sort sort5 = sort4;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Type.class, FormTerm.Set.class, FormTerm.ISet.class, FormTerm.Prop.class}, (Object)sort5, n2)) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case 0: {
                        FormTerm.Type b = (FormTerm.Type)sort5;
                        sort3 = new FormTerm.Type(Math.max(a.lift(), b.lift()));
                        break block0;
                    }
                    case 1: {
                        FormTerm.Set b = (FormTerm.Set)sort5;
                        sort3 = new FormTerm.Type(Math.max(a.lift(), b.lift()));
                        break block0;
                    }
                    case 2: {
                        FormTerm.ISet b = (FormTerm.ISet)sort5;
                        sort3 = new FormTerm.Set(a.lift());
                        break block0;
                    }
                    case 3: 
                }
                FormTerm.Prop prop = (FormTerm.Prop)sort5;
                sort3 = FormTerm.Prop.INSTANCE;
                break;
            }
            case 1: {
                FormTerm.ISet a = (FormTerm.ISet)sort2;
                FormTerm.Sort sort6 = codomain;
                Objects.requireNonNull(sort6);
                FormTerm.Sort sort7 = sort6;
                int n3 = 0;
                FormTerm.Sort sort3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.ISet.class, FormTerm.Set.class, FormTerm.Type.class}, (Object)sort7, n3)) {
                    case 0 -> {
                        FormTerm.ISet b = (FormTerm.ISet)sort7;
                        yield FormTerm.Set.ZERO;
                    }
                    case 1 -> {
                        FormTerm.Set b;
                        yield b = (FormTerm.Set)sort7;
                    }
                    case 2 -> {
                        FormTerm.Type b = (FormTerm.Type)sort7;
                        yield b;
                    }
                    default -> null;
                };
                break;
            }
            case 2: {
                FormTerm.Sort sort3;
                FormTerm.Set a = (FormTerm.Set)sort2;
                FormTerm.Sort sort8 = codomain;
                Objects.requireNonNull(sort8);
                FormTerm.Sort sort9 = sort8;
                int n4 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Set.class, FormTerm.Type.class, FormTerm.ISet.class}, (Object)sort9, n4)) {
                    case 0: {
                        FormTerm.Set b = (FormTerm.Set)sort9;
                        sort3 = new FormTerm.Set(Math.max(a.lift(), b.lift()));
                        break block0;
                    }
                    case 1: {
                        FormTerm.Type b = (FormTerm.Type)sort9;
                        sort3 = new FormTerm.Set(Math.max(a.lift(), b.lift()));
                        break block0;
                    }
                    case 2: {
                        FormTerm.ISet b = (FormTerm.ISet)sort9;
                        sort3 = new FormTerm.Set(a.lift());
                        break block0;
                    }
                }
                sort3 = null;
                break;
            }
            case 3: {
                FormTerm.Sort sort3;
                FormTerm.Prop a = (FormTerm.Prop)sort2;
                FormTerm.Sort sort10 = codomain;
                Objects.requireNonNull(sort10);
                FormTerm.Sort sort11 = sort10;
                int n5 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Prop.class, FormTerm.Type.class}, (Object)sort11, n5)) {
                    case 0: {
                        FormTerm.Prop b = (FormTerm.Prop)sort11;
                        sort3 = FormTerm.Prop.INSTANCE;
                        break block0;
                    }
                    case 1: {
                        FormTerm.Type b = (FormTerm.Type)sort11;
                        sort3 = b;
                        break block0;
                    }
                }
                sort3 = result = null;
            }
        }
        if (result == null) {
            this.reporter.report((Problem)new SortPiError(expr.sourcePos(), domain, codomain));
            return FormTerm.Type.ZERO;
        }
        return result;
    }

    private static boolean needImplicitParamIns(@NotNull Expr expr) {
        Expr.LamExpr ex;
        return expr instanceof Expr.LamExpr && (ex = (Expr.LamExpr)expr).param().explicit() || !(expr instanceof Expr.LamExpr);
    }

    @NotNull
    public Result zonk(@NotNull Result result) {
        this.solveMetas();
        return new TermResult(this.zonk(result.wellTyped()), this.zonk(result.type()));
    }

    @NotNull
    private Term generatePi(@NotNull Expr.LamExpr expr) {
        Expr.Param param = expr.param();
        return this.generatePi(expr.sourcePos(), param.ref().name(), param.explicit());
    }

    @NotNull
    private Term generatePi(@NotNull SourcePos pos, @NotNull String name, boolean explicit) {
        String genName = name + "'";
        Term domain = (Term)this.localCtx.freshHole((Term)FormTerm.Type.ZERO, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001ty"}, (String)genName)), (SourcePos)pos)._2;
        Term codomain = (Term)this.localCtx.freshHole((Term)FormTerm.Type.ZERO, (SourcePos)pos)._2;
        return new FormTerm.Pi(new Term.Param(new LocalVar(genName, pos), domain, explicit), codomain);
    }

    @NotNull
    private Result fail(@NotNull AyaDocile expr, @NotNull Problem prob) {
        return this.fail(expr, ErrorTerm.typeOf(expr), prob);
    }

    @NotNull
    private Result fail(@NotNull AyaDocile expr, @NotNull Term term, @NotNull Problem prob) {
        this.reporter.report(prob);
        return new TermResult(new ErrorTerm(expr), term);
    }

    @NotNull
    private SortResult failSort(@NotNull AyaDocile expr, @NotNull Problem prob) {
        this.reporter.report(prob);
        return new SortResult(new ErrorTerm(expr), FormTerm.Type.ZERO);
    }

    @NotNull
    private Result inferRef(@NotNull SourcePos pos, @NotNull DefVar<?, ?> var) {
        if (var.core instanceof FnDef || var.concrete instanceof TeleDecl.FnDecl) {
            return this.defCall(pos, var, CallTerm.Fn::new);
        }
        if (var.core instanceof PrimDef) {
            return this.defCall(pos, var, CallTerm.Prim::new);
        }
        if (var.core instanceof DataDef || var.concrete instanceof TeleDecl.DataDecl) {
            return this.defCall(pos, var, CallTerm.Data::new);
        }
        if (var.core instanceof StructDef || var.concrete instanceof TeleDecl.StructDecl) {
            return this.defCall(pos, var, CallTerm.Struct::new);
        }
        if (var.core instanceof CtorDef || var.concrete instanceof TeleDecl.DataCtor) {
            DefVar<CtorDef, TeleDecl.DataCtor> conVar = var;
            ImmutableSeq<Term.Param> tele = Def.defTele(conVar);
            Term type = FormTerm.Pi.make(tele, Def.defResult(conVar));
            DataDef.CtorTelescopes telescopes = CtorDef.telescopes(conVar).rename();
            CallTerm.Con body = telescopes.toConCall(conVar);
            return new TermResult(IntroTerm.Lambda.make(telescopes.params(), body), type);
        }
        if (var.core instanceof FieldDef || var.concrete instanceof TeleDecl.StructField) {
            DefVar<CtorDef, TeleDecl.DataCtor> field = var;
            return new TermResult(new RefTerm.Field(field), Def.defType(field));
        }
        String msg = "Def var `" + var.name() + "` has core `" + String.valueOf(var.core) + "` which we don't know.";
        throw new InternalException(msg);
    }

    @NotNull
    private <D extends Def, S extends Decl & Decl.Telescopic> Result defCall(@NotNull SourcePos pos, DefVar<D, S> defVar, CallTerm.Factory<D, S> function) {
        Term type;
        Term body;
        ImmutableSeq teleRenamed;
        block4: {
            block3: {
                block2: {
                    ImmutableSeq<Term.Param> tele = Def.defTele(defVar);
                    teleRenamed = tele.map(Term.Param::rename);
                    body = function.make(defVar, 0, (ImmutableSeq<Arg<Term>>)teleRenamed.map(Term.Param::toArg));
                    type = FormTerm.Pi.make(tele, Def.defResult(defVar));
                    Object Core = defVar.core;
                    if (!(Core instanceof FnDef)) break block2;
                    FnDef fn = (FnDef)Core;
                    if (fn.modifiers.contains((Object)Modifier.Inline)) break block3;
                }
                if (!(defVar.core instanceof PrimDef)) break block4;
            }
            body = this.whnf(body);
        }
        return new TermResult(IntroTerm.Lambda.make((SeqLike<Term.Param>)teleRenamed, body), type);
    }

    private TermComparator.FailureData unifyTy(@NotNull Term upper, @NotNull Term lower, @NotNull SourcePos pos) {
        this.tracing(builder -> builder.append(new Trace.UnifyT(lower.freezeHoles(this.state), upper.freezeHoles(this.state), pos)));
        Unifier unifier = this.unifier(pos, Ordering.Lt);
        if (!unifier.compare(lower, upper, null)) {
            return unifier.getFailure();
        }
        return null;
    }

    @NotNull
    public Unifier unifier(@NotNull SourcePos pos, @NotNull Ordering ord) {
        return this.unifier(pos, ord, this.localCtx);
    }

    void unifyTyReported(@NotNull Term upper, @NotNull Term lower, Expr loc) {
        TermComparator.FailureData unification = this.unifyTy(upper, lower, loc.sourcePos());
        if (unification != null) {
            this.reporter.report((Problem)new UnifyError.Type(loc, upper, lower, unification, this.state));
        }
    }

    private Result unifyTyMaybeInsert(@NotNull Term upper, @NotNull Result result, Expr loc) {
        Result inst = this.instImplicits(result, loc.sourcePos());
        Term lower = inst.type();
        Term term = inst.wellTyped();
        TermComparator.FailureData failureData = this.unifyTy(upper, lower, loc.sourcePos());
        if (failureData == null) {
            return inst;
        }
        return this.fail(term.freezeHoles(this.state), upper, new UnifyError.Type(loc, upper.freezeHoles(this.state), lower.freezeHoles(this.state), failureData, this.state));
    }

    @NotNull
    private Term mockTerm(Term.Param param, SourcePos pos) {
        String genName = param.ref().name().concat("'");
        return (Term)this.localCtx.freshHole((Term)param.type(), (String)genName, (SourcePos)pos)._2;
    }

    @NotNull
    private Arg<Term> mockArg(Term.Param param, SourcePos pos) {
        return new Arg<Term>(this.mockTerm(param, pos), param.explicit());
    }

    public static interface Result {
        @NotNull
        public Term wellTyped();

        @NotNull
        public Term type();

        @NotNull
        public Result freezeHoles(@NotNull TyckState var1);
    }

    public static final class SortResult
    extends Record
    implements Result {
        @NotNull
        private final Term wellTyped;
        @NotNull
        private final FormTerm.Sort type;

        public SortResult(@NotNull Term wellTyped, @NotNull FormTerm.Sort type) {
            this.wellTyped = wellTyped;
            this.type = type;
        }

        @Override
        @NotNull
        public SortResult freezeHoles(@NotNull TyckState state) {
            return new SortResult(this.wellTyped.freezeHoles(state), this.type);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SortResult.class, "wellTyped;type", "wellTyped", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SortResult.class, "wellTyped;type", "wellTyped", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SortResult.class, "wellTyped;type", "wellTyped", "type"}, this, o);
        }

        @Override
        @NotNull
        public Term wellTyped() {
            return this.wellTyped;
        }

        @Override
        @NotNull
        public FormTerm.Sort type() {
            return this.type;
        }
    }

    public record TermResult(@NotNull Term wellTyped, @NotNull Term type) implements Result
    {
        @Contract(value=" -> new", pure=true)
        @NotNull
        public Tuple2<Term, Term> toTuple() {
            return Tuple.of((Object)this.type, (Object)this.wellTyped);
        }

        @NotNull
        public static TermResult error(@NotNull AyaDocile description) {
            return new TermResult(ErrorTerm.unexpected(description), ErrorTerm.typeOf(description));
        }

        @Override
        @NotNull
        public TermResult freezeHoles(@NotNull TyckState state) {
            return new TermResult(this.wellTyped.freezeHoles(state), this.type.freezeHoles(state));
        }
    }

    private static final class NotPi
    extends Exception {
        @NotNull
        private final Term what;

        public NotPi(@NotNull Term what) {
            this.what = what;
        }
    }

    private static class ClauseTyckState {
        public boolean isConstantFalse = false;
        @Nullable
        public Term truthValue;

        private ClauseTyckState() {
        }
    }

    public static final class TyResult
    extends Record
    implements Result {
        @NotNull
        private final FormTerm.Sort wellTyped;

        public TyResult(@NotNull FormTerm.Sort wellTyped) {
            this.wellTyped = wellTyped;
        }

        @Override
        @NotNull
        public FormTerm.Sort type() {
            return this.wellTyped.succ();
        }

        @Override
        @NotNull
        public TyResult freezeHoles(@NotNull TyckState state) {
            return this;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TyResult.class, "wellTyped", "wellTyped"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TyResult.class, "wellTyped", "wellTyped"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TyResult.class, "wellTyped", "wellTyped"}, this, o);
        }

        @Override
        @NotNull
        public FormTerm.Sort wellTyped() {
            return this.wellTyped;
        }
    }
}

