/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.concrete.Expr;
import org.aya.core.term.Term;
import org.aya.generic.ExprProblem;
import org.aya.generic.util.NormalizeMode;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.TyckError;
import org.aya.tyck.unify.TermComparator;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.NotNull;

public interface UnifyError
extends TyckError {
    @NotNull
    public TyckState state();

    @NotNull
    public TermComparator.FailureData failureData();

    @NotNull
    default public Doc describeUnify(@NotNull DistillerOptions options, @NotNull Doc prologue, @NotNull Term actual, @NotNull Doc epilogue, @NotNull Term expected) {
        Doc failureLhs;
        Doc actualDoc = actual.toDoc(options);
        MutableList buf = MutableList.of((Object)prologue, (Object)Doc.par((int)1, (Doc)actualDoc));
        Doc actualNFDoc = actual.normalize(this.state(), NormalizeMode.NF).toDoc(options);
        if (!actualNFDoc.equals((Object)actualDoc)) {
            buf.append((Object)Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), actualNFDoc}))));
        }
        Doc expectedDoc = expected.toDoc(options);
        buf.append((Object)epilogue);
        buf.append((Object)Doc.par((int)1, (Doc)expectedDoc));
        Doc expectedNFDoc = expected.normalize(this.state(), NormalizeMode.NF).toDoc(options);
        if (!expectedNFDoc.equals((Object)expectedDoc)) {
            buf.append((Object)Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), expectedNFDoc}))));
        }
        if (!((failureLhs = this.failureData().lhs().freezeHoles(this.state()).toDoc(options)).equals((Object)actualDoc) || failureLhs.equals((Object)expectedDoc) || failureLhs.equals((Object)actualNFDoc) || failureLhs.equals((Object)expectedNFDoc))) {
            buf.appendAll((Object[])new Doc[]{Doc.english((String)"In particular, we failed to unify"), Doc.par((int)1, (Doc)failureLhs), Doc.english((String)"with"), Doc.par((int)1, (Doc)this.failureData().rhs().freezeHoles(this.state()).toDoc(options))});
        }
        return Doc.vcat((SeqLike)buf);
    }

    public record Type(@NotNull Expr expr, @NotNull Term expected, @NotNull Term actual, @NotNull TermComparator.FailureData failureData, @NotNull TyckState state) implements ExprProblem,
    UnifyError
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            Doc prologue = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot check the expression"), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.english((String)"of type")});
            return this.describeUnify(options, prologue, this.actual, Doc.english((String)"against the type"), this.expected);
        }
    }
}

