/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import org.aya.core.def.CtorDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.Term;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.tyck.pat.PatClassifier;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClausesProblem
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @NotNull
    private static Doc termToHint(@Nullable Term term, @NotNull DistillerOptions options) {
        return term == null ? Doc.empty() : Doc.sep((Doc[])new Doc[]{Doc.english((String)"substituted to"), Doc.styled((Style)Style.code(), (Doc)term.toDoc(options))});
    }

    public record FMDomination(int sub, @NotNull SourcePos sourcePos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.sub), Doc.english((String)"clause is dominated by the other clauses, hence unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record Domination(int dom, int sub, @NotNull SourcePos sourcePos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            Doc subOrdinal = Doc.ordinal((int)this.sub);
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.dom), Doc.english((String)"clause dominates the"), subOrdinal, Doc.english((String)"clause. The"), subOrdinal, Doc.english((String)"clause will be unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record UnsureCase(@NotNull SourcePos sourcePos, @NotNull CtorDef ctor, @NotNull CallTerm.Data dataCall) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"I'm unsure if there should be a case for constructor"), Doc.par((int)1, (Doc)this.ctor.toDoc(options)), Doc.english((String)"because I got stuck on the index unification of type"), Doc.par((int)1, (Doc)this.dataCall.toDoc(options))});
        }
    }

    public record SplitInterval(@NotNull SourcePos sourcePos, @NotNull Pat pat) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Cannot perform pattern matching"), Doc.styled((Style)Style.code(), (Doc)this.pat.toDoc(options))});
        }
    }

    public record MissingBindCase(@NotNull SourcePos sourcePos, @NotNull Term.Param param, @NotNull Term typeNF) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The parameter:"), Doc.par((int)1, (Doc)this.param.toDoc(options)), Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.english((String)"Normalized:"), this.typeNF.toDoc(options)}))), Doc.english((String)"requires a binding in the patterns")});
        }
    }

    public record MissingCase(@NotNull SourcePos sourcePos, @NotNull PatClassifier.PatErr pats) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unhandled case:"), Doc.commaList((SeqLike)this.pats.missing().map(t -> t.toDoc(options)))});
        }
    }

    public record Confluence(@NotNull SourcePos sourcePos, int i, int j, @NotNull Term lhs, @NotNull Term rhs, @NotNull SourcePos iPos, @NotNull SourcePos jPos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.i), Doc.english((String)"and the"), Doc.ordinal((int)this.j), Doc.english((String)"clauses are not confluent because we failed to unify")}), Doc.par((int)1, (Doc)this.lhs.toDoc(options)), Doc.plain((String)"and"), Doc.par((int)1, (Doc)this.rhs.toDoc(options))});
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull DistillerOptions options) {
            return Seq.of((Object)new WithPos(this.iPos, (Object)ClausesProblem.termToHint(this.lhs, options)), (Object)new WithPos(this.jPos, (Object)ClausesProblem.termToHint(this.rhs, options))).view();
        }
    }

    public record Conditions(@NotNull SourcePos sourcePos, int i, int j, @NotNull Term lhs, @Nullable Term rhs, @NotNull SourcePos conditionPos, @NotNull SourcePos iPos, @Nullable SourcePos jPos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            Doc result = this.rhs != null ? Doc.sep((Doc[])new Doc[]{Doc.plain((String)"unify"), Doc.styled((Style)Style.code(), (Doc)this.lhs.toDoc(options)), Doc.plain((String)"and"), Doc.styled((Style)Style.code(), (Doc)this.rhs.toDoc(options))}) : Doc.english((String)"even reduce one of the clause(s) to check condition");
            return Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.i), Doc.english((String)"clause matches on a constructor with condition(s). When checking the"), Doc.ordinal((int)this.j), Doc.english((String)"condition, we failed to"), result});
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull DistillerOptions options) {
            SeqView view = Seq.of((Object)new WithPos(this.conditionPos, (Object)Doc.plain((String)"relevant condition")), (Object)new WithPos(this.iPos, (Object)ClausesProblem.termToHint(this.lhs, options))).view();
            return this.rhs == null || this.jPos == null ? view : view.concat((SeqLike)Seq.of((Object)new WithPos(this.jPos, (Object)ClausesProblem.termToHint(this.rhs, options))));
        }
    }
}

