/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import org.aya.concrete.remark.CodeAttrProcessor;
import org.aya.concrete.remark.Literate;
import org.aya.generic.util.NormalizeMode;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.pretty.doc.Doc;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.commonmark.node.Code;
import org.commonmark.node.Node;
import org.jetbrains.annotations.NotNull;

public record CodeOptions(@NotNull NormalizeMode mode, @NotNull PrettierOptions options, @NotNull ShowCode showCode) {
    @NotNull
    public static final CodeOptions DEFAULT = new CodeOptions(NormalizeMode.NULL, AyaPrettierOptions.pretty(), ShowCode.Core);

    @NotNull
    public static Literate analyze(@NotNull Code code, @NotNull SourcePos sourcePos) {
        Node node = code.getFirstChild();
        if (node instanceof CodeAttrProcessor.Attr) {
            CodeAttrProcessor.Attr attr = (CodeAttrProcessor.Attr)node;
            return new Literate.Code(code.getLiteral(), sourcePos, attr.options);
        }
        return new Literate.Raw(Doc.code((String)"", (Doc)Doc.plain((String)code.getLiteral())));
    }

    public static enum ShowCode {
        Concrete,
        Core,
        Type;

    }
}

