/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.remark.CodeOptions;
import org.aya.core.def.UserDef;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Docile;
import org.aya.pretty.doc.Link;
import org.aya.pretty.doc.Style;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.tyck.ExprTycker;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Literate
extends Docile {

    public record Unsupported(@NotNull ImmutableSeq<Literate> children) implements Literate
    {
        @NotNull
        public Doc toDoc() {
            return Doc.vcat((SeqLike)this.children.map(Docile::toDoc));
        }
    }

    public static final class CodeBlock
    implements Literate {
        @NotNull
        public final String language;
        @NotNull
        public final String raw;
        @Nullable
        public Doc highlighted;
        @Nullable
        public final SourcePos sourcePos;

        public CodeBlock(@Nullable SourcePos sourcePos, @NotNull String language, @NotNull String raw) {
            this.language = language;
            this.raw = raw;
            this.sourcePos = sourcePos;
        }

        public boolean isAya() {
            return this.language.equalsIgnoreCase("aya");
        }

        @NotNull
        public Doc toDoc() {
            Doc doc = this.isAya() && this.highlighted != null ? this.highlighted : Doc.plain((String)this.raw);
            return Doc.codeBlock((String)this.language, (Doc)doc);
        }
    }

    public static final class Code
    implements Literate {
        @NotNull
        public final String code;
        @NotNull
        public final SourcePos sourcePos;
        @Nullable
        public Expr expr;
        @Nullable
        public ExprTycker.Result tyckResult;
        @NotNull
        public final CodeOptions options;

        public Code(@NotNull String code, @NotNull SourcePos sourcePos, @NotNull CodeOptions options) {
            this.code = code;
            this.sourcePos = sourcePos;
            this.options = options;
        }

        @NotNull
        public Doc toDoc() {
            if (this.tyckResult == null) {
                if (this.expr != null) {
                    return Doc.code((Doc)this.expr.toDoc(this.options.options()));
                }
                return Doc.code((String)"Error");
            }
            assert (this.expr != null);
            return Doc.code((Doc)(switch (this.options.showCode()) {
                default -> throw new IncompatibleClassChangeError();
                case CodeOptions.ShowCode.Concrete -> this.expr;
                case CodeOptions.ShowCode.Core -> this.tyckResult.wellTyped();
                case CodeOptions.ShowCode.Type -> this.tyckResult.type();
            }).toDoc(this.options.options()));
        }
    }

    public record Err(@NotNull MutableValue<AnyVar> def, @NotNull SourcePos sourcePos) implements Literate
    {
        @NotNull
        public Doc toDoc() {
            Object object = this.def.get();
            if (object instanceof DefVar) {
                DefVar defVar = (DefVar)object;
                object = defVar.core;
                if (object instanceof UserDef) {
                    UserDef userDef = (UserDef)object;
                    ImmutableSeq<Problem> problems = userDef.problems;
                    if (problems == null) {
                        return Doc.styled((Style)Style.bold(), (Doc)Doc.english((String)"No error message."));
                    }
                    return Doc.vcat((SeqLike)problems.map(problem -> problem.brief((PrettierOptions)AyaPrettierOptions.informative())));
                }
            }
            return Doc.styled((Style)Style.bold(), (Doc)Doc.english((String)"Not a definition that can obtain error message."));
        }
    }

    public record Many(@Nullable Style style, @NotNull ImmutableSeq<Literate> children) implements Literate
    {
        @NotNull
        public Doc toDoc() {
            Doc child = Doc.cat((SeqLike)this.children().map(Docile::toDoc));
            return this.style == null ? child : Doc.styled((Style)this.style, (Doc)child);
        }
    }

    public record Image(@NotNull String src, @NotNull ImmutableSeq<Literate> children) implements Literate
    {
        @NotNull
        public Doc toDoc() {
            Doc child = Doc.cat((SeqLike)this.children().map(Docile::toDoc));
            return Doc.image((Doc)child, (Link)Link.page((String)this.src));
        }
    }

    public record HyperLink(@NotNull String href, @Nullable String hover, @NotNull ImmutableSeq<Literate> children) implements Literate
    {
        @NotNull
        public Doc toDoc() {
            Doc child = Doc.cat((SeqLike)this.children().map(Docile::toDoc));
            return Doc.hyperLink((Doc)child, (Link)Link.page((String)this.href), (String)this.hover);
        }
    }

    public record List(@NotNull ImmutableSeq<Literate> items, boolean ordered) implements Literate
    {
        @NotNull
        public Doc toDoc() {
            return Doc.list((boolean)this.ordered, (SeqLike)this.items.map(Docile::toDoc));
        }
    }

    public record Raw(@NotNull Doc toDoc) implements Literate
    {
    }
}

