/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import java.util.EnumSet;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Either;
import kala.control.Option;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.CommonDecl;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.term.DataCall;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.generic.Modifier;
import org.aya.ref.DefVar;
import org.aya.resolve.context.Context;
import org.aya.util.Arg;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TeleDecl<RetTy extends Term>
extends CommonDecl
implements Decl.Telescopic<RetTy>,
Decl.TopLevel {
    @NotNull
    private final Decl.Personality personality;
    @Nullable
    public Context ctx = null;
    @NotNull
    public Expr result;
    @NotNull
    public ImmutableSeq<Expr.Param> telescope;
    @Nullable
    public Def.Signature<RetTy> signature;

    @Override
    @NotNull
    public Decl.Personality personality() {
        return this.personality;
    }

    @Override
    @Nullable
    public Context getCtx() {
        return this.ctx;
    }

    @Override
    public void setCtx(@NotNull Context ctx) {
        this.ctx = ctx;
    }

    @Override
    @NotNull
    public Expr result() {
        return this.result;
    }

    @Override
    public void modifyResult(@NotNull UnaryOperator<Expr> f) {
        this.result = (Expr)f.apply(this.result);
    }

    @Override
    @NotNull
    public ImmutableSeq<Expr.Param> telescope() {
        return this.telescope;
    }

    @Override
    public void modifyTelescope(@NotNull UnaryOperator<ImmutableSeq<Expr.Param>> f) {
        this.telescope = (ImmutableSeq)f.apply(this.telescope);
    }

    @Override
    public @Nullable Def.Signature<RetTy> signature() {
        return this.signature;
    }

    protected TeleDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.OpInfo opInfo, @NotNull BindBlock bindBlock, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Decl.Personality personality) {
        super(sourcePos, entireSourcePos, accessibility, opInfo, bindBlock);
        this.result = result;
        this.personality = personality;
        this.telescope = telescope;
    }

    @Contract(pure=true)
    @NotNull
    public abstract DefVar<? extends Def, ? extends TeleDecl<RetTy>> ref();

    public static final class FnDecl
    extends TeleDecl<Term> {
        @NotNull
        public final EnumSet<Modifier> modifiers;
        @NotNull
        public final DefVar<FnDef, FnDecl> ref;
        @NotNull
        public Either<Expr, ImmutableSeq<Pattern.Clause>> body;

        public FnDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @NotNull EnumSet<Modifier> modifiers, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Either<Expr, ImmutableSeq<Pattern.Clause>> body, @NotNull BindBlock bindBlock, @NotNull Decl.Personality personality) {
            super(sourcePos, entireSourcePos, accessibility, opInfo, bindBlock, telescope, result, personality);
            this.modifiers = modifiers;
            this.ref = DefVar.concrete(this, name);
            this.body = body;
        }

        @Override
        @NotNull
        public DefVar<FnDef, FnDecl> ref() {
            return this.ref;
        }
    }

    public static final class StructField
    extends CommonDecl
    implements Decl.Telescopic<Term> {
        @NotNull
        public final DefVar<FieldDef, StructField> ref;
        public DefVar<StructDef, StructDecl> structRef;
        @NotNull
        public Expr result;
        @NotNull
        public Option<Expr> body;
        public final boolean coerce;
        @NotNull
        public ImmutableSeq<Expr.Param> telescope;
        @Nullable
        public Def.Signature<Term> signature;

        public StructField(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Option<Expr> body, boolean coerce, @NotNull BindBlock bindBlock) {
            super(sourcePos, entireSourcePos, Stmt.Accessibility.Public, opInfo, bindBlock);
            this.coerce = coerce;
            this.result = result;
            this.body = body;
            this.ref = DefVar.concrete(this, name);
            this.telescope = telescope;
        }

        @NotNull
        public DefVar<FieldDef, StructField> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public ImmutableSeq<Expr.Param> telescope() {
            return this.telescope;
        }

        @Override
        public void modifyTelescope(@NotNull UnaryOperator<ImmutableSeq<Expr.Param>> f) {
            this.telescope = (ImmutableSeq)f.apply(this.telescope);
        }

        @Override
        public @Nullable Def.Signature<Term> signature() {
            return this.signature;
        }

        @Override
        @NotNull
        public Expr result() {
            return this.result;
        }

        @Override
        public void modifyResult(@NotNull UnaryOperator<Expr> f) {
            this.result = (Expr)f.apply(this.result);
        }
    }

    public static final class StructDecl
    extends TeleDecl<SortTerm> {
        @NotNull
        public final DefVar<StructDef, StructDecl> ref;
        @NotNull
        public final ImmutableSeq<StructField> fields;

        public StructDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull ImmutableSeq<StructField> fields, @NotNull BindBlock bindBlock, @NotNull Decl.Personality personality) {
            super(sourcePos, entireSourcePos, accessibility, opInfo, bindBlock, telescope, result, personality);
            this.fields = fields;
            this.ref = DefVar.concrete(this, name);
            fields.forEach(field -> {
                field.structRef = this.ref;
            });
        }

        @Override
        @NotNull
        public DefVar<StructDef, StructDecl> ref() {
            return this.ref;
        }
    }

    public static final class DataDecl
    extends TeleDecl<SortTerm> {
        @NotNull
        public final DefVar<DataDef, DataDecl> ref;
        @NotNull
        public final ImmutableSeq<DataCtor> body;
        @NotNull
        public final @NotNull MutableList<@NotNull CtorDef> checkedBody = MutableList.create();

        public DataDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull ImmutableSeq<DataCtor> body, @NotNull BindBlock bindBlock, @NotNull Decl.Personality personality) {
            super(sourcePos, entireSourcePos, accessibility, opInfo, bindBlock, telescope, result, personality);
            this.body = body;
            this.ref = DefVar.concrete(this, name);
            body.forEach(ctors -> {
                ctors.dataRef = this.ref;
            });
        }

        @Override
        @NotNull
        public DefVar<DataDef, DataDecl> ref() {
            return this.ref;
        }
    }

    public static final class DataCtor
    extends CommonDecl
    implements Decl.Telescopic<DataCall> {
        @NotNull
        public final DefVar<CtorDef, DataCtor> ref;
        public DefVar<DataDef, DataDecl> dataRef;
        @NotNull
        public Expr.PartEl clauses;
        @NotNull
        public ImmutableSeq<Arg<Pattern>> patterns;
        @Nullable
        public Expr result;
        public final boolean coerce;
        @NotNull
        public ImmutableSeq<Expr.Param> telescope;

        public DataCtor(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr.PartEl clauses, @NotNull ImmutableSeq<Arg<Pattern>> patterns, boolean coerce, @NotNull BindBlock bindBlock) {
            super(sourcePos, entireSourcePos, Stmt.Accessibility.Public, opInfo, bindBlock);
            this.clauses = clauses;
            this.coerce = coerce;
            this.patterns = patterns;
            this.ref = DefVar.concrete(this, name);
            this.telescope = telescope;
        }

        @Override
        @Nullable
        public Expr result() {
            return this.result;
        }

        @Override
        public void modifyResult(@NotNull UnaryOperator<Expr> f) {
            if (this.result != null) {
                this.result = (Expr)f.apply(this.result);
            }
        }

        @NotNull
        public DefVar<CtorDef, DataCtor> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public ImmutableSeq<Expr.Param> telescope() {
            return this.telescope;
        }

        @Override
        public void modifyTelescope(@NotNull UnaryOperator<ImmutableSeq<Expr.Param>> f) {
            this.telescope = (ImmutableSeq)f.apply(this.telescope);
        }

        @Override
        @Nullable
        public Def.Signature<DataCall> signature() {
            return null;
        }
    }

    public static final class PrimDecl
    extends TeleDecl<Term> {
        @NotNull
        public final DefVar<PrimDef, PrimDecl> ref;

        public PrimDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result) {
            super(sourcePos, entireSourcePos, Stmt.Accessibility.Public, null, BindBlock.EMPTY, telescope, result, Decl.Personality.NORMAL);
            this.ref = DefVar.concrete(this, name);
        }

        @Override
        public boolean needTyck(@NotNull ImmutableSeq<String> currentMod) {
            return this.ref.isInModule(currentMod) && this.signature == null;
        }

        @Override
        @NotNull
        public DefVar<PrimDef, PrimDecl> ref() {
            return this.ref;
        }
    }
}

