/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Result;
import org.aya.core.pat.Pat;
import org.aya.core.term.ConCall;
import org.aya.core.term.IntegerTerm;
import org.aya.core.term.ListTerm;
import org.aya.core.term.MetaPatTerm;
import org.aya.core.term.Term;
import org.aya.core.term.TupTerm;
import org.aya.core.visitor.PatTraversal;
import org.aya.core.visitor.Subst;
import org.aya.generic.util.InternalException;
import org.aya.ref.AnyVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

public record PatMatcher(@NotNull Subst subst, boolean inferMeta, @NotNull @NotNull UnaryOperator<@NotNull Term> pre) {
    public static Result<Subst, Boolean> tryBuildSubst(boolean inferMeta, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Pat>> pats, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> terms) {
        return PatMatcher.tryBuildSubst(inferMeta, pats, terms, UnaryOperator.identity());
    }

    public static Result<Subst, Boolean> tryBuildSubst(boolean inferMeta, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Pat>> pats, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> terms, @NotNull UnaryOperator<Term> pre) {
        PatMatcher matchy = new PatMatcher(new Subst((MutableMap<AnyVar, Term>)new MutableHashMap()), inferMeta, pre);
        try {
            pats.forEachWithChecked(terms, matchy::match);
            return Result.ok((Object)matchy.subst());
        }
        catch (Mismatch mismatch) {
            return Result.err((Object)mismatch.isBlocked);
        }
    }

    private void match(@NotNull Arg<Pat> pat, @NotNull Arg<Term> term) throws Mismatch {
        assert (pat.explicit() == term.explicit());
        this.match((Pat)pat.term(), (Term)term.term());
    }

    private void match(@NotNull Pat pat, @NotNull Term term) throws Mismatch {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Bind.class, Pat.Absurd.class, Pat.Ctor.class, Pat.Tuple.class, Pat.Meta.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Pat.Bind bind = (Pat.Bind)pat3;
                this.subst.addDirectly(bind.bind(), term);
                break;
            }
            case 1: {
                Pat.Absurd ignored = (Pat.Absurd)pat3;
                throw new InternalException("unreachable");
            }
            case 2: {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                Term term2 = term = (Term)this.pre.apply(term);
                Objects.requireNonNull(term2);
                Term term3 = term2;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConCall.class, MetaPatTerm.class, IntegerTerm.class, ListTerm.class}, (Object)term3, n2)) {
                    case 0: {
                        ConCall conCall = (ConCall)term3;
                        if (ctor.ref() != conCall.ref()) {
                            throw new Mismatch(false);
                        }
                        this.visitList(ctor.params(), conCall.conArgs());
                        break block0;
                    }
                    case 1: {
                        MetaPatTerm metaPat = (MetaPatTerm)term3;
                        this.solve(pat, metaPat);
                        break block0;
                    }
                    case 2: {
                        IntegerTerm litTerm = (IntegerTerm)term3;
                        this.match(ctor, (Term)litTerm.constructorForm());
                        break block0;
                    }
                    case 3: {
                        ListTerm litTerm = (ListTerm)term3;
                        this.match(ctor, (Term)litTerm.constructorForm());
                        break block0;
                    }
                }
                throw new Mismatch(true);
            }
            case 3: {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                Term term4 = term = (Term)this.pre.apply(term);
                Objects.requireNonNull(term4);
                Term term5 = term4;
                int conCall = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TupTerm.class, MetaPatTerm.class}, (Object)term5, conCall)) {
                    case 0: {
                        TupTerm tup = (TupTerm)term5;
                        this.visitList(tuple.pats(), tup.items());
                        break block0;
                    }
                    case 1: {
                        MetaPatTerm metaPat = (MetaPatTerm)term5;
                        this.solve(pat, metaPat);
                        break block0;
                    }
                }
                throw new Mismatch(true);
            }
            case 4: {
                Pat.Meta ignored = (Pat.Meta)pat3;
                throw new InternalException("Pat.Meta is not allowed");
            }
            case 5: {
                Pat.ShapedInt lit = (Pat.ShapedInt)pat3;
                Term term6 = term = (Term)this.pre.apply(term);
                Objects.requireNonNull(term6);
                Term term7 = term6;
                int n3 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntegerTerm.class, ConCall.class}, (Object)term7, n3)) {
                    case 0: {
                        IntegerTerm litTerm = (IntegerTerm)term7;
                        if (lit.compareUntyped(litTerm)) break block0;
                        throw new Mismatch(false);
                    }
                    case 1: {
                        ConCall con = (ConCall)term7;
                        this.match((Pat)lit.constructorForm(), con);
                        break block0;
                    }
                    default: {
                        this.match((Pat)lit.constructorForm(), term);
                    }
                }
            }
        }
    }

    private void solve(@NotNull Pat pat, @NotNull MetaPatTerm metaPat) throws Mismatch {
        Pat.Meta referee = metaPat.ref();
        Pat todo = (Pat)referee.solution().get();
        if (todo == null) {
            if (!this.inferMeta) {
                throw new Mismatch(true);
            }
            PatTraversal.MetaBind bindSubst = new PatTraversal.MetaBind(this.subst, metaPat.ref().fakeBind().definition());
            Pat metalized = bindSubst.apply(pat);
            metaPat.ref().solution().set((Object)metalized);
        } else {
            this.match(pat, todo.toTerm());
        }
    }

    private void visitList(@NotNull ImmutableSeq<Arg<Pat>> lpats, @NotNull ImmutableSeq<Arg<Term>> terms) throws Mismatch {
        assert (lpats.sizeEquals(terms));
        lpats.forEachWithChecked(terms, this::match);
    }

    private static final class Mismatch
    extends Exception {
        public final boolean isBlocked;

        private Mismatch(boolean isBlocked) {
            this.isBlocked = isBlocked;
        }
    }
}

