/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import java.io.Serializable;
import kala.collection.immutable.ImmutableSeq;
import org.aya.generic.SortKind;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeShape {

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ParamShape {
        @NotNull
        public static ParamShape explicit(@NotNull TermShape type) {
            return new Licit(type, Licit.Kind.Ex);
        }

        @NotNull
        public static ParamShape implicit(@NotNull TermShape type) {
            return new Licit(type, Licit.Kind.Im);
        }

        @NotNull
        public static ParamShape anyLicit(@NotNull TermShape type) {
            return new Licit(type, Licit.Kind.Any);
        }

        @NotNull
        public static ParamShape anyEx() {
            return ParamShape.explicit(new TermShape.Any());
        }

        @NotNull
        public static ParamShape anyIm() {
            return ParamShape.implicit(new TermShape.Any());
        }

        public record Licit(@NotNull TermShape type, Kind kind) implements ParamShape
        {

            static enum Kind {
                Any,
                Ex,
                Im;

            }
        }

        public record Optional(@NotNull ParamShape param) implements ParamShape
        {
        }

        public record Any() implements ParamShape
        {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PatShape {

        public record Any() implements PatShape
        {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TermShape {

        public record Sort(@Nullable SortKind kind, int ulift) implements TermShape
        {
        }

        public record TeleRef(int superLevel, int nth) implements TermShape
        {
        }

        public record Call(int superLevel, @NotNull ImmutableSeq<TermShape> args) implements TermShape
        {
            @Contract(value="_ -> new")
            @NotNull
            public static Call justCall(int superLevel) {
                return new Call(superLevel, (ImmutableSeq<TermShape>)ImmutableSeq.empty());
            }
        }

        public record Any() implements TermShape
        {
        }
    }

    public record FieldShape(@NotNull ImmutableSeq<ParamShape> tele) implements CodeShape
    {
    }

    public record CtorShape(@NotNull MomentId name, @NotNull ImmutableSeq<ParamShape> tele) implements CodeShape,
    Moment
    {
    }

    public record StructShape(@NotNull ImmutableSeq<ParamShape> tele, @NotNull ImmutableSeq<FieldShape> fields) implements CodeShape
    {
    }

    public record DataShape(@NotNull ImmutableSeq<ParamShape> tele, @NotNull ImmutableSeq<CtorShape> ctors) implements CodeShape
    {
    }

    public record FnShape(@NotNull ImmutableSeq<ParamShape> tele) implements CodeShape
    {
    }

    public static enum MomentId implements Serializable
    {
        ZERO,
        SUC,
        NIL,
        CONS;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Moment {
        @NotNull
        public MomentId name();
    }
}

