/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import org.aya.concrete.stmt.Decl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.GenericDef;
import org.aya.core.repr.AyaShape;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.Callable;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.jetbrains.annotations.NotNull;

public record ShapeMatcher(@NotNull MutableLinkedList<DefVar<? extends Def, ? extends Decl.Telescopic<?>>> def, @NotNull MutableMap<CodeShape.MomentId, DefVar<?, ?>> captures, @NotNull MutableMap<AnyVar, AnyVar> teleSubst) {
    public ShapeMatcher() {
        this(MutableLinkedList.create(), MutableMap.create(), (MutableMap<AnyVar, AnyVar>)MutableMap.create());
    }

    public static Option<ShapeRecognition> match(@NotNull AyaShape shape, @NotNull GenericDef def) {
        ShapeMatcher matcher = new ShapeMatcher();
        CodeShape codeShape = shape.codeShape();
        if (codeShape instanceof CodeShape.DataShape) {
            CodeShape.DataShape dataShape = (CodeShape.DataShape)codeShape;
            if (def instanceof DataDef) {
                DataDef data = (DataDef)def;
                return matcher.matchData(dataShape, data) ? Option.some((Object)new ShapeRecognition(shape, matcher.captures.toImmutableMap())) : Option.none();
            }
        }
        return Option.none();
    }

    private boolean matchData(@NotNull CodeShape.DataShape shape, @NotNull DataDef data) {
        return this.matchTele(shape.tele(), (ImmutableSeq<Term.Param>)data.telescope) && this.matchInside(data.ref, () -> ShapeMatcher.matchMany(false, shape.ctors(), data.body, (s, c) -> this.captured((CodeShape.Moment)s, (Object)c, this::matchCtor, CtorDef::ref)));
    }

    private boolean matchCtor(@NotNull CodeShape.CtorShape shape, @NotNull CtorDef ctor) {
        if (ctor.pats.isNotEmpty()) {
            ((DataDef)ctor.dataRef.core).telescope.forEachWith((Iterable)ctor.ownerTele, (t1, t2) -> this.teleSubst.put((Object)t1.ref(), (Object)t2.ref()));
        }
        return this.matchTele(shape.tele(), (ImmutableSeq<Term.Param>)ctor.selfTele);
    }

    private boolean matchTerm(@NotNull CodeShape.TermShape shape, @NotNull Term term) {
        if (shape instanceof CodeShape.TermShape.Any) {
            return true;
        }
        if (shape instanceof CodeShape.TermShape.Call) {
            CodeShape.TermShape.Call call = (CodeShape.TermShape.Call)shape;
            if (term instanceof Callable) {
                Callable callable = (Callable)term;
                DefVar superLevel = (DefVar)this.def.getOrNull(call.superLevel());
                if (superLevel != callable.ref()) {
                    return false;
                }
                return ShapeMatcher.matchMany(true, call.args(), callable.args(), (l, r) -> this.matchTerm((CodeShape.TermShape)l, (Term)r.term()));
            }
        }
        if (shape instanceof CodeShape.TermShape.TeleRef) {
            CodeShape.TermShape.TeleRef ref = (CodeShape.TermShape.TeleRef)shape;
            if (term instanceof RefTerm) {
                RefTerm refTerm = (RefTerm)term;
                DefVar superLevel = (DefVar)this.def.getOrNull(ref.superLevel());
                if (superLevel == null) {
                    return false;
                }
                Term.Param tele = (Term.Param)Def.defTele(superLevel).getOrNull(ref.nth());
                if (tele == null) {
                    return false;
                }
                AnyVar teleVar = (AnyVar)this.teleSubst.getOrNull((Object)tele.ref());
                return teleVar == refTerm.var() || tele.ref() == refTerm.var();
            }
        }
        if (shape instanceof CodeShape.TermShape.Sort) {
            CodeShape.TermShape.Sort sort = (CodeShape.TermShape.Sort)shape;
            if (term instanceof SortTerm) {
                SortTerm sortTerm = (SortTerm)term;
                if (sort.kind() == null) {
                    return true;
                }
                throw new UnsupportedOperationException("TODO");
            }
        }
        return false;
    }

    private boolean matchTele(@NotNull ImmutableSeq<CodeShape.ParamShape> shape, @NotNull ImmutableSeq<Term.Param> tele) {
        SeqView shapes = shape.view();
        SeqView params = tele.view();
        while (shapes.isNotEmpty() && params.isNotEmpty()) {
            Term.Param c;
            CodeShape.ParamShape s = (CodeShape.ParamShape)shapes.first();
            if (!this.matchParam(s, c = (Term.Param)params.first())) {
                return false;
            }
            shapes = shapes.drop(1);
            params = params.drop(1);
        }
        if (shapes.isNotEmpty()) {
            shapes = shapes.filterNot(CodeShape.ParamShape.Optional.class::isInstance);
        }
        return shapes.sizeEquals((Iterable)params);
    }

    private boolean matchParam(@NotNull CodeShape.ParamShape shape, @NotNull Term.Param param) {
        if (shape instanceof CodeShape.ParamShape.Any) {
            return true;
        }
        if (shape instanceof CodeShape.ParamShape.Optional) {
            CodeShape.ParamShape.Optional opt = (CodeShape.ParamShape.Optional)shape;
            return this.matchParam(opt.param(), param);
        }
        if (shape instanceof CodeShape.ParamShape.Licit) {
            CodeShape.ParamShape.Licit licit = (CodeShape.ParamShape.Licit)shape;
            if (!this.matchLicit(licit.kind(), param.explicit())) {
                return false;
            }
            return this.matchTerm(licit.type(), param.type());
        }
        return false;
    }

    private boolean matchLicit(@NotNull CodeShape.ParamShape.Licit.Kind xlicit, boolean isExplicit) {
        return xlicit == CodeShape.ParamShape.Licit.Kind.Any || xlicit == CodeShape.ParamShape.Licit.Kind.Ex == isExplicit;
    }

    private boolean matchInside(@NotNull DefVar<? extends Def, ? extends Decl.Telescopic<?>> defVar, @NotNull BooleanSupplier matcher) {
        this.def.push(defVar);
        boolean result = matcher.getAsBoolean();
        this.def.pop();
        return result;
    }

    private static <S, C> boolean matchMany(boolean ordered, @NotNull SeqLike<S> shapes, @NotNull SeqLike<C> cores, @NotNull BiFunction<S, C, Boolean> matcher) {
        if (!shapes.sizeEquals(cores)) {
            return false;
        }
        if (ordered) {
            return shapes.allMatchWith(cores, matcher::apply);
        }
        MutableLinkedList remainingShapes = MutableLinkedList.from(shapes);
        for (Object core : cores) {
            int index = remainingShapes.indexWhere(shape -> (Boolean)matcher.apply(shape, core));
            if (index == -1) {
                return false;
            }
            remainingShapes.removeAt(index);
        }
        return true;
    }

    private <S extends CodeShape.Moment, C> boolean captured(@NotNull S shape, @NotNull C core, @NotNull BiFunction<S, C, Boolean> matcher, @NotNull Function<C, DefVar<?, ?>> extract) {
        Boolean matched = matcher.apply(shape, core);
        if (matched.booleanValue()) {
            this.captures.put((Object)shape.name(), extract.apply(core));
        }
        return matched;
    }
}

