/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple;
import kala.tuple.Tuple3;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.UseHide;
import org.aya.core.def.DataDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.StructDef;
import org.aya.core.repr.AyaShape;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerTerm;
import org.aya.core.serde.Serializer;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record CompiledAya(@NotNull ImmutableSeq<ImmutableSeq<String>> imports, @NotNull ImmutableSeq<SerDef.QName> exports, @NotNull ImmutableMap<ImmutableSeq<String>, SerUseHide> reExports, @NotNull ImmutableSeq<SerDef> serDefs, @NotNull ImmutableSeq<SerDef.SerOp> serOps, @NotNull ImmutableMap<SerDef.QName, SerDef.SerRenamedOp> opRename) implements Serializable
{
    @NotNull
    public static CompiledAya from(@NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<GenericDef> defs, @NotNull Serializer.State state) {
        ModuleContext moduleContext = resolveInfo.thisModule();
        if (!(moduleContext instanceof PhysicalModuleContext)) {
            throw new UnsupportedOperationException();
        }
        PhysicalModuleContext ctx = (PhysicalModuleContext)moduleContext;
        Serialization serialization = new Serialization(state, resolveInfo, (MutableList<SerDef>)MutableList.create(), (MutableList<SerDef.SerOp>)MutableList.create());
        serialization.ser(defs);
        ImmutableSeq<String> modName = ctx.moduleName();
        ImmutableSeq exports = ctx.exports.view().map((k, vs) -> {
            ImmutableSeq qnameMod = modName.appendedAll((Iterable)k);
            return vs.view().map((n, v) -> new SerDef.QName((ImmutableSeq<String>)qnameMod, (String)n));
        }).flatMap(Function.identity()).toImmutableSeq();
        ImmutableSeq imports = resolveInfo.imports().valuesView().map(i -> i.thisModule().moduleName()).toImmutableSeq();
        return new CompiledAya((ImmutableSeq<ImmutableSeq<String>>)imports, (ImmutableSeq<SerDef.QName>)exports, (ImmutableMap<ImmutableSeq<String>, SerUseHide>)resolveInfo.reExports().view().map((k, v) -> Tuple.of((Object)k, (Object)SerUseHide.from(v))).toImmutableMap(), (ImmutableSeq<SerDef>)serialization.serDefs.toImmutableSeq(), (ImmutableSeq<SerDef.SerOp>)serialization.serOps.toImmutableSeq(), (ImmutableMap<SerDef.QName, SerDef.SerRenamedOp>)resolveInfo.opRename().view().map((k, v) -> {
            SerDef.QName name = state.def((DefVar<?, ?>)k);
            OpDecl.OpInfo info = ((ResolveInfo.RenamedOpDecl)v._1).opInfo();
            SerDef.SerRenamedOp renamed = new SerDef.SerRenamedOp(info.name(), info.assoc(), serialization.serBind((BindBlock)v._2));
            return Tuple.of((Object)((Boolean)v._3), (Object)name, (Object)renamed);
        }).filter(Tuple3::head).map(Tuple3::tail).toImmutableMap());
    }

    private static SerDef.QName nameOf(@NotNull SerDef def) {
        SerDef serDef = def;
        Objects.requireNonNull(serDef);
        SerDef serDef2 = serDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Fn.class, SerDef.Struct.class, SerDef.Field.class, SerDef.Data.class, SerDef.Ctor.class, SerDef.Prim.class}, (Object)serDef2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                SerDef.Fn fn = (SerDef.Fn)serDef2;
                yield fn.name();
            }
            case 1 -> {
                SerDef.Struct struct = (SerDef.Struct)serDef2;
                yield struct.name();
            }
            case 2 -> {
                SerDef.Field field = (SerDef.Field)serDef2;
                yield field.self();
            }
            case 3 -> {
                SerDef.Data data = (SerDef.Data)serDef2;
                yield data.name();
            }
            case 4 -> {
                SerDef.Ctor ctor = (SerDef.Ctor)serDef2;
                yield ctor.self();
            }
            case 5 -> {
                SerDef.Prim prim = (SerDef.Prim)serDef2;
                yield new SerDef.QName((ImmutableSeq<String>)ImmutableSeq.empty(), prim.name().name());
            }
        };
    }

    @NotNull
    public ResolveInfo toResolveInfo(@NotNull ModuleLoader loader, @NotNull PhysicalModuleContext context, @NotNull SerTerm.DeState state) {
        ResolveInfo resolveInfo = new ResolveInfo(state.primFactory(), context, (ImmutableSeq<Stmt>)ImmutableSeq.empty());
        this.shallowResolve(loader, resolveInfo);
        this.serDefs.forEach(serDef -> this.de(resolveInfo.shapeFactory(), context, (SerDef)serDef, state));
        this.deOp(state, resolveInfo);
        return resolveInfo;
    }

    private void shallowResolve(@NotNull ModuleLoader loader, @NotNull ResolveInfo thisResolve) {
        for (ImmutableSeq modName : this.imports) {
            ResolveInfo success = loader.load((ImmutableSeq<String>)modName);
            if (success == null) {
                thisResolve.thisModule().reportAndThrow(new NameProblem.ModNotFoundError((Seq<String>)modName, SourcePos.SER));
            }
            thisResolve.imports().put(success.thisModule().moduleName(), (Object)success);
            PhysicalModuleContext mod = (PhysicalModuleContext)success.thisModule();
            thisResolve.thisModule().importModules((ImmutableSeq<String>)modName, Stmt.Accessibility.Private, mod.exports, SourcePos.SER);
            this.reExports.getOption((Object)modName).forEach(useHide -> thisResolve.thisModule().openModule((ImmutableSeq<String>)modName, Stmt.Accessibility.Public, useHide::uses, (Map<String, String>)useHide.renames(), SourcePos.SER));
            Stmt.Accessibility acc = this.reExports.containsKey((Object)modName) ? Stmt.Accessibility.Public : Stmt.Accessibility.Private;
            thisResolve.open(success, SourcePos.SER, acc);
        }
    }

    private void deOp(@NotNull SerTerm.DeState state, @NotNull ResolveInfo resolveInfo) {
        this.serOps.forEach(serOp -> {
            Object defVar = state.resolve(serOp.name());
            OpDecl.OpInfo opInfo = new OpDecl.OpInfo(serOp.name().name(), serOp.assoc());
            ((DefVar)defVar).opDecl = new SerDef.SerOpDecl(opInfo);
        });
        this.opRename.view().forEach((name, serOp) -> {
            Object defVar = state.resolve((SerDef.QName)name);
            String asName = serOp.name();
            Assoc asAssoc = serOp.assoc();
            ResolveInfo.RenamedOpDecl opDecl = new ResolveInfo.RenamedOpDecl(new OpDecl.OpInfo(asName, asAssoc));
            resolveInfo.renameOp((DefVar<?, ?>)defVar, opDecl, BindBlock.EMPTY, true);
        });
        this.serOps.view().forEach(serOp -> {
            Object defVar = state.resolve(serOp.name());
            OpDecl opDecl = ((DefVar)defVar).opDecl;
            assert (opDecl != null);
            this.deBindDontCare(resolveInfo, state, opDecl, serOp.bind());
        });
        this.opRename.view().forEach((name, serOp) -> {
            Object defVar = state.resolve((SerDef.QName)name);
            SerDef.SerBind asBind = serOp.bind();
            ResolveInfo.RenamedOpDecl opDecl = (ResolveInfo.RenamedOpDecl)((Tuple3)resolveInfo.opRename().get(defVar))._1;
            this.deBindDontCare(resolveInfo, state, opDecl, asBind);
        });
    }

    private void deBindDontCare(@NotNull ResolveInfo resolveInfo, @NotNull SerTerm.DeState state, @NotNull OpDecl opDecl, @NotNull SerDef.SerBind bind) {
        AyaBinOpSet opSet = resolveInfo.opSet();
        opSet.ensureHasElem(opDecl);
        bind.loosers().forEach(looser -> {
            OpDecl target = this.resolveOp(resolveInfo, state, (SerDef.QName)looser);
            opSet.bind(opDecl, OpDecl.BindPred.Looser, target, SourcePos.SER);
        });
        bind.tighters().forEach(tighter -> {
            OpDecl target = this.resolveOp(resolveInfo, state, (SerDef.QName)tighter);
            opSet.bind(opDecl, OpDecl.BindPred.Tighter, target, SourcePos.SER);
        });
    }

    @NotNull
    private OpDecl resolveOp(@NotNull ResolveInfo resolveInfo, @NotNull SerTerm.DeState state, @NotNull SerDef.QName name) {
        OpDecl opDecl;
        Object original = state.resolve(name);
        Tuple3 renamed = (Tuple3)resolveInfo.opRename().getOrNull(original);
        OpDecl opDecl2 = opDecl = renamed != null ? (OpDecl)renamed._1 : ((DefVar)original).opDecl;
        if (opDecl != null) {
            return opDecl;
        }
        resolveInfo.opSet().reporter.report((Problem)new NameProblem.OperatorNameNotFound(SourcePos.SER, name.toString()));
        throw new Context.ResolvingInterruptedException();
    }

    private void de(@NotNull AyaShape.Factory shapeFactory, @NotNull PhysicalModuleContext context, @NotNull SerDef serDef, @NotNull SerTerm.DeState state) {
        ImmutableSeq<String> mod = context.moduleName();
        int drop = mod.size();
        GenericDef def = serDef.de(state);
        assert (def.ref().core != null);
        shapeFactory.bonjour(def);
        SerDef serDef2 = serDef;
        Objects.requireNonNull(serDef2);
        SerDef serDef3 = serDef2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Fn.class, SerDef.Data.class, SerDef.Struct.class, SerDef.Prim.class}, (Object)serDef3, n)) {
            case 0: {
                SerDef.Fn fn = (SerDef.Fn)serDef3;
                if (!this.isExported(fn.name())) break;
                this.export(context, drop, fn.name(), def.ref());
                this.export(context, fn.name().name(), def.ref());
                break;
            }
            case 1: {
                SerDef.Data data = (SerDef.Data)serDef3;
                PhysicalModuleContext innerCtx = context.derive(data.name().name());
                if (this.isExported(data.name())) {
                    this.export(context, data.name().name(), def.ref());
                }
                data.bodies().forEachWith(((DataDef)def).body, (ctor, ctorDef) -> {
                    if (this.isExported(ctor.self())) {
                        this.export(context, drop, ctor.self(), ctorDef.ref);
                    }
                    this.export(innerCtx, ctor.self().name(), ctorDef.ref);
                });
                context.importModules((ImmutableSeq<String>)innerCtx.moduleName().drop(drop), Stmt.Accessibility.Public, innerCtx.exports, SourcePos.SER);
                break;
            }
            case 2: {
                SerDef.Struct struct = (SerDef.Struct)serDef3;
                PhysicalModuleContext innerCtx = context.derive(struct.name().name());
                if (this.isExported(struct.name())) {
                    this.export(context, struct.name().name(), def.ref());
                }
                struct.fields().forEachWith(((StructDef)def).fields, (field, fieldDef) -> {
                    if (this.isExported(field.self())) {
                        this.export(context, drop, field.self(), fieldDef.ref);
                    }
                    this.export(innerCtx, field.self().name(), fieldDef.ref);
                });
                context.importModules((ImmutableSeq<String>)innerCtx.moduleName().drop(drop), Stmt.Accessibility.Public, innerCtx.exports, SourcePos.SER);
                break;
            }
            case 3: {
                SerDef.Prim prim = (SerDef.Prim)serDef3;
                this.export(context, prim.name().id, def.ref());
                break;
            }
        }
    }

    private void export(@NotNull PhysicalModuleContext context, int dropMod, @NotNull SerDef.QName qname, DefVar<?, ?> ref) {
        this.export(context, (ImmutableSeq<String>)qname.mod().drop(dropMod), qname.name(), ref);
    }

    private void export(@NotNull PhysicalModuleContext context, @NotNull String name, @NotNull AnyVar var) {
        this.export(context, (ImmutableSeq<String>)ImmutableSeq.empty(), name, var);
    }

    private void export(@NotNull PhysicalModuleContext context, @NotNull ImmutableSeq<String> mod, @NotNull String name, @NotNull AnyVar var) {
        ((MutableMap)context.exports.getOrPut((Object)ImmutableSeq.empty(), MutableMap::create)).put((Object)name, (Object)var);
        ((MutableMap)context.exports.getOrPut(mod, MutableMap::create)).put((Object)name, (Object)var);
    }

    private boolean isExported(@NotNull SerDef.QName qname) {
        return this.exports.contains((Object)qname);
    }

    private record Serialization(@NotNull Serializer.State state, @NotNull ResolveInfo resolveInfo, @NotNull MutableList<SerDef> serDefs, @NotNull MutableList<SerDef.SerOp> serOps) {
        private void ser(@NotNull ImmutableSeq<GenericDef> defs) {
            defs.forEach(this::serDef);
        }

        private void serDef(@NotNull GenericDef def) {
            SerDef serDef = new Serializer(this.state).serialize(def);
            this.serDefs.append((Object)serDef);
            this.serOp(serDef, def);
            SerDef serDef2 = serDef;
            Objects.requireNonNull(serDef2);
            SerDef serDef3 = serDef2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Data.class, SerDef.Struct.class}, (Object)serDef3, n)) {
                case 0: {
                    SerDef.Data data = (SerDef.Data)serDef3;
                    data.bodies().forEachWith(((DataDef)def).body, this::serOp);
                    break;
                }
                case 1: {
                    SerDef.Struct struct = (SerDef.Struct)serDef3;
                    struct.fields().forEachWith(((StructDef)def).fields, this::serOp);
                    break;
                }
            }
        }

        private void serOp(@NotNull SerDef serDef, @NotNull GenericDef def) {
            Object concrete = def.ref().concrete;
            OpDecl.OpInfo opInfo = concrete.opInfo();
            if (opInfo != null) {
                this.serOps.append((Object)new SerDef.SerOp(CompiledAya.nameOf(serDef), opInfo.assoc(), this.serBind(concrete.bindBlock())));
            }
        }

        @NotNull
        private SerDef.SerBind serBind(@NotNull BindBlock bindBlock) {
            if (bindBlock == BindBlock.EMPTY) {
                return SerDef.SerBind.EMPTY;
            }
            ImmutableSeq loosers = ((ImmutableSeq)bindBlock.resolvedLoosers().get()).map(this.state::def);
            ImmutableSeq tighters = ((ImmutableSeq)bindBlock.resolvedTighters().get()).map(this.state::def);
            return new SerDef.SerBind((ImmutableSeq<SerDef.QName>)loosers, (ImmutableSeq<SerDef.QName>)tighters);
        }
    }

    record SerUseHide(boolean isUsing, @NotNull ImmutableSeq<String> names, @NotNull ImmutableMap<String, String> renames) implements Serializable
    {
        @NotNull
        public static SerUseHide from(@NotNull UseHide useHide) {
            return new SerUseHide(useHide.strategy() == UseHide.Strategy.Using, (ImmutableSeq<String>)useHide.list().map(UseHide.Name::id), (ImmutableMap<String, String>)ImmutableMap.from(useHide.renaming()));
        }

        public boolean uses(@NotNull String name) {
            return this.isUsing == this.names.contains((Object)name);
        }
    }
}

