/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerPat;
import org.aya.core.term.AppTerm;
import org.aya.core.term.CoeTerm;
import org.aya.core.term.ConCall;
import org.aya.core.term.DataCall;
import org.aya.core.term.FieldTerm;
import org.aya.core.term.FnCall;
import org.aya.core.term.FormulaTerm;
import org.aya.core.term.InOutTerm;
import org.aya.core.term.IntegerTerm;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.LamTerm;
import org.aya.core.term.ListTerm;
import org.aya.core.term.MatchTerm;
import org.aya.core.term.NewTerm;
import org.aya.core.term.PAppTerm;
import org.aya.core.term.PLamTerm;
import org.aya.core.term.PartialTerm;
import org.aya.core.term.PartialTyTerm;
import org.aya.core.term.PathTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.PrimCall;
import org.aya.core.term.ProjTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SigmaTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.StringTerm;
import org.aya.core.term.StructCall;
import org.aya.core.term.Term;
import org.aya.core.term.TupTerm;
import org.aya.generic.SortKind;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SerTerm
extends Serializable,
Restr.TermLike<SerTerm> {
    @NotNull
    public Term de(@NotNull DeState var1);

    public record InOut(@NotNull SerTerm phi, @NotNull SerTerm u, boolean isIntro) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new InOutTerm(this.phi.de(state), this.u.de(state), this.isIntro ? InOutTerm.Kind.In : InOutTerm.Kind.Out);
        }
    }

    public record Coe(@NotNull SerTerm type, @NotNull Restr<SerTerm> restr) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CoeTerm(this.type.de(state), (Restr<Term>)this.restr.fmap(t -> t.de(state)));
        }
    }

    public record PathApp(@NotNull SerTerm of, @NotNull ImmutableSeq<SerArg> args, @NotNull Path cube) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PAppTerm(this.of.de(state), (ImmutableSeq<Arg<Term>>)this.args.map(arg -> arg.de(state)), this.cube.de(state));
        }
    }

    public record PathLam(@NotNull ImmutableSeq<SimpVar> params, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PLamTerm((ImmutableSeq<LocalVar>)this.params.map(p -> p.de(state)), this.body.de(state));
        }
    }

    public record Path(@NotNull ImmutableSeq<SimpVar> params, @NotNull SerTerm type, @NotNull Partial<SerTerm> partial) implements SerTerm
    {
        @Override
        @NotNull
        public PathTerm de(@NotNull DeState state) {
            return new PathTerm((ImmutableSeq<LocalVar>)this.params.map(p -> p.de(state)), this.type.de(state), PartEl.de(state, this.partial));
        }
    }

    public record PartTy(@NotNull SerTerm type, @NotNull Restr<SerTerm> restr) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PartialTyTerm(this.type.de(state), (Restr<Term>)this.restr.fmap(t -> t.de(state)));
        }
    }

    public record PartEl(@NotNull Partial<SerTerm> partial, @NotNull SerTerm rhsType) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PartialTerm(PartEl.de(state, this.partial), this.rhsType.de(state));
        }

        @NotNull
        static Partial<Term> de(@NotNull DeState state, @NotNull Partial<SerTerm> par) {
            return par.fmap(t -> t.de(state));
        }
    }

    public record Str(@NotNull String string) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new StringTerm(this.string);
        }
    }

    public record ShapedList(@NotNull ImmutableSeq<SerTerm> repr, @NotNull SerDef.SerShapeResult shape, @NotNull Data type) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            ImmutableSeq termDesered = this.repr.map(x -> x.de(state));
            ShapeRecognition shape = this.shape().de(state);
            DataCall type = this.type().de(state);
            return new ListTerm((ImmutableSeq<Term>)termDesered, shape, type);
        }
    }

    public record ShapedInt(int integer, @NotNull SerDef.SerShapeResult shape, @NotNull Data type) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntegerTerm(this.integer, this.shape.de(state), this.type.de(state));
        }
    }

    public record Mula(@NotNull Formula<SerTerm> formula) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormulaTerm((Formula<Term>)this.formula.fmap(t -> t.de(state)));
        }
    }

    public record Interval() implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return IntervalTerm.INSTANCE;
        }
    }

    public record FieldRef(@NotNull SerDef.QName name) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm.Field((DefVar<FieldDef, TeleDecl.StructField>)state.resolve(this.name));
        }
    }

    public record Access(@NotNull SerTerm of, @NotNull SerDef.QName ref, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> structArgs, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> fieldArgs) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FieldTerm(this.of.de(state), (DefVar<FieldDef, TeleDecl.StructField>)state.resolve(this.ref), (ImmutableSeq<Arg<Term>>)this.structArgs.map(arg -> arg.de(state)), (ImmutableSeq<Arg<Term>>)this.fieldArgs.map(arg -> arg.de(state)));
        }
    }

    public record Tup(@NotNull ImmutableSeq<SerArg> components) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new TupTerm((ImmutableSeq<Arg<Term>>)this.components.map(t -> t.de(state)));
        }
    }

    public record Con(@NotNull SerDef.QName dataRef, @NotNull SerDef.QName selfRef, @NotNull CallData dataArgs, @NotNull ImmutableSeq<SerArg> conArgs) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ConCall((DefVar<DataDef, TeleDecl.DataDecl>)state.resolve(this.dataRef), (DefVar<CtorDef, TeleDecl.DataCtor>)state.resolve(this.selfRef), this.dataArgs.de(state), this.dataArgs.ulift, (ImmutableSeq<Arg<Term>>)this.conArgs.map(arg -> arg.de(state)));
        }
    }

    public record Prim(@NotNull SerDef.QName name, @NotNull PrimDef.ID id, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PrimCall((DefVar<PrimDef, TeleDecl.PrimDecl>)state.resolve(this.name), this.id, this.data.ulift, this.data.de(state));
        }
    }

    public record Data(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public DataCall de(@NotNull DeState state) {
            return new DataCall((DefVar<DataDef, TeleDecl.DataDecl>)state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record Fn(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public FnCall de(@NotNull DeState state) {
            return new FnCall((DefVar<FnDef, TeleDecl.FnDecl>)state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record Struct(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public StructCall de(@NotNull DeState state) {
            return new StructCall((DefVar<StructDef, TeleDecl.StructDecl>)state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record CallData(int ulift, @NotNull ImmutableSeq<SerArg> args) implements Serializable
    {
        @NotNull
        public ImmutableSeq<Arg<Term>> de(@NotNull DeState state) {
            return this.args.map(arg -> arg.de(state));
        }
    }

    public record App(@NotNull SerTerm of, @NotNull SerArg arg) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new AppTerm(this.of.de(state), this.arg.de(state));
        }
    }

    public record SerArg(@NotNull SerTerm arg, boolean explicit) implements Serializable
    {
        @NotNull
        public Arg<Term> de(@NotNull DeState state) {
            return new Arg((Object)this.arg.de(state), this.explicit);
        }
    }

    public record Match(@NotNull ImmutableSeq<SerTerm> of, ImmutableSeq<SerPat.Clause> clauses) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new MatchTerm((ImmutableSeq<Term>)this.of.map(t -> t.de(state)), (ImmutableSeq<Term.Matching>)this.clauses.map(c -> c.de(state)));
        }
    }

    public record Proj(@NotNull SerTerm of, int ix) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ProjTerm(this.of.de(state), this.ix);
        }
    }

    public record New(@NotNull Struct call, @NotNull ImmutableMap<SerDef.QName, SerTerm> map) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new NewTerm(this.call.de(state), (ImmutableMap<DefVar<FieldDef, TeleDecl.StructField>, Term>)ImmutableMap.from((Iterable)this.map.view().map((k, v) -> Tuple.of(state.resolve((SerDef.QName)k), (Object)v.de(state)))));
        }
    }

    public record Lam(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new LamTerm(this.param.de(state), this.body.de(state));
        }
    }

    public record Ref(@NotNull SimpVar var) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm(this.var.de(state));
        }
    }

    public record Sort(@NotNull SortKind kind, int lift) implements SerTerm
    {
        @Override
        @NotNull
        public SortTerm de(@NotNull DeState state) {
            return new SortTerm(this.kind, this.lift);
        }
    }

    public record Sigma(@NotNull ImmutableSeq<SerParam> params) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new SigmaTerm((ImmutableSeq<Term.Param>)this.params.map(p -> p.de(state)));
        }
    }

    public record Pi(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new PiTerm(this.param.de(state), this.body.de(state));
        }
    }

    public record SerParam(boolean explicit, @NotNull SimpVar var, @NotNull SerTerm term) implements Serializable
    {
        @NotNull
        public Term.Param de(@NotNull DeState state) {
            return new Term.Param(this.var.de(state), this.term.de(state), this.explicit);
        }
    }

    public record SimpVar(int var, @NotNull String name) implements Serializable
    {
        @NotNull
        public LocalVar de(@NotNull DeState state) {
            return state.var(this);
        }
    }

    public record DeState(@NotNull MutableMap<Seq<String>, MutableMap<String, DefVar<?, ?>>> defCache, @NotNull MutableMap<Integer, LocalVar> localCache, @NotNull PrimDef.Factory primFactory) {
        public DeState(@NotNull PrimDef.Factory primFactory) {
            this(MutableMap.create(), (MutableMap<Integer, LocalVar>)MutableMap.create(), primFactory);
        }

        @NotNull
        public LocalVar var(@NotNull SimpVar var) {
            return (LocalVar)this.localCache.getOrPut((Object)var.var, () -> new LocalVar(var.name));
        }

        @NotNull
        public <V extends DefVar<?, ?>> V resolve(@NotNull SerDef.QName name) {
            return (V)((DefVar)((MutableMap)this.defCache.getOrPut(name.mod(), MutableHashMap::new)).getOrPut((Object)name.name(), () -> {
                DefVar empty = DefVar.empty(name.name());
                empty.module = name.mod();
                return empty;
            }));
        }

        @NotNull
        <V extends DefVar<?, ?>> V def(@NotNull SerDef.QName name) {
            return this.resolve(name);
        }

        public void putPrim(@NotNull ImmutableSeq<String> mod, @NotNull PrimDef.ID id, @NotNull DefVar<?, ?> defVar) {
            Option old = ((MutableMap)this.defCache.getOrPut(mod, MutableHashMap::new)).put((Object)id.id, defVar);
            if (old.isDefined()) {
                throw new SerDef.DeserializeException("Same prim deserialized twice: " + id.id);
            }
            defVar.module = mod;
        }
    }
}

