/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Either;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerPat;
import org.aya.core.serde.SerTerm;
import org.aya.core.term.AppTerm;
import org.aya.core.term.CoeTerm;
import org.aya.core.term.ConCall;
import org.aya.core.term.DataCall;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FieldTerm;
import org.aya.core.term.FnCall;
import org.aya.core.term.FormulaTerm;
import org.aya.core.term.HCompTerm;
import org.aya.core.term.InOutTerm;
import org.aya.core.term.IntegerTerm;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.LamTerm;
import org.aya.core.term.ListTerm;
import org.aya.core.term.MatchTerm;
import org.aya.core.term.MetaLitTerm;
import org.aya.core.term.MetaPatTerm;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.NewTerm;
import org.aya.core.term.PAppTerm;
import org.aya.core.term.PLamTerm;
import org.aya.core.term.PartialTerm;
import org.aya.core.term.PartialTyTerm;
import org.aya.core.term.PathTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.PrimCall;
import org.aya.core.term.ProjTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SigmaTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.StringTerm;
import org.aya.core.term.StructCall;
import org.aya.core.term.Term;
import org.aya.core.term.TupTerm;
import org.aya.generic.util.InternalException;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record Serializer(@NotNull State state) {
    @NotNull
    public SerDef serialize(@NotNull GenericDef def) {
        GenericDef genericDef = def;
        Objects.requireNonNull(genericDef);
        GenericDef genericDef2 = genericDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDef.class, FnDef.class, FieldDef.class, StructDef.class, DataDef.class, PrimDef.class, CtorDef.class}, (Object)genericDef2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ClassDef classDef = (ClassDef)genericDef2;
                throw new UnsupportedOperationException("TODO");
            }
            case 1 -> {
                FnDef fn = (FnDef)genericDef2;
                yield new SerDef.Fn(this.state.def(fn.ref), this.serializeParams((ImmutableSeq<Term.Param>)fn.telescope), (Either<SerTerm, ImmutableSeq<SerPat.Clause>>)fn.body.map(this::serialize, matchings -> matchings.map(this::serialize)), fn.modifiers, this.serialize(fn.result));
            }
            case 2 -> {
                FieldDef field = (FieldDef)genericDef2;
                yield new SerDef.Field(this.state.def(field.structRef), this.state.def(field.ref), this.serializeParams((ImmutableSeq<Term.Param>)field.ownerTele), this.serializeParams((ImmutableSeq<Term.Param>)field.selfTele), this.serialize(field.result), (Option<SerTerm>)field.body.map(this::serialize), field.coerce);
            }
            case 3 -> {
                StructDef struct = (StructDef)genericDef2;
                yield new SerDef.Struct(this.state.def(struct.ref()), this.serializeParams((ImmutableSeq<Term.Param>)struct.telescope), this.serialize((SortTerm)struct.result), (ImmutableSeq<SerDef.Field>)struct.fields.map(field -> (SerDef.Field)this.serialize((GenericDef)field)));
            }
            case 4 -> {
                DataDef data = (DataDef)genericDef2;
                yield new SerDef.Data(this.state.def(data.ref), this.serializeParams((ImmutableSeq<Term.Param>)data.telescope), this.serialize((SortTerm)data.result), (ImmutableSeq<SerDef.Ctor>)data.body.map(ctor -> (SerDef.Ctor)this.serialize((GenericDef)ctor)));
            }
            case 5 -> {
                PrimDef prim = (PrimDef)genericDef2;
                if (!$assertionsDisabled && prim.ref.module == null) {
                    throw new AssertionError();
                }
                yield new SerDef.Prim(prim.ref.module, prim.id);
            }
            case 6 -> {
                CtorDef ctor = (CtorDef)genericDef2;
                yield new SerDef.Ctor(this.state.def(ctor.dataRef), this.state.def(ctor.ref), this.serializePats(ctor.pats), this.serializeParams((ImmutableSeq<Term.Param>)ctor.ownerTele), this.serializeParams((ImmutableSeq<Term.Param>)ctor.selfTele), (Partial.Split<SerTerm>)ctor.clauses.fmap(this::serialize), this.serialize(ctor.result), ctor.coerce);
            }
        };
    }

    @NotNull
    private SerTerm.Sort serialize(@NotNull SortTerm term) {
        return new SerTerm.Sort(term.kind(), term.lift());
    }

    @NotNull
    private SerTerm serialize(@NotNull Term term) {
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntegerTerm.class, ListTerm.class, FormulaTerm.class, StringTerm.class, RefTerm.class, RefTerm.Field.class, IntervalTerm.class, PiTerm.class, SigmaTerm.class, ConCall.class, StructCall.class, DataCall.class, PrimCall.class, FieldTerm.class, FnCall.class, ProjTerm.class, AppTerm.class, MatchTerm.class, TupTerm.class, LamTerm.class, NewTerm.class, PartialTerm.class, PartialTyTerm.class, PathTerm.class, PLamTerm.class, PAppTerm.class, CoeTerm.class, MetaTerm.class, MetaPatTerm.class, ErrorTerm.class, MetaLitTerm.class, SortTerm.class, HCompTerm.class, InOutTerm.class}, (Object)term3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                IntegerTerm lit = (IntegerTerm)term3;
                yield new SerTerm.ShapedInt(lit.repr(), SerDef.SerShapeResult.serialize(this.state, lit.recognition()), (SerTerm.Data)this.serialize(lit.type()));
            }
            case 1 -> {
                ListTerm lit = (ListTerm)term3;
                yield new SerTerm.ShapedList((ImmutableSeq<SerTerm>)lit.repr().map(this::serialize), SerDef.SerShapeResult.serialize(this.state, lit.recognition()), (SerTerm.Data)this.serialize(lit.type()));
            }
            case 2 -> {
                FormulaTerm end = (FormulaTerm)term3;
                yield new SerTerm.Mula((Formula<SerTerm>)end.asFormula().fmap(this::serialize));
            }
            case 3 -> {
                StringTerm str = (StringTerm)term3;
                yield new SerTerm.Str(str.string());
            }
            case 4 -> {
                RefTerm ref = (RefTerm)term3;
                yield new SerTerm.Ref(this.state.local(ref.var()));
            }
            case 5 -> {
                RefTerm.Field ref = (RefTerm.Field)term3;
                yield new SerTerm.FieldRef(this.state.def(ref.ref()));
            }
            case 6 -> {
                IntervalTerm interval = (IntervalTerm)term3;
                yield new SerTerm.Interval();
            }
            case 7 -> {
                PiTerm pi = (PiTerm)term3;
                yield new SerTerm.Pi(this.serialize(pi.param()), this.serialize(pi.body()));
            }
            case 8 -> {
                SigmaTerm sigma = (SigmaTerm)term3;
                yield new SerTerm.Sigma(this.serializeParams(sigma.params()));
            }
            case 9 -> {
                ConCall conCall = (ConCall)term3;
                yield new SerTerm.Con(this.state.def(conCall.head().dataRef()), this.state.def(conCall.head().ref()), this.serializeCall(conCall.head().ulift(), conCall.head().dataArgs()), this.serializeArgs(conCall.conArgs()));
            }
            case 10 -> {
                StructCall structCall = (StructCall)term3;
                yield this.serializeStructCall(structCall);
            }
            case 11 -> {
                DataCall dataCall = (DataCall)term3;
                yield this.serializeDataCall(dataCall);
            }
            case 12 -> {
                PrimCall prim = (PrimCall)term3;
                yield new SerTerm.Prim(this.state.def((DefVar<?, ?>)prim.ref()), prim.id(), this.serializeCall(prim.ulift(), prim.args()));
            }
            case 13 -> {
                FieldTerm access = (FieldTerm)term3;
                yield new SerTerm.Access(this.serialize(access.of()), this.state.def((DefVar<?, ?>)access.ref()), this.serializeArgs(access.structArgs()), this.serializeArgs(access.fieldArgs()));
            }
            case 14 -> {
                FnCall fnCall = (FnCall)term3;
                yield new SerTerm.Fn(this.state.def((DefVar<?, ?>)fnCall.ref()), this.serializeCall(fnCall.ulift(), fnCall.args()));
            }
            case 15 -> {
                ProjTerm proj = (ProjTerm)term3;
                yield new SerTerm.Proj(this.serialize(proj.of()), proj.ix());
            }
            case 16 -> {
                AppTerm app = (AppTerm)term3;
                yield new SerTerm.App(this.serialize(app.of()), this.serialize(app.arg()));
            }
            case 17 -> {
                MatchTerm match = (MatchTerm)term3;
                yield new SerTerm.Match((ImmutableSeq<SerTerm>)match.discriminant().map(this::serialize), (ImmutableSeq<SerPat.Clause>)match.clauses().map(this::serialize));
            }
            case 18 -> {
                TupTerm tuple = (TupTerm)term3;
                yield new SerTerm.Tup(this.serializeArgs(tuple.items()));
            }
            case 19 -> {
                LamTerm lambda = (LamTerm)term3;
                yield new SerTerm.Lam(this.serialize(lambda.param()), this.serialize(lambda.body()));
            }
            case 20 -> {
                NewTerm newTerm = (NewTerm)term3;
                yield new SerTerm.New(this.serializeStructCall(newTerm.struct()), (ImmutableMap<SerDef.QName, SerTerm>)ImmutableMap.from((Iterable)newTerm.params().view().map((k, v) -> Tuple.of((Object)this.state.def((DefVar<?, ?>)k), (Object)this.serialize((Term)v)))));
            }
            case 21 -> {
                PartialTerm el = (PartialTerm)term3;
                yield new SerTerm.PartEl(this.partial(el.partial()), this.serialize(el.rhsType()));
            }
            case 22 -> {
                PartialTyTerm ty = (PartialTyTerm)term3;
                yield new SerTerm.PartTy(this.serialize(ty.type()), (Restr<SerTerm>)ty.restr().fmap(this::serialize));
            }
            case 23 -> {
                PathTerm path = (PathTerm)term3;
                yield this.serialize(path);
            }
            case 24 -> {
                PLamTerm path = (PLamTerm)term3;
                yield new SerTerm.PathLam(this.serializeIntervals(path.params()), this.serialize(path.body()));
            }
            case 25 -> {
                PAppTerm app = (PAppTerm)term3;
                yield new SerTerm.PathApp(this.serialize(app.of()), this.serializeArgs(app.args()), this.serialize(app.cube()));
            }
            case 26 -> {
                CoeTerm coe = (CoeTerm)term3;
                yield new SerTerm.Coe(this.serialize(coe.type()), (Restr<SerTerm>)coe.restr().fmap(this::serialize));
            }
            case 27 -> {
                MetaTerm hole = (MetaTerm)term3;
                throw new InternalException("Shall not have holes serialized.");
            }
            case 28 -> {
                MetaPatTerm metaPat = (MetaPatTerm)term3;
                throw new InternalException("Shall not have metaPats serialized.");
            }
            case 29 -> {
                ErrorTerm err = (ErrorTerm)term3;
                throw new InternalException("Shall not have error term serialized.");
            }
            case 30 -> {
                MetaLitTerm err = (MetaLitTerm)term3;
                throw new InternalException("Shall not have metaLiterals serialized.");
            }
            case 31 -> {
                SortTerm sort = (SortTerm)term3;
                yield this.serialize(sort);
            }
            case 32 -> {
                HCompTerm hComp = (HCompTerm)term3;
                throw new InternalException("TODO");
            }
            case 33 -> {
                Object var40_37;
                Term phi = var40_37 = Serializer.$proxy$phi((InOutTerm)term3);
                Term u = var40_37 = Serializer.$proxy$u((InOutTerm)term3);
                Object io = var40_37 = Serializer.$proxy$kind((InOutTerm)term3);
                yield new SerTerm.InOut(this.serialize(phi), this.serialize(u), io == InOutTerm.Kind.In);
            }
        };
    }

    @NotNull
    private Partial<SerTerm> partial(Partial<Term> el) {
        return el.fmap(this::serialize);
    }

    @NotNull
    private SerPat serialize(@NotNull Pat pat, boolean explicit) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Absurd.class, Pat.Ctor.class, Pat.Tuple.class, Pat.Bind.class, Pat.Meta.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                yield new SerPat.Absurd(explicit);
            }
            case 1 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                yield new SerPat.Ctor(explicit, this.state.def(ctor.ref()), this.serializePats(ctor.params()), this.serializeDataCall(ctor.type()));
            }
            case 2 -> {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                yield new SerPat.Tuple(explicit, this.serializePats(tuple.pats()));
            }
            case 3 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                yield new SerPat.Bind(explicit, this.state.local(bind.bind()), this.serialize(bind.type()));
            }
            case 4 -> {
                Pat.Meta meta = (Pat.Meta)pat3;
                throw new InternalException(String.valueOf(meta) + " is illegal here");
            }
            case 5 -> {
                Pat.ShapedInt lit = (Pat.ShapedInt)pat3;
                yield new SerPat.ShapedInt(lit.repr(), explicit, SerDef.SerShapeResult.serialize(this.state, lit.recognition()), this.serializeDataCall(lit.type()));
            }
        };
    }

    @NotNull
    private SerTerm.Path serialize(@NotNull PathTerm cube) {
        return new SerTerm.Path(this.serializeIntervals(cube.params()), this.serialize(cube.type()), this.partial(cube.partial()));
    }

    @NotNull
    private SerTerm.Data serializeDataCall(@NotNull DataCall dataCall) {
        return new SerTerm.Data(this.state.def((DefVar<?, ?>)dataCall.ref()), this.serializeCall(dataCall.ulift(), dataCall.args()));
    }

    @NotNull
    private SerTerm.Struct serializeStructCall(@NotNull StructCall structCall) {
        return new SerTerm.Struct(this.state.def((DefVar<?, ?>)structCall.ref()), this.serializeCall(structCall.ulift(), structCall.args()));
    }

    @NotNull
    private SerPat.Clause serialize(@NotNull Term.Matching matchy) {
        return new SerPat.Clause(this.serializePats(matchy.patterns()), this.serialize(matchy.body()));
    }

    private SerTerm.SerArg serialize(@NotNull @NotNull Arg<@NotNull Term> termArg) {
        return new SerTerm.SerArg(this.serialize((Term)termArg.term()), termArg.explicit());
    }

    @Contract(value="_ -> new")
    private SerTerm.SerParam serialize(@NotNull Term.Param param) {
        return new SerTerm.SerParam(param.explicit(), this.serialize(param.ref()), this.serialize(param.type()));
    }

    @NotNull
    private SerTerm.SimpVar serialize(@NotNull LocalVar localVar) {
        return this.state.local(localVar);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerParam> serializeParams(ImmutableSeq<@NotNull Term.Param> params) {
        return params.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SimpVar> serializeIntervals(ImmutableSeq<LocalVar> params) {
        return params.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerArg> serializeArgs(@NotNull ImmutableSeq<Arg<Term>> args) {
        return args.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerPat> serializePats(@NotNull ImmutableSeq<Arg<Pat>> pats) {
        return pats.map(x -> this.serialize((Pat)x.term(), x.explicit()));
    }

    @NotNull
    private SerTerm.CallData serializeCall(int ulift, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
        return new SerTerm.CallData(ulift, this.serializeArgs(args));
    }

    private static /* synthetic */ Term $proxy$phi(InOutTerm arg0) {
        try {
            return arg0.phi();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Term $proxy$u(InOutTerm arg0) {
        try {
            return arg0.u();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ InOutTerm.Kind $proxy$kind(InOutTerm arg0) {
        try {
            return arg0.kind();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    public record State(@NotNull MutableMap<LocalVar, Integer> localCache) {
        public State() {
            this((MutableMap<LocalVar, Integer>)MutableMap.create());
        }

        @NotNull
        public SerTerm.SimpVar local(@NotNull LocalVar var) {
            return new SerTerm.SimpVar((Integer)this.localCache.getOrPut((Object)var, () -> this.localCache.size()), var.name());
        }

        @NotNull
        public SerDef.QName def(@NotNull DefVar<?, ?> var) {
            assert (var.module != null);
            return new SerDef.QName(var.module, var.name());
        }
    }
}

