/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import org.aya.core.term.AppTerm;
import org.aya.core.term.FormulaTerm;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.LamTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.AyaRestrSimplifier;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

public record CoeTerm(@NotNull Term type, @NotNull Restr<Term> restr) implements Term
{
    @NotNull
    public static Term coeFill(@NotNull Term type, @NotNull Restr<Term> phi, Term ri) {
        Restr cofib = phi.or(new Restr.Cond((Object)ri, false));
        LocalVar varY = new LocalVar("y");
        Term.Param paramY = new Term.Param(varY, IntervalTerm.INSTANCE, true);
        FormulaTerm xAndY = FormulaTerm.and(ri, new RefTerm(varY));
        LamTerm a = new LamTerm(paramY, AppTerm.make(type, (Arg<Term>)new Arg((Object)xAndY, true)));
        return new CoeTerm(a, (Restr<Term>)cofib);
    }

    @NotNull
    private static Term forward(@NotNull Term A, @NotNull Term r) {
        LocalVar varI = new LocalVar("i");
        LocalVar varU = new LocalVar("u");
        FormulaTerm iOrR = FormulaTerm.or(new RefTerm(varI), r);
        Restr cofib = AyaRestrSimplifier.INSTANCE.isOne(r);
        Term Ar = AppTerm.make(A, (Arg<Term>)new Arg((Object)r, true));
        Term AiOrR = AppTerm.make(A, (Arg<Term>)new Arg((Object)iOrR, true));
        LamTerm lam = new LamTerm(new Term.Param(varI, IntervalTerm.INSTANCE, true), AiOrR);
        CoeTerm transp = new CoeTerm(lam, (Restr<Term>)cofib);
        Term body = AppTerm.make(transp, (Arg<Term>)new Arg((Object)new RefTerm(varU), true));
        return new LamTerm(new Term.Param(LocalVar.IGNORED, Ar, true), body);
    }

    @NotNull
    private static Term invertA(@NotNull Term A) {
        LocalVar i = new LocalVar("i");
        FormulaTerm invertedI = FormulaTerm.inv(new RefTerm(i));
        return new LamTerm(new Term.Param(i, IntervalTerm.INSTANCE, true), AppTerm.make(A, (Arg<Term>)new Arg((Object)invertedI, true)));
    }

    @NotNull
    public static Term coeInv(@NotNull Term A, @NotNull Restr<Term> phi) {
        return new CoeTerm(CoeTerm.invertA(A), phi);
    }

    @NotNull
    public static Term coeFillInv(@NotNull Term type, @NotNull Restr<Term> phi, @NotNull Term ri) {
        return CoeTerm.coeFill(CoeTerm.invertA(type), phi, FormulaTerm.inv(ri));
    }
}

