/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import org.aya.core.term.Term;
import org.aya.core.visitor.AyaRestrSimplifier;
import org.jetbrains.annotations.NotNull;

public record InOutTerm(@NotNull Term phi, @NotNull Term u, @NotNull Kind kind) implements Term
{
    @NotNull
    public static Term make(@NotNull Term phi, @NotNull Term u, @NotNull Kind kind) {
        return InOutTerm.make(new InOutTerm(phi, u, kind));
    }

    @NotNull
    public static Term make(@NotNull InOutTerm material) {
        Term term = material.u;
        if (term instanceof InOutTerm) {
            InOutTerm io = (InOutTerm)term;
            if (io.kind != material.kind) {
                if (material.kind == Kind.Out) {
                    return io.u;
                }
                if (AyaRestrSimplifier.INSTANCE.implies(io.phi, material.phi)) {
                    return io.u;
                }
            }
        }
        return material;
    }

    public static enum Kind {
        In,
        Out;

        @NotNull
        public final String fnName = this.name().toLowerCase() + "S";
    }
}

