/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableArrayList;
import org.aya.core.term.AppTerm;
import org.aya.core.term.CoeTerm;
import org.aya.core.term.Formation;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.LamTerm;
import org.aya.core.term.ProjTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.StableWHNF;
import org.aya.core.term.Term;
import org.aya.core.term.TupTerm;
import org.aya.core.visitor.BetaExpander;
import org.aya.core.visitor.Subst;
import org.aya.generic.SortKind;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

public record SigmaTerm(@NotNull @NotNull ImmutableSeq<@NotNull Term.Param> params) implements StableWHNF,
Formation
{
    private static final Term I = IntervalTerm.INSTANCE;

    @NotNull
    public static SortTerm max(@NotNull SortTerm x, @NotNull SortTerm y) {
        int lift = Math.max(x.lift(), y.lift());
        if (x.kind() == SortKind.Prop || y.kind() == SortKind.Prop) {
            return SortTerm.Prop;
        }
        if (x.kind() == SortKind.Set || y.kind() == SortKind.Set) {
            return new SortTerm(SortKind.Set, lift);
        }
        if (x.kind() == SortKind.Type || y.kind() == SortKind.Type) {
            return new SortTerm(SortKind.Type, lift);
        }
        if (x.kind() == SortKind.ISet || y.kind() == SortKind.ISet) {
            return SortTerm.ISet;
        }
        throw new AssertionError((Object)"unreachable");
    }

    @NotNull
    public LamTerm coe(@NotNull CoeTerm coe, @NotNull LocalVar i) {
        RefTerm t = new RefTerm(new LocalVar("t"));
        assert (this.params.sizeGreaterThanOrEquals(2));
        MutableArrayList items = MutableArrayList.create((int)this.params.size());
        Subst subst = new Subst();
        int ix = 1;
        for (Term.Param param : this.params) {
            ProjTerm tn = new ProjTerm(t, ix++);
            LamTerm An = new LamTerm(new Term.Param(i, I, true), param.type().subst(subst));
            record Item(@NotNull CoeTerm coe, @NotNull Arg<Term> arg) {
                @NotNull
                public Term fill(@NotNull LocalVar i) {
                    return AppTerm.make(CoeTerm.coeFill(this.coe.type(), this.coe.restr(), new RefTerm(i)), this.arg);
                }

                @NotNull
                public Term app() {
                    return AppTerm.make(this.coe, this.arg);
                }
            }
            Item item = new Item(new CoeTerm(An, coe.restr()), (Arg<Term>)new Arg((Object)tn, true));
            subst.add(param.ref(), item.fill(i));
            items.append((Object)new Arg((Object)item.app(), param.explicit()));
        }
        return new LamTerm(BetaExpander.coeDom(t.var(), coe.type()), new TupTerm((ImmutableSeq<Arg<Term>>)items.toImmutableArray()));
    }
}

