/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.value.MutableValue;
import org.aya.core.pat.Pat;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.util.InternalException;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public interface PatTraversal
extends UnaryOperator<Pat> {
    @NotNull
    default public Pat pre(@NotNull Pat pat) {
        return pat;
    }

    @NotNull
    default public Pat post(@NotNull Pat pat) {
        return pat;
    }

    @Override
    @NotNull
    default public Pat apply(@NotNull Pat pat) {
        return this.post(this.descent(this.pre(pat)));
    }

    @NotNull
    default public Pat descent(@NotNull Pat pat) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Absurd.class, Pat.Bind.class, Pat.Ctor.class, Pat.Meta.class, Pat.ShapedInt.class, Pat.Tuple.class}, (Object)pat3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pat.Absurd absurd;
                yield absurd = (Pat.Absurd)pat3;
            }
            case 1 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                yield bind;
            }
            case 2 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                ImmutableSeq params = ctor.params().map(x -> x.descent((UnaryOperator)this));
                if (params.sameElements(ctor.params(), true)) {
                    yield ctor;
                }
                yield new Pat.Ctor(ctor.ref(), (ImmutableSeq<Arg<Pat>>)params, ctor.type());
            }
            case 3 -> {
                Pat.Meta meta = (Pat.Meta)pat3;
                Pat solution = (Pat)meta.solution().get();
                if (solution != null) {
                    Pat newSolution = this.apply(solution);
                    if (newSolution == solution) {
                        yield meta;
                    }
                    yield new Pat.Meta((MutableValue<Pat>)MutableValue.create((Object)solution), meta.fakeBind(), meta.type());
                }
                yield meta;
            }
            case 4 -> {
                Pat.ShapedInt shapedInt = (Pat.ShapedInt)pat3;
                yield shapedInt;
            }
            case 5 -> {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                ImmutableSeq pats = tuple.pats().map(x -> x.descent((UnaryOperator)this));
                if (pats.sameElements(tuple.pats(), true)) {
                    yield tuple;
                }
                yield new Pat.Tuple((ImmutableSeq<Arg<Pat>>)pats);
            }
        };
    }

    public record MetaBind(@NotNull Subst subst, @NotNull SourcePos definition) implements NoMeta
    {
        @Override
        @NotNull
        public Pat post(@NotNull Pat pat) {
            if (pat instanceof Pat.Bind) {
                Object object = MetaBind.$proxy$bind((Pat.Bind)pat);
                LocalVar bind = object;
                Object type = object = MetaBind.$proxy$type((Pat.Bind)pat);
                LocalVar newVar = new LocalVar(bind.name(), this.definition);
                Pat.Meta meta = new Pat.Meta((MutableValue<Pat>)MutableValue.create(), newVar, (Term)type);
                this.subst.addDirectly(bind, meta.toTerm());
                return meta;
            }
            return NoMeta.super.post(pat);
        }

        private static /* synthetic */ LocalVar $proxy$bind(Pat.Bind arg0) {
            try {
                return arg0.bind();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString(), throwable);
            }
        }

        private static /* synthetic */ Term $proxy$type(Pat.Bind arg0) {
            try {
                return arg0.type();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString(), throwable);
            }
        }
    }

    public static interface NoMeta
    extends PatTraversal {
        @Override
        @NotNull
        default public Pat descent(@NotNull Pat pat) {
            if (pat instanceof Pat.Meta) {
                throw new InternalException("expected: no Pat.Meta, but actual: Pat.Meta");
            }
            return PatTraversal.super.descent(pat);
        }
    }
}

