/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableTreeMap;
import org.aya.core.term.FormulaTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.AyaRestrSimplifier;
import org.aya.generic.AyaDocile;
import org.aya.generic.util.NormalizeMode;
import org.aya.guest0x0.cubical.CofThy;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Restr;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.TyckState;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="map.toString()", childrenArray="map.asJava().entrySet().toArray()", hasChildren="map.isNotEmpty()")
public record Subst(@NotNull @NotNull MutableMap<@NotNull AnyVar, @NotNull Term> map) implements AyaDocile,
CofThy.SubstObj<Term, LocalVar, Subst>
{
    @NotNull
    public static final Subst EMPTY = new Subst((MutableMap<AnyVar, Term>)MutableTreeMap.of((o1, o2) -> {
        throw new UnsupportedOperationException("Shall not modify LevelSubst.EMPTY");
    }));

    public Subst() {
        this((MutableMap<AnyVar, Term>)MutableMap.create());
    }

    public Subst(@NotNull AnyVar var, @NotNull Term term) {
        this((MutableMap<AnyVar, Term>)MutableHashMap.of((Object)var, (Object)term));
    }

    public Subst(@NotNull SeqLike<LocalVar> from, @NotNull SeqLike<? extends Term> to) {
        this((MutableMap<AnyVar, Term>)MutableMap.from((Iterable)from.zipView(to)));
    }

    public void subst(@NotNull Subst subst) {
        if (this.map.isEmpty()) {
            return;
        }
        this.map.replaceAll((var, term) -> term.subst(subst));
    }

    public ImmutableSeq<AnyVar> overlap(@NotNull Subst subst) {
        if (subst.map.isEmpty() || this.map.isEmpty()) {
            return ImmutableSeq.empty();
        }
        return this.map.keysView().filter(arg_0 -> subst.map.containsKey(arg_0)).toImmutableSeq();
    }

    @NotNull
    public Subst addDirectly(@NotNull AnyVar var, @NotNull Term term) {
        this.map.put((Object)var, (Object)term);
        return this;
    }

    @NotNull
    public Subst addAllDirectly(@NotNull Subst subst) {
        this.map.putAll(subst.map);
        return this;
    }

    @NotNull
    public Subst add(@NotNull AnyVar var, @NotNull Term term) {
        this.subst(new Subst(var, term));
        return this.addDirectly(var, term);
    }

    @NotNull
    public Subst add(@NotNull Subst subst) {
        if (subst.map.isEmpty()) {
            return this;
        }
        this.subst(subst);
        this.map.putAll(subst.map);
        return this;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void put(LocalVar i, boolean isOne) {
        this.map.put((Object)i, (Object)(isOne ? FormulaTerm.RIGHT : FormulaTerm.LEFT));
    }

    public boolean contradicts(LocalVar i, boolean newIsOne) {
        if (!this.map.containsKey((Object)i)) {
            return false;
        }
        Formula formula = ((Term)this.map.get((Object)i)).asFormula();
        if (!(formula instanceof Formula.Lit)) {
            return false;
        }
        Formula.Lit end = (Formula.Lit)formula;
        return end.isOne() != newIsOne;
    }

    @Nullable
    public LocalVar asRef(@NotNull Term term) {
        LocalVar localVar;
        LocalVar var;
        return term instanceof RefTerm ? (var = (localVar = Subst.$proxy$var((RefTerm)term))) : null;
    }

    @NotNull
    public Subst derive() {
        return new Subst((MutableMap<AnyVar, Term>)MutableMap.from(this.map));
    }

    @NotNull
    public Restr<Term> restr(@NotNull TyckState state, @NotNull Restr<Term> restr) {
        return AyaRestrSimplifier.INSTANCE.normalizeRestr(restr.map(t -> t.subst(this).normalize(state, NormalizeMode.WHNF)));
    }

    @Override
    @NotNull
    public Doc toDoc(@NotNull PrettierOptions options) {
        return Doc.commaList((SeqLike)this.map.view().map((var, term) -> Doc.sep((Doc[])new Doc[]{BasePrettier.varDoc(var), Doc.symbol((String)"=>"), term.toDoc(options)})).toImmutableSeq());
    }

    private static /* synthetic */ LocalVar $proxy$var(RefTerm arg0) {
        try {
            return arg0.var();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }
}

