/*
 * Decompiled with CFR 0.152.
 */
package org.aya.prettier;

import com.intellij.openapi.util.text.StringUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.range.primitive.IntRange;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.ClassDecl;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.concrete.stmt.UseHide;
import org.aya.concrete.visitor.ExprConsumer;
import org.aya.generic.Modifier;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.aya.util.binop.Assoc;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public class ConcretePrettier
extends BasePrettier<Expr> {
    public ConcretePrettier(@NotNull PrettierOptions options) {
        super(options);
    }

    @Override
    @NotNull
    public Doc term(@NotNull BasePrettier.Outer outer, @NotNull Expr prexpr) {
        Expr expr = prexpr;
        Objects.requireNonNull(expr);
        Expr expr2 = expr;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Error.class, Expr.Tuple.class, Expr.BinOpSeq.class, Expr.LitString.class, Expr.Pi.class, Expr.App.class, Expr.Lambda.class, Expr.Hole.class, Expr.Proj.class, Expr.Match.class, Expr.RawProj.class, Expr.Coe.class, Expr.Unresolved.class, Expr.Ref.class, Expr.LitInt.class, Expr.RawSort.class, Expr.New.class, Expr.Sigma.class, Expr.Sort.class, Expr.Lift.class, Expr.PartEl.class, Expr.Path.class, Expr.Idiom.class, Expr.Do.class, Expr.Array.class, Expr.Let.class}, (Object)expr2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Expr.Error error = (Expr.Error)expr2;
                yield Doc.angled((Doc)error.description().toDoc(this.options));
            }
            case 1 -> {
                Expr.Tuple expr = (Expr.Tuple)expr2;
                yield Doc.parened((Doc)Doc.commaList((SeqLike)expr.items().view().map(e -> this.term(BasePrettier.Outer.Free, (Expr)e))));
            }
            case 2 -> {
                Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr2;
                ImmutableSeq<Expr.NamedArg> seq = binOpSeq.seq();
                Expr first = ((Expr.NamedArg)seq.first()).term();
                if (seq.sizeEquals(1)) {
                    yield this.term(outer, first);
                }
                yield this.visitCalls(null, this.term(BasePrettier.Outer.AppSpine, first), seq.view().drop(1), outer, (boolean)((Boolean)this.options.map.get((Object)AyaPrettierOptions.Key.ShowImplicitArgs)));
            }
            case 3 -> {
                Expr.LitString expr = (Expr.LitString)expr2;
                yield Doc.plain((String)("\"" + StringUtil.unescapeStringCharacters((String)expr.string()) + "\""));
            }
            case 4 -> {
                final Expr.Pi expr = (Expr.Pi)expr2;
                final boolean[] data = new boolean[]{false, false};
                new ExprConsumer(){

                    @Override
                    public void pre(@NotNull Expr e) {
                        Expr expr3 = e;
                        Objects.requireNonNull(expr3);
                        Expr expr2 = expr3;
                        int n = 0;
                        block4: while (true) {
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Ref.class, Expr.Unresolved.class}, (Object)expr2, n)) {
                                case 0: {
                                    Expr.Ref ref = (Expr.Ref)expr2;
                                    if (ref.resolvedVar() != expr.param().ref()) {
                                        n = 1;
                                        continue block4;
                                    }
                                    data[0] = true;
                                    break block4;
                                }
                                case 1: {
                                    Expr.Unresolved ignored = (Expr.Unresolved)expr2;
                                    data[1] = true;
                                    break block4;
                                }
                                default: {
                                    ExprConsumer.super.pre(e);
                                    break block4;
                                }
                            }
                            break;
                        }
                    }
                }.accept(expr.last());
                Doc last = this.term(BasePrettier.Outer.Codomain, expr.last());
                Doc doc = !data[0] && !data[1] ? Doc.sep((Doc[])new Doc[]{this.justType(expr.param(), BasePrettier.Outer.Domain), Doc.symbol((String)"->"), last}) : Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), expr.param().toDoc(this.options), Doc.symbol((String)"->"), last});
                yield ConcretePrettier.checkParen(outer, doc, BasePrettier.Outer.Domain);
            }
            case 5 -> {
                Expr.Ref ref;
                AnyVar var16_26;
                Expr.App expr = (Expr.App)expr2;
                MutableList args = MutableList.of((Object)expr.argument());
                Expr head = Expr.unapp(expr.function(), (MutableList<Expr.NamedArg>)args);
                Assoc assoc = null;
                if (head instanceof Expr.Ref && (var16_26 = (ref = (Expr.Ref)head).resolvedVar()) instanceof DefVar) {
                    DefVar var = (DefVar)var16_26;
                    assoc = var.assoc();
                }
                yield this.visitCalls(assoc, this.term(BasePrettier.Outer.AppHead, head), args.view(), outer, (boolean)((Boolean)this.options.map.get((Object)AyaPrettierOptions.Key.ShowImplicitArgs)));
            }
            case 6 -> {
                Expr.Lambda expr = (Expr.Lambda)expr2;
                if (!((Boolean)this.options.map.get((Object)AyaPrettierOptions.Key.ShowImplicitPats)).booleanValue() && !expr.param().explicit()) {
                    yield this.term(outer, expr.body());
                }
                MutableList prelude = MutableList.of((Object)Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")), (Object)this.lambdaParam(expr.param()));
                if (!(expr.body() instanceof Expr.Hole)) {
                    prelude.append((Object)Doc.symbol((String)"=>"));
                    prelude.append((Object)this.term(BasePrettier.Outer.Free, expr.body()));
                }
                yield ConcretePrettier.checkParen(outer, Doc.sep((SeqLike)prelude), BasePrettier.Outer.BinOp);
            }
            case 7 -> {
                Expr.Hole expr = (Expr.Hole)expr2;
                if (!expr.explicit()) {
                    yield Doc.symbol((String)"_");
                }
                Expr filling = expr.filling();
                if (filling == null) {
                    yield Doc.symbol((String)"{??}");
                }
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{?"), this.term(BasePrettier.Outer.Free, filling), Doc.symbol((String)"?}")});
            }
            case 8 -> {
                Expr.Proj expr = (Expr.Proj)expr2;
                yield Doc.cat((Doc[])new Doc[]{this.term(BasePrettier.Outer.ProjHead, expr.tup()), Doc.symbol((String)"."), Doc.plain((String)((String)expr.ix().fold(Objects::toString, QualifiedID::join)))});
            }
            case 9 -> {
                Expr.Match match = (Expr.Match)expr2;
                yield Doc.cblock((Doc)Doc.cat((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"match"), Doc.commaList((SeqLike)match.discriminant().map(t -> this.term(BasePrettier.Outer.Free, (Expr)t)))}), (int)2, (Doc)Doc.vcat((SeqLike)match.clauses().view().map(clause -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), Doc.commaList((SeqLike)clause.patterns.map(p -> this.pattern((Arg<Pattern>)p, BasePrettier.Outer.Free))), (Doc)clause.expr.map(t -> Doc.cat((Doc[])new Doc[]{Doc.symbol((String)"=>"), this.term(BasePrettier.Outer.Free, (Expr)t)})).getOrDefault((Object)Doc.empty())})).toImmutableSeq()));
            }
            case 10 -> {
                Expr.RawProj expr = (Expr.RawProj)expr2;
                yield Doc.sepNonEmpty((Doc[])new Doc[]{Doc.cat((Doc[])new Doc[]{this.term(BasePrettier.Outer.ProjHead, expr.tup()), Doc.symbol((String)"."), Doc.plain((String)expr.id().join())}), expr.coeLeft() != null ? this.term(BasePrettier.Outer.AppSpine, expr.coeLeft()) : Doc.empty(), expr.restr() != null ? Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"freeze"), this.term(BasePrettier.Outer.AppSpine, expr.restr())}) : Doc.empty()});
            }
            case 11 -> {
                Expr.Coe expr = (Expr.Coe)expr2;
                yield this.visitCalls(expr.resolvedVar(), PRIM, ImmutableSeq.of((Object)new Arg((Object)expr.type(), true), (Object)new Arg((Object)expr.restr(), true)), outer, (boolean)((Boolean)this.options.map.get((Object)AyaPrettierOptions.Key.ShowImplicitArgs)));
            }
            case 12 -> {
                Expr.Unresolved expr = (Expr.Unresolved)expr2;
                yield Doc.plain((String)expr.name().join());
            }
            case 13 -> {
                Expr.Ref expr = (Expr.Ref)expr2;
                AnyVar ref = expr.resolvedVar();
                if (ref instanceof DefVar) {
                    DefVar defVar = (DefVar)ref;
                    yield ConcretePrettier.defVar(defVar);
                }
                yield ConcretePrettier.varDoc(ref);
            }
            case 14 -> {
                Expr.LitInt expr = (Expr.LitInt)expr2;
                yield Doc.plain((String)String.valueOf(expr.integer()));
            }
            case 15 -> {
                Expr.RawSort e = (Expr.RawSort)expr2;
                yield Doc.styled((Style)KEYWORD, (String)e.kind().name());
            }
            case 16 -> {
                Expr.New expr = (Expr.New)expr2;
                yield Doc.cblock((Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"new"), this.term(BasePrettier.Outer.Free, expr.struct())}), (int)2, (Doc)Doc.vcat((SeqLike)expr.fields().view().map(t -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), Doc.styled((Style)FIELD, (String)((String)t.name().data())), Doc.emptyIf((boolean)t.bindings().isEmpty(), () -> Doc.sep((SeqLike)t.bindings().map(v -> ConcretePrettier.varDoc((AnyVar)v.data())))), Doc.plain((String)"=>"), this.term(BasePrettier.Outer.Free, t.body())}))));
            }
            case 17 -> {
                Expr.Sigma expr = (Expr.Sigma)expr2;
                yield ConcretePrettier.checkParen(outer, Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele(expr.params().dropLast(1)), Doc.symbol((String)"**"), this.term(BasePrettier.Outer.Codomain, ((Expr.Param)expr.params().last()).type())}), BasePrettier.Outer.BinOp);
            }
            case 18 -> {
                Expr.Sort expr = (Expr.Sort)expr2;
                Doc fn = Doc.styled((Style)KEYWORD, (String)expr.kind().name());
                if (!expr.kind().hasLevel()) {
                    yield fn;
                }
                yield this.visitCalls(null, fn, (nc, l) -> l.toDoc(this.options), outer, SeqView.of((Object)new Arg(o -> Doc.plain((String)String.valueOf(expr.lift())), true)), true);
            }
            case 19 -> {
                Expr.Lift expr = (Expr.Lift)expr2;
                yield Doc.sep((SeqLike)Seq.from((Iterator)IntRange.closed((int)1, (int)expr.lift()).iterator()).view().map($ -> Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"ulift"))).appended((Object)this.term(BasePrettier.Outer.Lifted, expr.expr())));
            }
            case 20 -> {
                Expr.PartEl el = (Expr.PartEl)expr2;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{|"), this.partial(el), Doc.symbol((String)"|}")});
            }
            case 21 -> {
                Expr.Path path = (Expr.Path)expr2;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"[|"), Doc.commaList((SeqLike)path.params().map(BasePrettier::linkDef)), Doc.symbol((String)"|]"), path.type().toDoc(this.options), path.partial().toDoc(this.options)});
            }
            case 22 -> {
                Expr.Idiom idiom = (Expr.Idiom)expr2;
                yield Doc.wrap((String)"(|", (String)"|)", (Doc)Doc.join((Doc)Doc.symbol((String)"|"), (SeqLike)idiom.barredApps().view().map(app -> this.term(BasePrettier.Outer.Free, (Expr)app))));
            }
            case 23 -> {
                Expr.Do doExpr = (Expr.Do)expr2;
                ImmutableSeq doBlockDoc = doExpr.binds().map(this::visitDoBinding);
                yield Doc.stickySep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"do"), Doc.flatAltBracedBlock((Doc)Doc.commaList((SeqLike)doBlockDoc), (Doc)Doc.vcommaList((SeqLike)doBlockDoc.map(x -> Doc.nest((int)2, (Doc)x))))});
            }
            case 24 -> {
                Expr.Array arr = (Expr.Array)expr2;
                yield (Doc)arr.arrayBlock().fold(left -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"["), this.term(BasePrettier.Outer.Free, left.generator()), Doc.symbol((String)"|"), Doc.commaList((SeqLike)left.binds().map(this::visitDoBinding)), Doc.symbol((String)"]")}), right -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"["), Doc.commaList((SeqLike)right.exprList().view().map(e -> this.term(BasePrettier.Outer.Free, (Expr)e))), Doc.symbol((String)"]")}));
            }
            case 25 -> {
                Expr.Let let = (Expr.Let)expr2;
                Tuple2<ImmutableSeq<Expr.LetBind>, Expr> letsAndBody = this.sugarLet(let);
                ImmutableSeq lets = (ImmutableSeq)letsAndBody._1;
                Expr body = (Expr)letsAndBody._2;
                boolean oneLine = lets.sizeEquals(1);
                Doc letSeq = oneLine ? this.visitLetBind((Expr.LetBind)lets.first()) : Doc.vcat((SeqLike)lets.view().map(this::visitLetBind).map(x -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), x})));
                ImmutableSeq docs = ImmutableSeq.of((Object)Doc.styled((Style)KEYWORD, (String)"let"), (Object)letSeq, (Object)Doc.styled((Style)KEYWORD, (String)"in"));
                Doc halfLet = oneLine ? Doc.sep((SeqLike)docs) : Doc.vcat((SeqLike)docs);
                yield Doc.sep((Doc[])new Doc[]{halfLet, this.term(BasePrettier.Outer.Free, body)});
            }
        };
    }

    private Doc partial(Expr.PartEl el) {
        return Doc.join((Doc)Doc.spaced((Doc)Doc.symbol((String)"|")), (SeqLike)el.clauses().map(cl -> Doc.sep((Doc[])new Doc[]{this.term(BasePrettier.Outer.Free, (Expr)cl._1), Doc.symbol((String)":="), this.term(BasePrettier.Outer.Free, (Expr)cl._2)})));
    }

    @NotNull
    public Doc pattern(@NotNull Arg<Pattern> pattern, BasePrettier.Outer outer) {
        return this.pattern((Pattern)pattern.term(), pattern.explicit(), outer);
    }

    @NotNull
    public Doc pattern(@NotNull Pattern pattern, boolean licit, BasePrettier.Outer outer) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Tuple.class, Pattern.Absurd.class, Pattern.Bind.class, Pattern.CalmFace.class, Pattern.Number.class, Pattern.Ctor.class, Pattern.QualifiedRef.class, Pattern.BinOpSeq.class, Pattern.List.class, Pattern.As.class}, (Object)pattern3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                yield Doc.licit((boolean)licit, (Doc)Doc.commaList((SeqLike)tuple.patterns().view().map(p -> this.pattern((Arg<Pattern>)p, BasePrettier.Outer.Free))));
            }
            case 1 -> {
                Pattern.Absurd $ = (Pattern.Absurd)pattern3;
                yield Doc.bracedUnless((Doc)Doc.styled((Style)KEYWORD, (String)"()"), (boolean)licit);
            }
            case 2 -> {
                Pattern.Bind bind = (Pattern.Bind)pattern3;
                yield Doc.bracedUnless((Doc)ConcretePrettier.linkDef(bind.bind()), (boolean)licit);
            }
            case 3 -> {
                Pattern.CalmFace $ = (Pattern.CalmFace)pattern3;
                yield Doc.bracedUnless((Doc)Doc.plain((String)"_"), (boolean)licit);
            }
            case 4 -> {
                Pattern.Number number = (Pattern.Number)pattern3;
                yield Doc.bracedUnless((Doc)Doc.plain((String)String.valueOf(number.number())), (boolean)licit);
            }
            case 5 -> {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                Doc name = ConcretePrettier.linkRef((AnyVar)ctor.resolved().data(), CON);
                Doc ctorDoc = ctor.params().isEmpty() ? name : Doc.sep((Doc[])new Doc[]{name, this.visitMaybeCtorPatterns((SeqLike<Arg<Pattern>>)ctor.params(), BasePrettier.Outer.AppSpine, Doc.ALT_WS)});
                yield this.ctorDoc(outer, licit, ctorDoc, ctor.params().isEmpty());
            }
            case 6 -> {
                Pattern.QualifiedRef qref = (Pattern.QualifiedRef)pattern3;
                yield Doc.bracedUnless((Doc)Doc.plain((String)qref.qualifiedID().join()), (boolean)licit);
            }
            case 7 -> {
                SourcePos var15_16;
                SourcePos pos = var15_16 = ConcretePrettier.$proxy$sourcePos((Pattern.BinOpSeq)pattern3);
                SourcePos param = var15_16 = ConcretePrettier.$proxy$seq((Pattern.BinOpSeq)pattern3);
                if (param.sizeEquals(1)) {
                    yield this.pattern((Arg<Pattern>)((Arg)param.first()), outer);
                }
                Doc ctorDoc = this.visitMaybeCtorPatterns((SeqLike<Arg<Pattern>>)param.view(), BasePrettier.Outer.AppSpine, Doc.ALT_WS);
                yield this.ctorDoc(outer, licit, ctorDoc, param.sizeLessThanOrEquals(1));
            }
            case 8 -> {
                Pattern.List list = (Pattern.List)pattern3;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"["), Doc.commaList((SeqLike)list.elements().map(x -> this.pattern((Pattern)x, true, BasePrettier.Outer.Free))), Doc.symbol((String)"]")});
            }
            case 9 -> {
                Pattern.As as = (Pattern.As)pattern3;
                Seq asBind = Seq.of((Object)Doc.styled((Style)KEYWORD, (String)"as"), (Object)ConcretePrettier.linkDef(as.as()));
                if (outer == BasePrettier.Outer.AppSpine) {
                    Doc inner = this.pattern(as.pattern(), true, BasePrettier.Outer.Free);
                    yield Doc.licit((boolean)licit, (Doc)Doc.sep((SeqLike)SeqView.of((Object)inner).concat((SeqLike)asBind)));
                }
                Doc inner = this.pattern(as.pattern(), licit, BasePrettier.Outer.Free);
                yield Doc.sep((SeqLike)SeqView.of((Object)inner).concat((SeqLike)asBind));
            }
        };
    }

    private Doc visitMaybeCtorPatterns(SeqLike<Arg<Pattern>> patterns, BasePrettier.Outer outer, @NotNull Doc delim) {
        patterns = (Boolean)this.options.map.get((Object)AyaPrettierOptions.Key.ShowImplicitPats) != false ? patterns : patterns.view().filter(Arg::explicit);
        return Doc.join((Doc)delim, (SeqLike)patterns.view().map(p -> this.pattern((Arg<Pattern>)p, outer)));
    }

    public Doc matchy(@NotNull Pattern.Clause match) {
        Doc doc = this.visitMaybeCtorPatterns((SeqLike<Arg<Pattern>>)match.patterns, BasePrettier.Outer.Free, Doc.plain((String)", "));
        return (Doc)match.expr.map(e -> Doc.sep((Doc[])new Doc[]{doc, Doc.plain((String)"=>"), this.term(BasePrettier.Outer.Free, (Expr)e)})).getOrDefault((Object)doc);
    }

    private Doc visitAccess(@NotNull Stmt.Accessibility accessibility, Stmt.Accessibility def) {
        if (accessibility == def) {
            return Doc.empty();
        }
        return Doc.styled((Style)KEYWORD, (String)accessibility.keyword);
    }

    @NotNull
    public Doc stmt(@NotNull Stmt prestmt) {
        Stmt stmt = prestmt;
        Objects.requireNonNull(stmt);
        Stmt stmt2 = stmt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Import.class, Generalize.class, Command.Open.class, Command.Module.class}, (Object)stmt2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Decl decl = (Decl)stmt2;
                yield this.decl(decl);
            }
            case 1 -> {
                Command.Import cmd = (Command.Import)stmt2;
                MutableList prelude = MutableList.of((Object)Doc.styled((Style)KEYWORD, (String)"import"), (Object)Doc.symbol((String)cmd.path().join()));
                if (cmd.asName() != null) {
                    prelude.append((Object)Doc.styled((Style)KEYWORD, (String)"as"));
                    prelude.append((Object)Doc.plain((String)cmd.asName()));
                }
                yield Doc.sep((SeqLike)prelude);
            }
            case 2 -> {
                Generalize variables = (Generalize)stmt2;
                yield Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"variables"), this.visitTele(variables.toExpr())});
            }
            case 3 -> {
                Command.Open cmd = (Command.Open)stmt2;
                Doc[] v2 = new Doc[5];
                v2[0] = this.visitAccess(cmd.accessibility(), Stmt.Accessibility.Private);
                v2[1] = Doc.styled((Style)KEYWORD, (String)"open");
                v2[2] = Doc.plain((String)cmd.path().join());
                String v3 = switch (cmd.useHide().strategy()) {
                    default -> throw new IncompatibleClassChangeError();
                    case UseHide.Strategy.Using -> "using";
                    case UseHide.Strategy.Hiding -> "hiding";
                };
                v2[3] = Doc.styled((Style)KEYWORD, (String)v3);
                v2[4] = Doc.parened((Doc)Doc.commaList((SeqLike)cmd.useHide().list().view().map(name -> name.asName().equals(name.id()) ? Doc.plain((String)name.id()) : Doc.sep((Doc[])new Doc[]{Doc.plain((String)name.id()), Doc.styled((Style)KEYWORD, (String)"as"), Doc.plain((String)name.asName())}))));
                yield Doc.sepNonEmpty((Doc[])v2);
            }
            case 4 -> {
                Command.Module mod = (Command.Module)stmt2;
                yield Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{this.visitAccess(mod.accessibility(), Stmt.Accessibility.Public), Doc.styled((Style)KEYWORD, (String)"module"), Doc.plain((String)mod.name()), Doc.symbol((String)"{")}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)mod.contents().view().map(this::stmt))), Doc.symbol((String)"}")});
            }
        };
    }

    private Stmt.Accessibility defaultAcc(@NotNull Decl.Personality personality) {
        return personality == Decl.Personality.NORMAL ? Stmt.Accessibility.Public : Stmt.Accessibility.Private;
    }

    @NotNull
    public Doc decl(@NotNull Decl predecl) {
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.StructDecl.class, TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, TeleDecl.PrimDecl.class, TeleDecl.StructField.class, TeleDecl.DataCtor.class}, (Object)decl2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ClassDecl classDecl = (ClassDecl)decl2;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 1 -> {
                TeleDecl.StructDecl decl = (TeleDecl.StructDecl)decl2;
                MutableList prelude = MutableList.of((Object)this.visitAccess(decl.accessibility(), this.defaultAcc(decl.personality())), (Object)this.visitPersonality(decl.personality()), (Object)Doc.styled((Style)KEYWORD, (String)"struct"), (Object)ConcretePrettier.linkDef(decl.ref, STRUCT), (Object)this.visitTele(decl.telescope));
                this.appendResult((MutableList<Doc>)prelude, decl.result);
                yield Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.fields.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.fields.view().map(this::decl)))})), this.visitBindBlock(decl.bindBlock)});
            }
            case 2 -> {
                TeleDecl.FnDecl decl = (TeleDecl.FnDecl)decl2;
                MutableList prelude = MutableList.of((Object)this.visitAccess(decl.accessibility(), this.defaultAcc(decl.personality())), (Object)this.visitPersonality(decl.personality()), (Object)Doc.styled((Style)KEYWORD, (String)"def"));
                prelude.appendAll((Iterable)Seq.from(decl.modifiers).view().map(this::visitModifier));
                prelude.append((Object)ConcretePrettier.linkDef(decl.ref, FN));
                prelude.append((Object)this.visitTele(decl.telescope));
                this.appendResult((MutableList<Doc>)prelude, decl.result);
                yield Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), (Doc)decl.body.fold(expr -> Doc.cat((Doc[])new Doc[]{Doc.spaced((Doc)Doc.symbol((String)"=>")), this.term(BasePrettier.Outer.Free, (Expr)expr)}), clauses -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Pattern.Clause>)clauses))})), this.visitBindBlock(decl.bindBlock)});
            }
            case 3 -> {
                TeleDecl.DataDecl decl = (TeleDecl.DataDecl)decl2;
                MutableList prelude = MutableList.of((Object)this.visitAccess(decl.accessibility(), this.defaultAcc(decl.personality())), (Object)this.visitPersonality(decl.personality()), (Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)ConcretePrettier.linkDef(decl.ref, DATA), (Object)this.visitTele(decl.telescope));
                this.appendResult((MutableList<Doc>)prelude, decl.result);
                yield Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.body.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.body.view().map(this::decl)))})), this.visitBindBlock(decl.bindBlock)});
            }
            case 4 -> {
                TeleDecl.PrimDecl decl = (TeleDecl.PrimDecl)decl2;
                yield ConcretePrettier.primDoc(decl.ref);
            }
            case 5 -> {
                TeleDecl.StructField field = (TeleDecl.StructField)decl2;
                MutableList doc = MutableList.of((Object)Doc.symbol((String)"|"), (Object)ConcretePrettier.coe(field.coerce), (Object)ConcretePrettier.linkDef(field.ref, FIELD), (Object)this.visitTele(field.telescope));
                this.appendResult((MutableList<Doc>)doc, field.result);
                field.body.ifDefined(body -> {
                    doc.append((Object)Doc.symbol((String)"=>"));
                    doc.append((Object)this.term(BasePrettier.Outer.Free, (Expr)body));
                });
                yield Doc.sepNonEmpty((SeqLike)doc);
            }
            case 6 -> {
                TeleDecl.DataCtor ctor = (TeleDecl.DataCtor)decl2;
                Doc ret = ctor.result == null ? Doc.empty() : Doc.sep((Doc[])new Doc[]{Doc.symbol((String)":"), this.term(BasePrettier.Outer.Free, ctor.result)});
                Doc doc = Doc.cblock((Doc)Doc.sepNonEmpty((Doc[])new Doc[]{ConcretePrettier.coe(ctor.coerce), ConcretePrettier.linkDef(ctor.ref, CON), this.visitTele(ctor.telescope), ret}), (int)2, (Doc)this.partial(ctor.clauses));
                if (ctor.patterns.isNotEmpty()) {
                    Doc pats = Doc.commaList((SeqLike)ctor.patterns.view().map(pattern -> this.pattern((Arg<Pattern>)pattern, BasePrettier.Outer.Free)));
                    yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.plain((String)"=>"), doc});
                }
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
            }
        };
    }

    @NotNull
    public Doc visitDoBinding(@NotNull Expr.DoBind doBind) {
        return doBind.var() == LocalVar.IGNORED ? this.term(BasePrettier.Outer.Free, doBind.expr()) : Doc.sep((Doc[])new Doc[]{ConcretePrettier.varDoc(doBind.var()), Doc.symbol((String)"<-"), this.term(BasePrettier.Outer.Free, doBind.expr())});
    }

    @NotNull
    public Doc visitPersonality(@NotNull Decl.Personality personality) {
        return switch (personality) {
            default -> throw new IncompatibleClassChangeError();
            case Decl.Personality.NORMAL -> Doc.empty();
            case Decl.Personality.EXAMPLE -> Doc.styled((Style)KEYWORD, (String)"example");
            case Decl.Personality.COUNTEREXAMPLE -> Doc.styled((Style)KEYWORD, (String)"counterexample");
        };
    }

    private Doc visitClauses(@NotNull ImmutableSeq<Pattern.Clause> clauses) {
        if (clauses.isEmpty()) {
            return Doc.empty();
        }
        return Doc.vcat((SeqLike)clauses.view().map(this::matchy).map(doc -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc})));
    }

    private void appendResult(MutableList<Doc> prelude, Expr result) {
        if (result instanceof Expr.Hole) {
            return;
        }
        prelude.append((Object)Doc.symbol((String)":"));
        prelude.append((Object)this.term(BasePrettier.Outer.Free, result));
    }

    public Doc visitBindBlock(@NotNull BindBlock bindBlock) {
        if (bindBlock == BindBlock.EMPTY) {
            return Doc.empty();
        }
        ImmutableSeq loosers = (ImmutableSeq)bindBlock.resolvedLoosers().get();
        ImmutableSeq tighters = (ImmutableSeq)bindBlock.resolvedTighters().get();
        if (loosers.isEmpty() && tighters.isEmpty()) {
            return Doc.empty();
        }
        if (loosers.isEmpty()) {
            return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"tighter"), Doc.commaList((SeqLike)tighters.view().map(BasePrettier::defVar))}))});
        }
        if (tighters.isEmpty()) {
            return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"looser"), Doc.commaList((SeqLike)loosers.view().map(BasePrettier::defVar))}))});
        }
        return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.cat((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.braced((Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"tighter"), Doc.commaList((SeqLike)tighters.view().map(BasePrettier::defVar)), Doc.styled((Style)KEYWORD, (String)"looser"), Doc.commaList((SeqLike)loosers.view().map(BasePrettier::defVar))}))}))});
    }

    @NotNull
    private Tuple2<ImmutableSeq<Expr.LetBind>, Expr> sugarLet(@NotNull Expr.Let let) {
        MutableList letBinds = MutableList.create();
        Expr letOrExpr = let;
        while (letOrExpr instanceof Expr.Let) {
            Expr.Let mLet = letOrExpr;
            letBinds.append((Object)mLet.bind());
            letOrExpr = mLet.body();
        }
        return Tuple.of((Object)letBinds.toImmutableSeq(), (Object)letOrExpr);
    }

    @NotNull
    private Doc visitLetBind(@NotNull Expr.LetBind letBind) {
        MutableList prelude = MutableList.of((Object)ConcretePrettier.varDoc(letBind.bindName()));
        if (letBind.telescope().isNotEmpty()) {
            prelude.append((Object)this.visitTele(letBind.telescope()));
        }
        this.appendResult((MutableList<Doc>)prelude, letBind.result());
        prelude.append((Object)Doc.symbol((String)":="));
        prelude.append((Object)this.term(BasePrettier.Outer.Free, letBind.definedAs()));
        return Doc.sep((SeqLike)prelude);
    }

    @NotNull
    private Doc visitModifier(@NotNull Modifier modifier) {
        return Doc.styled((Style)KEYWORD, (String)modifier.keyword);
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Pattern.BinOpSeq arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ ImmutableSeq $proxy$seq(Pattern.BinOpSeq arg0) {
        try {
            return arg0.seq();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }
}

