/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ref;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import org.aya.concrete.stmt.Decl;
import org.aya.core.def.Def;
import org.aya.core.def.GenericDef;
import org.aya.ref.AnyVar;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class DefVar<Core extends GenericDef, Concrete extends Decl>
implements AnyVar {
    @NotNull
    private final String name;
    public @UnknownNullability Concrete concrete;
    public @UnknownNullability Core core;
    @Nullable
    public ImmutableSeq<String> module;
    @Nullable
    public OpDecl opDecl;
    @NotNull
    public MutableMap<ImmutableSeq<String>, OpDecl> opDeclRename = MutableMap.create();

    @Contract(pure=true)
    @Nullable
    public Assoc assoc() {
        if (this.opDecl == null) {
            return null;
        }
        if (this.opDecl.opInfo() == null) {
            return null;
        }
        return this.opDecl.opInfo().assoc();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String name() {
        return this.name;
    }

    private DefVar(Concrete concrete, Core core, @NotNull String name) {
        this.concrete = concrete;
        this.core = core;
        this.name = name;
    }

    @NotNull
    public static <Core extends GenericDef, Concrete extends Decl> DefVar<Core, Concrete> concrete(@NotNull Concrete concrete, @NotNull String name) {
        return new DefVar<Object, Concrete>(concrete, null, name);
    }

    @NotNull
    public static <Core extends Def, Concrete extends Decl> DefVar<Core, Concrete> empty(@NotNull String name) {
        return new DefVar<Object, Object>(null, null, name);
    }

    @Nullable
    public OpDecl resolveOpDecl(@NotNull ImmutableSeq<String> moduleName) {
        return (OpDecl)this.opDeclRename.getOrDefault(moduleName, (Object)this.opDecl);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public boolean isInModule(@NotNull ImmutableSeq<String> moduleName) {
        ImmutableSeq<String> maybeSubmodule = this.module;
        if (maybeSubmodule == null) {
            return false;
        }
        if (maybeSubmodule.sizeLessThan(moduleName.size())) {
            return false;
        }
        return maybeSubmodule.sliceView(0, moduleName.size()).sameElements(moduleName);
    }

    @NotNull
    public ImmutableSeq<String> qualifiedName() {
        return this.module == null ? ImmutableSeq.of((Object)this.name) : this.module.appended((Object)this.name);
    }
}

