/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.generic.util.InterruptException;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.BindContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Context {
    public static final ImmutableSeq<String> TOP_LEVEL_MOD_NAME = ImmutableSeq.empty();

    @Nullable
    public Context parent();

    @NotNull
    public Reporter reporter();

    @NotNull
    public Path underlyingFile();

    @Nullable
    default public <T> T iterate(@NotNull @NotNull Function<@NotNull Context, @Nullable T> f) {
        for (Context p = this; p != null; p = p.parent()) {
            T result = f.apply(p);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    default public ImmutableSeq<String> moduleName() {
        Context p = this.parent();
        if (p == null) {
            return ImmutableSeq.empty();
        }
        return p.moduleName();
    }

    @Contract(value="_->fail")
    @NotNull
    default public <T> T reportAndThrow(@NotNull Problem problem) {
        this.reporter().report(problem);
        throw new ResolvingInterruptedException();
    }

    @NotNull
    default public AnyVar get(@NotNull QualifiedID name) {
        return name.isUnqualified() ? this.getUnqualified(name.justName(), name.sourcePos()) : this.getQualified(name, name.sourcePos());
    }

    @Nullable
    default public AnyVar getMaybe(@NotNull QualifiedID name) {
        return name.isUnqualified() ? this.getUnqualifiedMaybe(name.justName(), name.sourcePos()) : this.getQualifiedMaybe(name, name.sourcePos());
    }

    default public MutableList<LocalVar> collect(@NotNull MutableList<LocalVar> container) {
        return container;
    }

    @Nullable
    public AnyVar getUnqualifiedLocalMaybe(@NotNull String var1, @NotNull SourcePos var2);

    @Nullable
    default public AnyVar getUnqualifiedMaybe(@NotNull String name, @NotNull SourcePos sourcePos) {
        return this.iterate(c -> c.getUnqualifiedLocalMaybe(name, sourcePos));
    }

    @NotNull
    default public AnyVar getUnqualified(@NotNull String name, @NotNull SourcePos sourcePos) {
        AnyVar result = this.getUnqualifiedMaybe(name, sourcePos);
        if (result == null) {
            this.reportAndThrow(new NameProblem.UnqualifiedNameNotFoundError(this, name, sourcePos));
        }
        return result;
    }

    @Nullable
    public AnyVar getQualifiedLocalMaybe(@NotNull @NotNull ImmutableSeq<@NotNull String> var1, @NotNull String var2, @NotNull SourcePos var3);

    @Nullable
    default public AnyVar getQualifiedMaybe(@NotNull @NotNull ImmutableSeq<@NotNull String> modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        return this.iterate(c -> c.getQualifiedLocalMaybe(modName, name, sourcePos));
    }

    @Nullable
    default public AnyVar getQualifiedMaybe(@NotNull QualifiedID qualifiedID, @NotNull SourcePos sourcePos) {
        SeqView view = qualifiedID.ids().view();
        return this.getQualifiedMaybe((ImmutableSeq<String>)view.dropLast(1).toImmutableSeq(), (String)view.last(), sourcePos);
    }

    @NotNull
    default public AnyVar getQualified(@NotNull @NotNull ImmutableSeq<@NotNull String> modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        AnyVar result = this.getQualifiedMaybe(modName, name, sourcePos);
        if (result == null) {
            this.reportAndThrow(new NameProblem.QualifiedNameNotFoundError((Seq<String>)modName, name, sourcePos));
        }
        return result;
    }

    @NotNull
    default public AnyVar getQualified(@NotNull QualifiedID qualifiedID, @NotNull SourcePos sourcePos) {
        SeqView view = qualifiedID.ids().view();
        return this.getQualified((ImmutableSeq<String>)view.dropLast(1).toImmutableSeq(), (String)view.last(), sourcePos);
    }

    @Nullable
    public MutableMap<String, AnyVar> getModuleLocalMaybe(@NotNull ImmutableSeq<String> var1);

    @Nullable
    default public MutableMap<String, AnyVar> getModuleMaybe(@NotNull ImmutableSeq<String> modName) {
        return this.iterate(c -> c.getModuleLocalMaybe(modName));
    }

    @NotNull
    default public Context bind(@NotNull LocalVar ref, @NotNull SourcePos sourcePos, @NotNull Predicate<@Nullable AnyVar> toWarn) {
        return this.bind(ref.name(), ref, sourcePos, toWarn);
    }

    @NotNull
    default public Context bind(@NotNull LocalVar ref, @NotNull SourcePos sourcePos) {
        return this.bind(ref.name(), ref, sourcePos, var -> var instanceof LocalVar);
    }

    @NotNull
    default public Context bind(@NotNull String name, @NotNull LocalVar ref, @NotNull SourcePos sourcePos, @NotNull Predicate<@Nullable AnyVar> toWarn) {
        if (ref == LocalVar.IGNORED) {
            return this;
        }
        if (toWarn.test(this.getUnqualifiedMaybe(name, sourcePos)) && !name.startsWith("_")) {
            this.reporter().report((Problem)new NameProblem.ShadowingWarn(name, sourcePos));
        }
        return new BindContext(this, name, ref);
    }

    @NotNull
    default public PhysicalModuleContext derive(@NotNull String extraName) {
        return new PhysicalModuleContext(this, (ImmutableSeq<String>)this.moduleName().appended((Object)extraName));
    }

    @NotNull
    default public PhysicalModuleContext derive(@NotNull @NotNull Seq<@NotNull String> extraName) {
        return new PhysicalModuleContext(this, (ImmutableSeq<String>)this.moduleName().concat(extraName));
    }

    public static class ResolvingInterruptedException
    extends InterruptException {
        @Override
        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Resolving;
        }
    }
}

