/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.nio.file.Path;
import java.util.function.Function;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import org.aya.concrete.stmt.Stmt;
import org.aya.ref.AnyVar;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.NameProblem;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleContext
extends Context {
    @Override
    @NotNull
    public Context parent();

    @Override
    @NotNull
    default public Reporter reporter() {
        return this.parent().reporter();
    }

    @Override
    @NotNull
    default public Path underlyingFile() {
        return this.parent().underlyingFile();
    }

    @NotNull
    public MutableMap<String, MutableMap<Seq<String>, AnyVar>> definitions();

    @NotNull
    public MutableMap<ImmutableSeq<String>, MutableMap<String, AnyVar>> modules();

    @Override
    @Nullable
    default public AnyVar getUnqualifiedLocalMaybe(@NotNull String name, @NotNull SourcePos sourcePos) {
        MutableMap result = (MutableMap)this.definitions().getOrNull((Object)name);
        if (result == null) {
            return null;
        }
        if (result.size() == 1) {
            return (AnyVar)result.iterator().next().getValue();
        }
        MutableList disamb = MutableList.create();
        result.forEach((k, v) -> disamb.append(k));
        return (AnyVar)this.reportAndThrow(new NameProblem.AmbiguousNameError(name, (ImmutableSeq<Seq<String>>)disamb.toImmutableSeq(), sourcePos));
    }

    @Override
    @Nullable
    default public AnyVar getQualifiedLocalMaybe(@NotNull @NotNull ImmutableSeq<@NotNull String> modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        MutableMap mod = (MutableMap)this.modules().getOrNull(modName);
        if (mod == null) {
            return null;
        }
        AnyVar ref = (AnyVar)mod.getOrNull((Object)name);
        if (ref == null) {
            this.reportAndThrow(new NameProblem.QualifiedNameNotFoundError((Seq<String>)modName, name, sourcePos));
        }
        return ref;
    }

    @Override
    @Nullable
    default public MutableMap<String, AnyVar> getModuleLocalMaybe(@NotNull ImmutableSeq<String> modName) {
        return (MutableMap)this.modules().getOrNull(modName);
    }

    default public void importModules(@NotNull ImmutableSeq<String> modName, @NotNull Stmt.Accessibility accessibility, @NotNull MutableMap<ImmutableSeq<String>, MutableMap<String, AnyVar>> module, @NotNull SourcePos sourcePos) {
        module.forEach((name, mod) -> this.importModule(accessibility, sourcePos, (ImmutableSeq<String>)modName.concat((SeqLike)name), (MutableMap<String, AnyVar>)mod));
    }

    default public void importModule(@NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos, ImmutableSeq<String> componentName, MutableMap<String, AnyVar> mod) {
        MutableMap<ImmutableSeq<String>, MutableMap<String, AnyVar>> modules = this.modules();
        if (modules.containsKey(componentName)) {
            this.reportAndThrow(new NameProblem.DuplicateModNameError((Seq<String>)componentName, sourcePos));
        }
        if (this.getModuleMaybe(componentName) != null) {
            this.reporter().report((Problem)new NameProblem.ModShadowingWarn((Seq<String>)componentName, sourcePos));
        }
        modules.set(componentName, mod);
    }

    default public void openModule(@NotNull ImmutableSeq<String> modName, @NotNull Stmt.Accessibility accessibility, @NotNull Function<String, Boolean> using, @NotNull Map<String, String> rename, @NotNull SourcePos sourcePos) {
        MutableMap<String, AnyVar> mod = this.getModuleMaybe(modName);
        if (mod == null) {
            this.reportAndThrow(new NameProblem.ModNameNotFoundError((Seq<String>)modName, sourcePos));
        }
        mod.forEach((name, ref) -> {
            if (((Boolean)using.apply((String)name)).booleanValue()) {
                String newName = (String)rename.getOrDefault(name, name);
                this.addGlobal(modName, newName, accessibility, (AnyVar)ref, sourcePos);
            }
        });
    }

    default public void addGlobalSimple(@NotNull Stmt.Accessibility acc, @NotNull AnyVar ref, @NotNull SourcePos sourcePos) {
        this.addGlobal((ImmutableSeq<String>)TOP_LEVEL_MOD_NAME, ref.name(), acc, ref, sourcePos);
    }

    default public void addGlobal(@NotNull ImmutableSeq<String> modName, @NotNull String name, @NotNull Stmt.Accessibility accessibility, @NotNull AnyVar ref, @NotNull SourcePos sourcePos) {
        MutableMap<String, MutableMap<Seq<String>, AnyVar>> definitions = this.definitions();
        if (!definitions.containsKey((Object)name)) {
            if (this.getUnqualifiedMaybe(name, sourcePos) != null && !name.startsWith("_")) {
                this.reporter().report((Problem)new NameProblem.ShadowingWarn(name, sourcePos));
            }
            definitions.set((Object)name, (Object)MutableHashMap.create());
        } else if (((MutableMap)definitions.get((Object)name)).containsKey(modName)) {
            this.reportAndThrow(new NameProblem.DuplicateNameError(name, ref, sourcePos));
        } else {
            this.reporter().report((Problem)new NameProblem.AmbiguousNameWarn(name, sourcePos));
        }
        ((MutableMap)definitions.get((Object)name)).set(modName, (Object)ref);
        if (modName.equals((Object)TOP_LEVEL_MOD_NAME)) {
            ((MutableMap)this.modules().get((Object)TOP_LEVEL_MOD_NAME)).set((Object)name, (Object)ref);
        }
    }
}

