/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import org.aya.concrete.stmt.Stmt;
import org.aya.ref.AnyVar;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.error.NameProblem;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhysicalModuleContext
implements ModuleContext {
    @NotNull
    public final Context parent;
    @NotNull
    public final MutableMap<String, MutableMap<Seq<String>, AnyVar>> definitions = MutableHashMap.create();
    @NotNull
    public final MutableMap<ImmutableSeq<String>, MutableMap<String, AnyVar>> modules = MutableHashMap.of((Object)TOP_LEVEL_MOD_NAME, (Object)MutableHashMap.create());
    @NotNull
    public final MutableMap<ImmutableSeq<String>, MutableMap<String, AnyVar>> exports = MutableHashMap.of((Object)TOP_LEVEL_MOD_NAME, (Object)MutableHashMap.create());
    @NotNull
    private final ImmutableSeq<String> moduleName;
    @Nullable
    private NoExportContext exampleContext;

    @Override
    @NotNull
    public ImmutableSeq<String> moduleName() {
        return this.moduleName;
    }

    public PhysicalModuleContext(@NotNull Context parent, @NotNull ImmutableSeq<String> moduleName) {
        this.parent = parent;
        this.moduleName = moduleName;
    }

    @Override
    public void importModule(@NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos, ImmutableSeq<String> componentName, MutableMap<String, AnyVar> mod) {
        ModuleContext.super.importModule(accessibility, sourcePos, componentName, mod);
        if (accessibility == Stmt.Accessibility.Public) {
            this.exports.set(componentName, mod);
        }
    }

    @Override
    public void addGlobal(@NotNull ImmutableSeq<String> modName, @NotNull String name, @NotNull Stmt.Accessibility accessibility, @NotNull AnyVar ref, @NotNull SourcePos sourcePos) {
        ModuleContext.super.addGlobal(modName, name, accessibility, ref, sourcePos);
        if (accessibility == Stmt.Accessibility.Public) {
            if (((MutableMap)this.exports.get((Object)TOP_LEVEL_MOD_NAME)).containsKey((Object)name)) {
                this.reportAndThrow(new NameProblem.DuplicateExportError(name, sourcePos));
            } else {
                ((MutableMap)this.exports.get((Object)TOP_LEVEL_MOD_NAME)).set((Object)name, (Object)ref);
            }
        }
    }

    @NotNull
    public NoExportContext exampleContext() {
        if (this.exampleContext == null) {
            this.exampleContext = new NoExportContext(this);
        }
        return this.exampleContext;
    }

    @Override
    @NotNull
    public Context parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public MutableMap<String, MutableMap<Seq<String>, AnyVar>> definitions() {
        return this.definitions;
    }

    @Override
    @NotNull
    public MutableMap<ImmutableSeq<String>, MutableMap<String, AnyVar>> modules() {
        return this.modules;
    }
}

