/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.error;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.resolve.context.BindContext;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public interface NameProblem
extends Problem {
    @NotNull
    default public Problem.Stage stage() {
        return Problem.Stage.RESOLVE;
    }

    public record OperatorNameNotFound(@NotNull SourcePos sourcePos, @NotNull String name) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown operator"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"used in bind statement")});
        }
    }

    public record UnqualifiedNameNotFoundError(@NotNull Context context, @NotNull String name, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc head = Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"is not defined in the current scope")});
            ImmutableSeq<String> possible = this.didYouMean();
            if (possible.isEmpty()) {
                return head;
            }
            Doc tail = possible.sizeEquals(1) ? Doc.sep((Doc[])new Doc[]{Doc.english((String)"Did you mean:"), Doc.code((String)((String)possible.first()))}) : Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Did you mean:"), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)possible.view().map(n -> Doc.code((String)n))))});
            return Doc.vcat((Doc[])new Doc[]{head, tail});
        }

        @NotNull
        public ImmutableSeq<String> didYouMean() {
            Context ctx = this.context;
            while (ctx instanceof BindContext) {
                BindContext bindCtx = (BindContext)ctx;
                ctx = bindCtx.parent();
            }
            MutableList possible = MutableList.create();
            if (ctx instanceof ModuleContext) {
                ModuleContext moduleContext = (ModuleContext)ctx;
                moduleContext.modules().forEach((modName, mod) -> {
                    if (mod.containsKey((Object)this.name)) {
                        possible.append((Object)QualifiedID.join((Seq<String>)modName.appended((Object)this.name)));
                    }
                });
            }
            return possible.toImmutableSeq();
        }
    }

    public record QualifiedNameNotFoundError(@NotNull Seq<String> modName, @NotNull String name, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The qualified name"), Doc.code((Doc)Doc.cat((Doc[])new Doc[]{Doc.plain((String)QualifiedID.join(this.modName)), Doc.plain((String)"::"), Doc.plain((String)this.name)})), Doc.english((String)"is not defined in the current scope")});
        }
    }

    public record ShadowingWarn(@NotNull String name, @NotNull SourcePos sourcePos) implements Warn
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"shadows a previous local definition from outer scope")});
        }
    }

    public record ModShadowingWarn(@NotNull Seq<String> modName, @NotNull SourcePos sourcePos) implements Warn
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((Doc)Doc.plain((String)QualifiedID.join(this.modName))), Doc.english((String)"shadows a previous definition from outer scope")});
        }
    }

    public record ModNotFoundError(@NotNull Seq<String> modName, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((Doc)Doc.plain((String)QualifiedID.join(this.modName))), Doc.english((String)"is not found")});
        }
    }

    public record ModNameNotFoundError(@NotNull Seq<String> modName, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((Doc)Doc.plain((String)QualifiedID.join(this.modName))), Doc.english((String)"is not defined in the current scope")});
        }
    }

    public record DuplicateNameError(@NotNull String name, @NotNull AnyVar ref, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.plain((String)this.name), Doc.parened((Doc)Doc.code((Doc)BasePrettier.varDoc(this.ref))), Doc.english((String)"is already defined elsewhere")});
        }
    }

    public record DuplicateModNameError(@NotNull Seq<String> modName, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((Doc)Doc.plain((String)QualifiedID.join(this.modName))), Doc.english((String)"is already defined elsewhere")});
        }
    }

    public record DuplicateExportError(@NotNull String name, @NotNull SourcePos sourcePos) implements NameProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"being exported clashes with another exported definition with the same name")});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record AmbiguousNameWarn(@NotNull String name, @NotNull SourcePos sourcePos) implements Warn
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"introduces ambiguity and can only be accessed through a qualified name")})});
        }
    }

    public record AmbiguousNameError(@NotNull String name, @NotNull ImmutableSeq<Seq<String>> disambiguation, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"The unqualified name"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"is ambiguous")}), Doc.english((String)"Did you mean:"), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)this.didYouMean().map(n -> Doc.code((String)n))))});
        }

        @NotNull
        public ImmutableSeq<String> didYouMean() {
            return this.disambiguation.view().map(mod -> QualifiedID.join((Seq<String>)mod.appended((Object)this.name))).toImmutableSeq();
        }
    }

    public static interface Warn
    extends NameProblem {
        @NotNull
        default public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public static interface Error
    extends NameProblem {
        @NotNull
        default public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }
}

