/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.error.OperatorError;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.ClassDecl;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.binop.OpDecl;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface StmtResolver {
    public static void resolveStmt(@NotNull @NotNull SeqLike<@NotNull Stmt> stmt, @NotNull ResolveInfo info) {
        stmt.forEach(s -> StmtResolver.resolveStmt(s, info));
    }

    public static void resolveStmt(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Module.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Decl decl = (Decl)stmt3;
                StmtResolver.resolveDecl(decl, info);
                break;
            }
            case 1: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveStmt(mod.contents(), info);
                break;
            }
            case 2: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 3: {
                Generalize variables = (Generalize)stmt3;
                if (!1.$assertionsDisabled && variables.ctx == null) {
                    throw new AssertionError();
                }
                ExprResolver resolver = new ExprResolver(variables.ctx, ExprResolver.RESTRICTIVE);
                resolver.enterBody();
                variables.type = resolver.apply(variables.type);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(variables), resolver);
            }
        }
    }

    private static void resolveDecl(@NotNull Decl predecl, @NotNull ResolveInfo info) {
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, TeleDecl.StructDecl.class, TeleDecl.PrimDecl.class, TeleDecl.DataCtor.class, TeleDecl.StructField.class}, (Object)decl2, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                ClassDecl classDecl = (ClassDecl)decl2;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 1: {
                TeleDecl.FnDecl decl3 = (TeleDecl.FnDecl)decl2;
                ExprResolver resolver = StmtResolver.resolveDeclSignature(decl3, ExprResolver.LAX, info);
                ExprResolver bodyResolver = resolver.body();
                bodyResolver.enterBody();
                decl3.body = decl3.body.map((Function)bodyResolver, pats -> pats.map(bodyResolver::apply));
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl3), resolver);
                break;
            }
            case 2: {
                TeleDecl.DataDecl decl4 = (TeleDecl.DataDecl)decl2;
                ExprResolver resolver = StmtResolver.resolveDeclSignature(decl4, ExprResolver.LAX, info);
                resolver.enterBody();
                decl4.body.forEach(ctor -> {
                    ExprResolver bodyResolver = resolver.member(decl4);
                    bodyResolver.enterHead();
                    MutableValue mCtx = MutableValue.create((Object)resolver.ctx());
                    ctor.patterns = ctor.patterns.map(pat -> pat.descent(pattern -> ExprResolver.resolve(pattern, (MutableValue<Context>)mCtx)));
                    StmtResolver.resolveMemberSignature(ctor, bodyResolver, (MutableValue<Context>)mCtx);
                    ctor.clauses = bodyResolver.partial((Context)mCtx.get(), ctor.clauses);
                    TyckOrder.Head head = new TyckOrder.Head((TyckUnit)ctor);
                    StmtResolver.addReferences(info, (TyckOrder)head, bodyResolver);
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)ctor), (SeqView<TyckOrder>)SeqView.of((Object)head));
                });
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl4), (SeqView<TyckOrder>)resolver.reference().view().concat((SeqLike)decl4.body.map(TyckOrder.Body::new)));
                break;
            }
            case 3: {
                TeleDecl.StructDecl decl5 = (TeleDecl.StructDecl)decl2;
                ExprResolver resolver = StmtResolver.resolveDeclSignature(decl5, ExprResolver.LAX, info);
                resolver.enterBody();
                decl5.fields.forEach(field -> {
                    ExprResolver bodyResolver = resolver.member(decl5);
                    bodyResolver.enterHead();
                    MutableValue mCtx = MutableValue.create((Object)resolver.ctx());
                    StmtResolver.resolveMemberSignature(field, bodyResolver, (MutableValue<Context>)mCtx);
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head((TyckUnit)field), (SeqView<TyckOrder>)bodyResolver.reference().view().appended((Object)new TyckOrder.Head(decl5)));
                    bodyResolver.enterBody();
                    field.body = field.body.map((Function)bodyResolver.enter((Context)mCtx.get()));
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)field), bodyResolver);
                });
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl5), (SeqView<TyckOrder>)resolver.reference().view().concat((SeqLike)decl5.fields.map(TyckOrder.Body::new)));
                break;
            }
            case 4: {
                TeleDecl.PrimDecl decl6 = (TeleDecl.PrimDecl)decl2;
                StmtResolver.resolveDeclSignature(decl6, ExprResolver.RESTRICTIVE, info);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl6), (SeqView<TyckOrder>)SeqView.empty());
                break;
            }
            case 5: {
                TeleDecl.DataCtor ctor2 = (TeleDecl.DataCtor)decl2;
                break;
            }
            case 6: {
                TeleDecl.StructField structField = (TeleDecl.StructField)decl2;
            }
        }
    }

    private static <T extends Decl.Telescopic<?> & TyckUnit> void resolveMemberSignature(T ctor, ExprResolver bodyResolver, MutableValue<@NotNull Context> mCtx) {
        ctor.modifyTelescope(t -> t.map(param -> bodyResolver.resolve((Expr.Param)param, mCtx)));
        ctor.modifyResult(t -> bodyResolver.enter((Context)mCtx.get()).apply((Expr)t));
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, SeqView<TyckOrder> refs) {
        info.depGraph().sucMut((Object)decl).appendAll((Iterable)refs.filter(unit -> unit.unit().needTyck(info.thisModule().moduleName())));
        if (decl instanceof TyckOrder.Body) {
            info.depGraph().sucMut((Object)decl).append((Object)new TyckOrder.Head(decl.unit()));
        }
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, ExprResolver resolver) {
        StmtResolver.addReferences(info, decl, (SeqView<TyckOrder>)resolver.reference().view());
    }

    @NotNull
    private static ExprResolver resolveDeclSignature(@NotNull TeleDecl<?> decl, @NotNull ExprResolver.Options options, @NotNull ResolveInfo info) {
        if (!1.$assertionsDisabled && decl.ctx == null) {
            throw new AssertionError();
        }
        ExprResolver resolver = new ExprResolver(decl.ctx, options);
        resolver.enterHead();
        MutableValue mCtx = MutableValue.create((Object)decl.ctx);
        ImmutableSeq telescope = decl.telescope.map(param -> resolver.resolve((Expr.Param)param, (MutableValue<Context>)mCtx));
        ExprResolver newResolver = resolver.enter((Context)mCtx.get());
        decl.result = newResolver.apply(decl.result);
        decl.telescope = telescope.prependedAll((Iterable)newResolver.allowedGeneralizes().valuesView());
        StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl), resolver);
        return newResolver;
    }

    public static void visitBind(@NotNull DefVar<?, ?> selfDef, @NotNull BindBlock bind, @NotNull ResolveInfo info) {
        AyaBinOpSet opSet = info.opSet();
        OpDecl self = selfDef.opDecl;
        if (self == null && bind != BindBlock.EMPTY) {
            opSet.reporter.report((Problem)new OperatorError.BadBindBlock(selfDef.concrete.sourcePos(), selfDef.name()));
            throw new Context.ResolvingInterruptedException();
        }
        StmtResolver.bind(bind, opSet, self);
    }

    private static void bind(@NotNull BindBlock bindBlock, AyaBinOpSet opSet, OpDecl self) {
        if (bindBlock == BindBlock.EMPTY) {
            return;
        }
        Context ctx = (Context)bindBlock.context().get();
        if (!1.$assertionsDisabled && ctx == null) {
            throw new AssertionError((Object)"no shallow resolver?");
        }
        bindBlock.resolvedLoosers().set((Object)bindBlock.loosers().map(looser -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Looser, looser)));
        bindBlock.resolvedTighters().set((Object)bindBlock.tighters().map(tighter -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Tighter, tighter)));
    }

    @NotNull
    private static DefVar<?, ?> bind(@NotNull OpDecl self, @NotNull AyaBinOpSet opSet, @NotNull Context ctx, @NotNull OpDecl.BindPred pred, @NotNull QualifiedID id) throws Context.ResolvingInterruptedException {
        DefVar defVar;
        OpDecl opDecl;
        AnyVar anyVar = ctx.get(id);
        if (anyVar instanceof DefVar && (opDecl = (defVar = (DefVar)anyVar).resolveOpDecl(ctx.moduleName())) != null) {
            opSet.bind(self, pred, opDecl, id.sourcePos());
            return defVar;
        }
        throw StmtResolver.resolvingInterrupt(opSet.reporter, new NameProblem.OperatorNameNotFound(id.sourcePos(), id.join()));
    }

    public static void resolveBind(@NotNull @NotNull SeqLike<@NotNull Stmt> contents, @NotNull ResolveInfo info) {
        contents.forEach(s -> StmtResolver.resolveBind(s, info));
        info.opRename().forEach((k, v) -> {
            if (v._2 == BindBlock.EMPTY) {
                return;
            }
            StmtResolver.bind((BindBlock)v._2, info.opSet(), (OpDecl)v._1);
        });
    }

    public static void resolveBind(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, ClassDecl.class, TeleDecl.DataDecl.class, TeleDecl.StructDecl.class, TeleDecl.DataCtor.class, TeleDecl.StructField.class, TeleDecl.FnDecl.class, TeleDecl.PrimDecl.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveBind(mod.contents(), info);
                break;
            }
            case 1: {
                ClassDecl classDecl = (ClassDecl)stmt3;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 2: {
                TeleDecl.DataDecl decl = (TeleDecl.DataDecl)stmt3;
                decl.body.forEach(ctor -> StmtResolver.resolveBind(ctor, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 3: {
                TeleDecl.StructDecl decl = (TeleDecl.StructDecl)stmt3;
                decl.fields.forEach(field -> StmtResolver.resolveBind(field, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 4: {
                TeleDecl.DataCtor ctor2 = (TeleDecl.DataCtor)stmt3;
                StmtResolver.visitBind(ctor2.ref, ctor2.bindBlock, info);
                break;
            }
            case 5: {
                TeleDecl.StructField field2 = (TeleDecl.StructField)stmt3;
                StmtResolver.visitBind(field2.ref, field2.bindBlock, info);
                break;
            }
            case 6: {
                TeleDecl.FnDecl decl = (TeleDecl.FnDecl)stmt3;
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 7: {
                TeleDecl.PrimDecl decl = (TeleDecl.PrimDecl)stmt3;
                break;
            }
            case 8: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 9: {
                Generalize generalize = (Generalize)stmt3;
            }
        }
    }

    @Contract(value="_, _ -> fail")
    public static Context.ResolvingInterruptedException resolvingInterrupt(Reporter reporter, Problem problem) {
        reporter.report(problem);
        throw new Context.ResolvingInterruptedException();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

