/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.ClassDecl;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.GeneralizedVar;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.concrete.stmt.UseHide;
import org.aya.core.def.PrimDef;
import org.aya.generic.util.InternalException;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.error.PrimResolveError;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public record StmtShallowResolver(@NotNull ModuleLoader loader, @NotNull ResolveInfo resolveInfo) {
    public void resolveStmt(@NotNull SeqLike<Stmt> stmts, ModuleContext context) {
        stmts.forEach(stmt -> this.resolveStmt((Stmt)stmt, context));
    }

    public void resolveStmt(@NotNull Stmt stmt, @NotNull ModuleContext context) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Module.class, Command.Import.class, Command.Open.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Decl decl = (Decl)stmt3;
                this.resolveDecl(decl, context);
                break;
            }
            case 1: {
                Command.Module mod = (Command.Module)stmt3;
                PhysicalModuleContext newCtx = context.derive(mod.name());
                this.resolveStmt((SeqLike<Stmt>)mod.contents(), (ModuleContext)newCtx);
                context.importModules((ImmutableSeq<String>)ImmutableSeq.of((Object)mod.name()), mod.accessibility(), newCtx.exports, mod.sourcePos());
                break;
            }
            case 2: {
                Command.Import cmd = (Command.Import)stmt3;
                ImmutableSeq ids = cmd.path().ids();
                ResolveInfo success = this.loader.load(ids);
                if (success == null) {
                    context.reportAndThrow(new NameProblem.ModNotFoundError((Seq<String>)cmd.path().ids(), cmd.sourcePos()));
                }
                PhysicalModuleContext mod = (PhysicalModuleContext)success.thisModule();
                String as = cmd.asName();
                ImmutableSeq importedName = as != null ? ImmutableSeq.of((Object)as) : ids;
                context.importModules((ImmutableSeq<String>)importedName, Stmt.Accessibility.Private, mod.exports, cmd.sourcePos());
                this.resolveInfo.imports().put((Object)importedName, (Object)success);
                break;
            }
            case 3: {
                Command.Open cmd = (Command.Open)stmt3;
                ImmutableSeq<String> mod = cmd.path().ids();
                Stmt.Accessibility acc = cmd.accessibility();
                UseHide useHide = cmd.useHide();
                ModuleContext ctx = cmd.openExample() ? this.exampleContext(context) : context;
                ctx.openModule(mod, acc, useHide::uses, useHide.renaming(), cmd.sourcePos());
                this.resolveInfo.imports().getOption(mod).ifDefined(modResolveInfo -> {
                    if (acc == Stmt.Accessibility.Public) {
                        this.resolveInfo.reExports().put((Object)mod, (Object)useHide);
                    }
                    this.resolveInfo.open((ResolveInfo)modResolveInfo, cmd.sourcePos(), acc);
                });
                if (useHide.strategy() != UseHide.Strategy.Using) break;
                useHide.list().forEach(use -> {
                    if (use.asAssoc() == Assoc.Invalid) {
                        return;
                    }
                    AnyVar symbol = ctx.getQualifiedLocalMaybe(mod, use.id(), SourcePos.NONE);
                    assert (symbol instanceof DefVar);
                    DefVar defVar = (DefVar)symbol;
                    ResolveInfo.RenamedOpDecl renamedOpDecl = new ResolveInfo.RenamedOpDecl(new OpDecl.OpInfo(use.asName(), use.asAssoc()));
                    BindBlock bind = use.asBind();
                    if (bind != BindBlock.EMPTY) {
                        bind.context().set((Object)ctx);
                    }
                    this.resolveInfo.renameOp(defVar, renamedOpDecl, bind, true);
                });
                break;
            }
            case 4: {
                Generalize variables = (Generalize)stmt3;
                variables.ctx = context;
                for (GeneralizedVar variable : variables.variables) {
                    context.addGlobalSimple(variables.accessibility(), variable, variable.sourcePos);
                }
            }
        }
    }

    private void resolveDecl(@NotNull Decl predecl, @NotNull ModuleContext context) {
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.DataDecl.class, TeleDecl.StructDecl.class, TeleDecl.FnDecl.class, TeleDecl.PrimDecl.class, TeleDecl.DataCtor.class, TeleDecl.StructField.class}, (Object)decl2, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                ClassDecl classDecl = (ClassDecl)decl2;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 1: {
                TeleDecl.DataDecl decl3 = (TeleDecl.DataDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl3, context);
                ModuleContext innerCtx = this.resolveChildren(decl3, decl3, ctx, d -> d.body.view(), this::resolveDecl);
                this.resolveOpInfo(decl3, innerCtx);
                break;
            }
            case 2: {
                TeleDecl.StructDecl decl4 = (TeleDecl.StructDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl4, context);
                ModuleContext innerCtx = this.resolveChildren(decl4, decl4, ctx, s -> s.fields.view(), this::resolveDecl);
                this.resolveOpInfo(decl4, innerCtx);
                break;
            }
            case 3: {
                TeleDecl.FnDecl decl5 = (TeleDecl.FnDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl5, context);
                this.resolveOpInfo(decl5, ctx);
                break;
            }
            case 4: {
                Option<ImmutableSeq<PrimDef.ID>> lack;
                TeleDecl.PrimDecl decl6 = (TeleDecl.PrimDecl)decl2;
                PrimDef.Factory factory = this.resolveInfo.primFactory();
                String name = decl6.ref.name();
                SourcePos sourcePos = decl6.sourcePos;
                PrimDef.ID primID = PrimDef.ID.find(name);
                if (primID == null) {
                    context.reportAndThrow(new PrimResolveError.UnknownPrim(sourcePos, name));
                }
                if ((lack = factory.checkDependency(primID)).isNotEmpty() && ((ImmutableSeq)lack.get()).isNotEmpty()) {
                    context.reportAndThrow(new PrimResolveError.Dependency(name, (ImmutableSeq<PrimDef.ID>)((ImmutableSeq)lack.get()), sourcePos));
                } else if (factory.have(primID) && !factory.suppressRedefinition()) {
                    context.reportAndThrow(new PrimResolveError.Redefinition(name, sourcePos));
                }
                factory.factory(primID, decl6.ref);
                this.resolveTopLevelDecl(decl6, context);
                break;
            }
            case 5: {
                TeleDecl.DataCtor ctor = (TeleDecl.DataCtor)decl2;
                ctor.ref().module = context.moduleName();
                context.addGlobalSimple(Stmt.Accessibility.Public, ctor.ref, ctor.sourcePos);
                this.resolveOpInfo(ctor, context);
                break;
            }
            case 6: {
                TeleDecl.StructField field = (TeleDecl.StructField)decl2;
                field.ref().module = context.moduleName();
                context.addGlobalSimple(Stmt.Accessibility.Public, field.ref, field.sourcePos);
                this.resolveOpInfo(field, context);
            }
        }
    }

    private <D extends Decl, Child extends Decl> ModuleContext resolveChildren(@NotNull D decl, @NotNull Decl.TopLevel proof, @NotNull ModuleContext context, @NotNull Function<D, SeqView<Child>> childrenGet, @NotNull BiConsumer<Child, ModuleContext> childResolver) {
        assert (decl == proof);
        PhysicalModuleContext innerCtx = context.derive(decl.ref().name());
        SeqView children = childrenGet.apply(decl).map(child -> {
            childResolver.accept(child, innerCtx);
            return Tuple.of((Object)child.ref().name(), child.ref());
        });
        context.importModules((ImmutableSeq<String>)ImmutableSeq.of((Object)decl.ref().name()), decl.accessibility(), (MutableMap<ImmutableSeq<String>, MutableMap<String, AnyVar>>)MutableHashMap.of(Context.TOP_LEVEL_MOD_NAME, (Object)MutableHashMap.from((Iterable)children)), decl.sourcePos());
        proof.setCtx(innerCtx);
        return innerCtx;
    }

    private void resolveOpInfo(@NotNull Decl decl, @NotNull ModuleContext context) {
        BindBlock bind = decl.bindBlock();
        if (bind != BindBlock.EMPTY) {
            bind.context().set((Object)context);
        }
        if (decl.opInfo() != null) {
            DefVar<?, ?> ref = decl.ref();
            ref.opDecl = decl;
        }
    }

    @NotNull
    private <D extends Decl & Decl.TopLevel> ModuleContext resolveTopLevelDecl(@NotNull D decl, @NotNull ModuleContext context) {
        ModuleContext ctx = switch (((Decl.TopLevel)decl).personality()) {
            default -> throw new IncompatibleClassChangeError();
            case Decl.Personality.NORMAL -> context;
            case Decl.Personality.EXAMPLE -> this.exampleContext(context);
            case Decl.Personality.COUNTEREXAMPLE -> this.exampleContext(context).derive(decl.ref().name());
        };
        ((Decl.TopLevel)decl).setCtx(ctx);
        decl.ref().module = ctx.moduleName();
        ctx.addGlobalSimple(decl.accessibility(), decl.ref(), decl.sourcePos());
        return ctx;
    }

    @NotNull
    private NoExportContext exampleContext(@NotNull ModuleContext context) {
        if (context instanceof PhysicalModuleContext) {
            PhysicalModuleContext physical = (PhysicalModuleContext)context;
            return physical.exampleContext();
        }
        throw new InternalException("Invalid context: " + String.valueOf(context));
    }
}

