/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import org.aya.core.Meta;
import org.aya.core.def.PrimDef;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermConsumer;
import org.aya.core.visitor.TermFolder;
import org.aya.generic.AyaDocile;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.error.HoleProblem;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.unify.TermComparator;
import org.aya.tyck.unify.Unifier;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TyckState(@NotNull MutableList<Eqn> eqns, @NotNull MutableList<WithPos<Meta>> activeMetas, @NotNull @NotNull MutableMap<@NotNull Meta, @NotNull Term> metas, @NotNull @NotNull MutableSet<@NotNull Meta> metaNotProps, @NotNull PrimDef.Factory primFactory) {
    public TyckState(@NotNull PrimDef.Factory primFactory) {
        this((MutableList<Eqn>)MutableList.create(), (MutableList<WithPos<Meta>>)MutableList.create(), (MutableMap<Meta, Term>)MutableMap.create(), (MutableSet<Meta>)MutableSet.create(), primFactory);
    }

    public void solveEqn(@NotNull Reporter reporter, @Nullable Trace.Builder tracer, @NotNull Eqn eqn, boolean trying) {
        new Unifier(eqn.cmp, reporter, !trying, trying, tracer, this, eqn.pos, eqn.localCtx).checkEqn(eqn);
    }

    public boolean simplify(@NotNull Reporter reporter, @Nullable Trace.Builder tracer) {
        MutableList removingMetas = MutableList.create();
        for (WithPos activeMeta : this.activeMetas) {
            if (!this.metas.containsKey((Object)((Meta)activeMeta.data()))) continue;
            TermFolder.Usages usageCounter = new TermFolder.Usages((AnyVar)activeMeta.data());
            this.eqns.retainIf(eqn -> {
                if ((Integer)usageCounter.apply(eqn.lhs) + (Integer)usageCounter.apply(eqn.rhs) > 0) {
                    this.solveEqn(reporter, tracer, (Eqn)eqn, true);
                    return false;
                }
                return true;
            });
            removingMetas.append((Object)activeMeta);
        }
        this.activeMetas.removeIf(arg_0 -> ((MutableList)removingMetas).contains(arg_0));
        return removingMetas.isNotEmpty();
    }

    public void solveMetas(@NotNull Reporter reporter, @Nullable Trace.Builder traceBuilder) {
        while (this.eqns.isNotEmpty()) {
            while (this.simplify(reporter, traceBuilder)) {
            }
            ImmutableSeq eqns = this.eqns.toImmutableSeq();
            if (!eqns.isNotEmpty()) continue;
            for (Eqn eqn : eqns) {
                this.solveEqn(reporter, traceBuilder, eqn, false);
            }
            reporter.report((Problem)new HoleProblem.CannotFindGeneralSolution((ImmutableSeq<Eqn>)eqns));
        }
    }

    public void addEqn(final @NotNull Eqn eqn) {
        this.eqns.append((Object)eqn);
        int currentActiveMetas = this.activeMetas.size();
        TermConsumer consumer = new TermConsumer(){

            @Override
            public void pre(@NotNull Term tm) {
                MetaTerm hole;
                if (tm instanceof MetaTerm && !TyckState.this.metas.containsKey((Object)(hole = (MetaTerm)tm).ref())) {
                    TyckState.this.activeMetas.append((Object)new WithPos(eqn.pos, (Object)hole.ref()));
                }
                TermConsumer.super.pre(tm);
            }
        };
        consumer.accept(eqn.lhs);
        consumer.accept(eqn.rhs);
        assert (this.activeMetas.sizeGreaterThan(currentActiveMetas)) : "Adding a bad equation";
    }

    public record Eqn(@NotNull Term lhs, @NotNull Term rhs, @NotNull Ordering cmp, @NotNull SourcePos pos, @NotNull LocalCtx localCtx, @NotNull TermComparator.Sub lr, @NotNull TermComparator.Sub rl) implements AyaDocile
    {
        @Override
        @NotNull
        public Doc toDoc(@NotNull PrettierOptions options) {
            return Doc.stickySep((Doc[])new Doc[]{this.lhs.toDoc(options), Doc.symbol((String)this.cmp.symbol), this.rhs.toDoc(options)});
        }
    }
}

