/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.concrete.Expr;
import org.aya.generic.ExprProblem;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.error.TyckError;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TupleError
extends TyckError {

    public static final class ProjIxError
    extends Record
    implements ExprProblem,
    TupleError {
        @NotNull
        private final Expr.Proj expr;
        private final int actual;
        private final int expectedBound;

        public ProjIxError(@NotNull Expr.Proj expr, int actual, int expectedBound) {
            this.expr = expr;
            this.actual = actual;
            this.expectedBound = expectedBound;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Cannot project the"), Doc.ordinal((int)this.actual), Doc.english((String)"element because the type has index range"), Doc.plain((String)("[1, " + this.expectedBound + "]"))});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProjIxError.class, "expr;actual;expectedBound", "expr", "actual", "expectedBound"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProjIxError.class, "expr;actual;expectedBound", "expr", "actual", "expectedBound"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProjIxError.class, "expr;actual;expectedBound", "expr", "actual", "expectedBound"}, this, o);
        }

        @Override
        @NotNull
        public Expr.Proj expr() {
            return this.expr;
        }

        public int actual() {
            return this.actual;
        }

        public int expectedBound() {
            return this.expectedBound;
        }
    }

    public record ElemMismatchError(@NotNull SourcePos sourcePos, int expected, int supplied) implements TupleError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Expected"), Doc.plain((String)String.valueOf(this.expected)), Doc.english((String)"elements in the tuple, but found"), Doc.plain((String)String.valueOf(this.supplied))});
        }
    }
}

