/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.term.Term;
import org.aya.generic.ExprProblem;
import org.aya.generic.util.NormalizeMode;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.TyckError;
import org.aya.tyck.unify.TermComparator;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public interface UnifyError
extends TyckError {
    @NotNull
    public TyckState state();

    @NotNull
    public TermComparator.FailureData failureData();

    @NotNull
    default public Doc describeUnify(@NotNull PrettierOptions options, @NotNull Doc prologue, @NotNull Term actual, @NotNull Doc epilogue, @NotNull Term expected) {
        Doc actualDoc = actual.toDoc(options);
        Doc expectedDoc = expected.toDoc(options);
        Doc actualNFDoc = this.nf(actual).toDoc(options);
        Doc expectedNFDoc = this.nf(expected).toDoc(options);
        MutableList buf = MutableList.of((Object)prologue);
        UnifyError.compareExprs(epilogue, actualDoc, expectedDoc, actualNFDoc, expectedNFDoc, (MutableList<Doc>)buf);
        Term failureTermL = this.failureData().lhs();
        Term failureTermR = this.failureData().rhs();
        Doc failureLhs = failureTermL.toDoc(options);
        if (!(failureLhs.equals((Object)actualDoc) || failureLhs.equals((Object)expectedDoc) || failureLhs.equals((Object)actualNFDoc) || failureLhs.equals((Object)expectedNFDoc))) {
            buf.append((Object)Doc.english((String)"In particular, we failed to unify"));
            UnifyError.compareExprs(Doc.plain((String)"with"), failureLhs, failureTermR.toDoc(options), this.nf(failureTermL).toDoc(options), this.nf(failureTermR).toDoc(options), (MutableList<Doc>)buf);
        }
        return Doc.vcat((SeqLike)buf);
    }

    @NotNull
    private Term nf(Term failureTermL) {
        return failureTermL.normalize(this.state(), NormalizeMode.NF);
    }

    private static void compareExprs(@NotNull Doc mid, Doc actualDoc, Doc expectedDoc, Doc actualNFDoc, Doc expectedNFDoc, MutableList<@NotNull Doc> buf) {
        buf.append((Object)Doc.par((int)1, (Doc)actualDoc));
        if (!actualNFDoc.equals((Object)actualDoc)) {
            buf.append((Object)Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), actualNFDoc}))));
        }
        buf.append((Object)mid);
        buf.append((Object)Doc.par((int)1, (Doc)expectedDoc));
        if (!expectedNFDoc.equals((Object)expectedDoc)) {
            buf.append((Object)Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), expectedNFDoc}))));
        }
    }

    public record ConReturn(@NotNull TeleDecl.DataCtor ctor, @NotNull Term expected, @NotNull Term actual, @NotNull TermComparator.FailureData failureData, @NotNull TyckState state) implements UnifyError
    {
        @NotNull
        public SourcePos sourcePos() {
            return this.ctor.sourcePos;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc prologue = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot make sense of the return type of the constructor"), Doc.par((int)1, (Doc)this.ctor.toDoc(options)), Doc.english((String)"which eventually returns")});
            return this.describeUnify(options, prologue, this.actual, Doc.english((String)"while it should return"), this.expected);
        }
    }

    public record Type(@NotNull Expr expr, @NotNull Term expected, @NotNull Term actual, @NotNull TermComparator.FailureData failureData, @NotNull TyckState state) implements ExprProblem,
    UnifyError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc prologue = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot check the expression"), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.english((String)"of type")});
            return this.describeUnify(options, prologue, this.actual, Doc.english((String)"against the type"), this.expected);
        }
    }
}

