/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.def.CtorDef;
import org.aya.core.term.DataCall;
import org.aya.core.term.Term;
import org.aya.generic.util.NormalizeMode;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.UnifyError;
import org.aya.tyck.pat.PatClassifier;
import org.aya.tyck.unify.TermComparator;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClausesProblem
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @NotNull
    private static Doc termToHint(@Nullable Term term, @NotNull PrettierOptions options) {
        return term == null ? Doc.empty() : Doc.sep((Doc[])new Doc[]{Doc.english((String)"substituted to"), Doc.code((Doc)term.toDoc(options))});
    }

    public record FMDomination(int sub, @NotNull SourcePos sourcePos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.sub), Doc.english((String)"clause is dominated by the other clauses, hence unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record Domination(int dom, int sub, @NotNull SourcePos sourcePos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc subOrdinal = Doc.ordinal((int)this.sub);
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.dom), Doc.english((String)"clause dominates the"), subOrdinal, Doc.english((String)"clause. The"), subOrdinal, Doc.english((String)"clause will be unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record UnsureCase(@NotNull SourcePos sourcePos, @NotNull CtorDef ctor, @NotNull DataCall dataCall) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"I'm unsure if there should be a case for constructor"), Doc.par((int)1, (Doc)this.ctor.toDoc(options)), Doc.english((String)"because I got stuck on the index unification of type"), Doc.par((int)1, (Doc)this.dataCall.toDoc(options))});
        }
    }

    public record MissingCase(@NotNull SourcePos sourcePos, @NotNull PatClassifier.PatErr pats) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unhandled case:"), BasePrettier.argsDoc(options, this.pats.missing())});
        }
    }

    public record Confluence(@NotNull SourcePos sourcePos, int i, int j, @NotNull Term lhs, @NotNull Term rhs, @NotNull TyckState state, @NotNull TermComparator.FailureData failureData, @NotNull SourcePos iPos, @NotNull SourcePos jPos) implements ClausesProblem,
    UnifyError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc line = Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.i), Doc.english((String)"and the"), Doc.ordinal((int)this.j), Doc.english((String)"clauses are not confluent because we failed to unify")});
            return this.describeUnify(options, line, this.lhs, Doc.plain((String)"and"), this.rhs);
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return ClausesProblem.super.level();
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull PrettierOptions options) {
            return Seq.of((Object)new WithPos(this.iPos, (Object)ClausesProblem.termToHint(this.lhs, options)), (Object)new WithPos(this.jPos, (Object)ClausesProblem.termToHint(this.rhs, options))).view();
        }
    }

    public record Conditions(@NotNull SourcePos sourcePos, @NotNull CondData data, @Nullable Term rhs, @Nullable SourcePos jPos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc result = this.rhs != null ? Doc.sep((Doc[])new Doc[]{Doc.plain((String)"unify"), Doc.code((Doc)this.data.lhs.toDoc(options)), Doc.plain((String)"and"), Doc.code((Doc)this.rhs.toDoc(options))}) : Doc.english((String)"find any of the clause(s) to check condition");
            Doc line = Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.data.i), Doc.english((String)"clause matches on a constructor with condition(s). When checking the"), Doc.ordinal((int)this.data.j), Doc.english((String)"condition, we failed to"), result, Doc.english((String)"for the arguments:")});
            return Doc.vcat((Doc[])new Doc[]{line, Doc.par((int)1, (Doc)BasePrettier.argsDoc(options, this.data.args)), Doc.english((String)"Normalized:"), Doc.par((int)1, (Doc)BasePrettier.argsDoc(options, this.data.args.map(a -> a.descent(t -> t.normalize(this.data.state, NormalizeMode.NF)))))});
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull PrettierOptions options) {
            SeqView view = Seq.of((Object)new WithPos(this.data.iPos, (Object)ClausesProblem.termToHint(this.data.lhs, options))).view();
            return this.rhs == null || this.jPos == null ? view : view.concat((SeqLike)Seq.of((Object)new WithPos(this.jPos, (Object)ClausesProblem.termToHint(this.rhs, options))));
        }
    }

    public record CondData(int i, int j, @NotNull ImmutableSeq<Arg<Term>> args, @NotNull Term lhs, @NotNull TyckState state, @NotNull SourcePos iPos) {
    }
}

