/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.core.def.CtorDef;
import org.aya.core.def.Def;
import org.aya.core.pat.Pat;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.AyaRestrSimplifier;
import org.aya.core.visitor.Expander;
import org.aya.core.visitor.Subst;
import org.aya.generic.AyaDocile;
import org.aya.guest0x0.cubical.CofThy;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.LocalVar;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.env.MapLocalCtx;
import org.aya.tyck.pat.ClausesProblem;
import org.aya.util.Arg;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record Conquer(@NotNull ImmutableSeq<Term.Matching> matchings, @NotNull SourcePos sourcePos, @NotNull Def.Signature<?> signature, boolean orderIndependent, @NotNull ExprTycker tycker) {
    public static void against(@NotNull ImmutableSeq<Term.Matching> matchings, boolean orderIndependent, @NotNull ExprTycker tycker, @NotNull SourcePos pos, @NotNull Def.Signature<?> signature) {
        Conquer conquer = new Conquer(matchings, pos, signature, orderIndependent, tycker);
        int size = matchings.size();
        for (int i = 0; i < size; ++i) {
            Term.Matching matching = (Term.Matching)matchings.get(i);
            for (Arg pat : matching.patterns()) {
                conquer.visit((Pat)pat.term(), i);
            }
        }
    }

    public void visit(@NotNull Pat pat, int nth) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Ctor.class, Pat.Tuple.class}, (Object)pat3, n)) {
            case 0: {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                ImmutableSeq<Arg<Pat>> params = ctor.params();
                for (Arg sub : params) {
                    this.visit((Pat)sub.term(), nth);
                }
                CtorDef ctorDef = (CtorDef)ctor.ref().core;
                assert (ctorDef.selfTele.sizeEquals(params));
                Subst subst = new Subst((SeqLike<LocalVar>)ctorDef.selfTele.view().map(Term.Param::ref), (SeqLike<? extends Term>)params.view().map(t -> ((Pat)t.term()).toTerm()));
                Partial.Split clauses = (Partial.Split)AyaRestrSimplifier.INSTANCE.mapSplit(ctorDef.clauses, t -> t.subst(subst));
                ImmutableSeq faces = clauses.clauses();
                int size = faces.size();
                for (int i = 0; i < size; ++i) {
                    this.checkConditions(nth, i + 1, (Restr.Side<Term>)((Restr.Side)faces.get(i)), subst);
                }
                break;
            }
            case 1: {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                for (Arg sub : tuple.pats()) {
                    this.visit((Pat)sub.term(), nth);
                }
                break;
            }
        }
    }

    private void checkConditions(int nth, int i, Restr.Side<Term> condition, Subst matchy) {
        MapLocalCtx ctx = new MapLocalCtx();
        Term.Matching currentClause = (Term.Matching)this.matchings.get(nth);
        CofThy.conv((Restr.Conj)condition.cof(), (CofThy.SubstObj)matchy, subst -> {
            ErrorTerm error;
            AyaDocile patt3745$temp;
            Term newBody = currentClause.body().subst((Subst)subst);
            ImmutableSeq args = Arg.mapSeq(currentClause.patterns(), t -> t.toTerm().subst((Subst)subst));
            Option matchResult = new Expander.WHNFer(this.tycker.state).tryUnfoldClauses(this.orderIndependent, (ImmutableSeq<Arg<Term>>)args, 0, this.matchings).map(w -> w.map(t -> t.subst((Subst)subst)));
            currentClause.patterns().forEach(p -> ((Pat)p.term()).storeBindings(ctx, (Subst)subst));
            ClausesProblem.CondData errorData = new ClausesProblem.CondData(nth + 1, i, (ImmutableSeq<Arg<Term>>)args, newBody, this.tycker.state, currentClause.sourcePos());
            if (matchResult.isEmpty()) {
                this.tycker.reporter.report((Problem)new ClausesProblem.Conditions(this.sourcePos, errorData, null, null));
                return true;
            }
            WithPos anotherClause = (WithPos)matchResult.get();
            if (newBody instanceof ErrorTerm && (patt3745$temp = (error = (ErrorTerm)newBody).description()) instanceof MetaTerm) {
                MetaTerm hole = (MetaTerm)patt3745$temp;
                hole.ref().conditions.append((Object)Tuple.of((Object)matchy, (Object)((Term)anotherClause.data())));
            } else {
                ErrorTerm error2;
                AyaDocile patt3941$temp;
                Object patt3891$temp = anotherClause.data();
                if (patt3891$temp instanceof ErrorTerm && (patt3941$temp = (error2 = (ErrorTerm)patt3891$temp).description()) instanceof MetaTerm) {
                    MetaTerm hole = (MetaTerm)patt3941$temp;
                    hole.ref().conditions.append((Object)Tuple.of((Object)matchy, (Object)newBody));
                }
            }
            boolean unification = this.tycker.unifier(this.sourcePos, Ordering.Eq, ctx).compare(newBody, (Term)anotherClause.data(), this.signature.result().subst(matchy));
            if (!unification) {
                this.tycker.reporter.report((Problem)new ClausesProblem.Conditions(this.sourcePos, errorData, (Term)anotherClause.data(), anotherClause.sourcePos()));
            }
            return unification;
        });
    }
}

