/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import kala.control.Result;
import kala.tuple.Tuple;
import kala.tuple.Tuple3;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.concrete.visitor.PatternConsumer;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.pat.Pat;
import org.aya.core.pat.PatMatcher;
import org.aya.core.repr.AyaShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.ConCall;
import org.aya.core.term.DataCall;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.MetaPatTerm;
import org.aya.core.term.SigmaTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.DeltaExpander;
import org.aya.core.visitor.EndoTerm;
import org.aya.core.visitor.Expander;
import org.aya.core.visitor.Subst;
import org.aya.generic.AyaDocile;
import org.aya.generic.util.InternalException;
import org.aya.generic.util.NormalizeMode;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.GenerateKind;
import org.aya.ref.LocalVar;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.TyckState;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.error.TyckOrderError;
import org.aya.tyck.pat.PatClassifier;
import org.aya.tyck.pat.PatternProblem;
import org.aya.tyck.pat.TypedSubst;
import org.aya.tyck.trace.Trace;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.tyck.MCT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class PatTycker {
    public static final EndoTerm META_PAT_INLINER = new EndoTerm(){

        @Override
        @NotNull
        public Term post(@NotNull Term term) {
            Term term2;
            if (term instanceof MetaPatTerm) {
                MetaPatTerm metaPat = (MetaPatTerm)term;
                term2 = metaPat.inline(this);
            } else {
                term2 = term;
            }
            return term2;
        }
    };
    @NotNull
    public final ExprTycker exprTycker;
    @NotNull
    private final TypedSubst patSubst;
    @NotNull
    private final TypedSubst sigSubst;
    private boolean hasError = false;

    public PatTycker(@NotNull ExprTycker exprTycker, @NotNull TypedSubst patSubst, @NotNull TypedSubst sigSubst) {
        this.exprTycker = exprTycker;
        this.patSubst = patSubst;
        this.sigSubst = sigSubst;
    }

    public PatTycker(@NotNull ExprTycker exprTycker) {
        this(exprTycker, new TypedSubst(), new TypedSubst());
    }

    @NotNull
    public static PatResult elabClausesDirectly(@NotNull ExprTycker exprTycker, @NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature<?> signature) {
        return PatTycker.checkAllRhs(exprTycker, PatTycker.checkAllLhs(exprTycker, clauses, signature), signature.result());
    }

    @NotNull
    public static PatResult elabClausesClassified(@NotNull ExprTycker exprTycker, @NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature<?> signature, @NotNull SourcePos overallPos) {
        AllLhsResult lhsResults = PatTycker.checkAllLhs(exprTycker, clauses, signature);
        if (!lhsResults.hasError()) {
            MCT<Term, PatClassifier.PatErr> classes = PatClassifier.classify(lhsResults.lhsResult().view().map(LhsResult::preclause), signature.param(), exprTycker, overallPos);
            if (clauses.isNotEmpty()) {
                int[] nArray = PatClassifier.firstMatchDomination(clauses, exprTycker.reporter, classes);
            }
        }
        return PatTycker.checkAllRhs(exprTycker, lhsResults, signature.result());
    }

    @NotNull
    private static AllLhsResult checkAllLhs(@NotNull ExprTycker exprTycker, @NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature<?> signature) {
        Boolean inProp = exprTycker.localCtx.with(() -> exprTycker.isPropType((Term)signature.result()), (SeqView<Term.Param>)signature.param().view());
        return new AllLhsResult((ImmutableSeq<LhsResult>)clauses.mapIndexed((index, clause) -> exprTycker.traced(() -> new Trace.LabelT(clause.sourcePos, "lhs of clause " + (1 + index)), () -> PatTycker.checkLhs(exprTycker, clause, signature, inProp, true))));
    }

    @NotNull
    private static PatResult checkAllRhs(@NotNull ExprTycker exprTycker, @NotNull AllLhsResult lhsResult, @NotNull Term result) {
        ImmutableSeq<LhsResult> clauses = lhsResult.lhsResult();
        ImmutableSeq res = clauses.mapIndexed((index, lhs) -> exprTycker.traced(() -> new Trace.LabelT(lhs.preclause.sourcePos(), "rhs of clause " + (1 + index)), () -> PatTycker.checkRhs(exprTycker, lhs)));
        ImmutableSeq preclauses = res.map(c -> new Pat.Preclause(c.sourcePos(), (ImmutableSeq<Arg<Pat>>)c.patterns().map(p -> p.descent(x -> x.zonk(exprTycker))), c.expr().map(exprTycker::zonk)));
        return new PatResult(exprTycker.zonk(result), (ImmutableSeq<Pat.Preclause<Term>>)preclauses, (ImmutableSeq<Term.Matching>)preclauses.flatMap(Pat.Preclause::lift), lhsResult.hasError());
    }

    @NotNull
    public static LhsResult checkLhs(@NotNull ExprTycker exprTycker, @NotNull Pattern.Clause match, @NotNull Def.Signature<?> signature, boolean inProp, boolean isElim) {
        PatTycker patTycker = new PatTycker(exprTycker);
        return exprTycker.subscoped(() -> {
            if (isElim && !match.patterns.anyMatch(p -> patTycker.hasAbsurdity((Pattern)p.term())) && match.expr.isEmpty()) {
                patTycker.foundError(new PatternProblem.InvalidEmptyBody(match));
            }
            VisitPatterns step0 = patTycker.visitPatterns(signature, (SeqView<Arg<Pattern>>)match.patterns.view(), null, (Expr)match.expr.getOrNull(), inProp);
            match.hasError = patTycker.hasError;
            ImmutableSeq patterns = step0.wellTyped.map(p -> p.descent(x -> x.inline(exprTycker.localCtx))).toImmutableSeq();
            patTycker.patSubst.inline();
            patTycker.sigSubst.inline();
            Term type = PatTycker.inlineTerm(step0.codomain);
            exprTycker.localCtx.modifyMyTerms(META_PAT_INLINER);
            PatternConsumer consumer = new PatternConsumer(){

                @Override
                public void pre(@NotNull Pattern pat) {
                    Pattern pattern = pat;
                    Objects.requireNonNull(pattern);
                    Pattern pattern2 = pattern;
                    int n = 0;
                    MutableValue<Term> typeRef = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Bind.class, Pattern.As.class}, (Object)pattern2, n)) {
                        case 0 -> {
                            Pattern.Bind bind = (Pattern.Bind)pattern2;
                            yield bind.type();
                        }
                        case 1 -> {
                            Pattern.As as = (Pattern.As)pattern2;
                            yield as.type();
                        }
                        default -> MutableValue.create();
                    };
                    typeRef.update(t -> t == null ? null : PatTycker.inlineTerm(t));
                    PatternConsumer.super.pre(pat);
                }
            };
            match.patterns.view().map(Arg::term).forEach((consumer)::accept);
            return new LhsResult(exprTycker.localCtx, type, patTycker.allSubst(), patTycker.hasError, new Pat.Preclause<Expr>(match.sourcePos, (ImmutableSeq<Arg<Pat>>)patterns, Option.ofNullable((Object)step0.newBody)));
        });
    }

    private static Pat.Preclause<Term> checkRhs(@NotNull ExprTycker exprTycker, @NotNull LhsResult lhsResult) {
        return exprTycker.subscoped(() -> {
            exprTycker.localCtx = lhsResult.gamma;
            Option term = exprTycker.withSubSubst(() -> {
                exprTycker.lets.addDirectly(lhsResult.bodySubst());
                return lhsResult.preclause.expr().map(e -> lhsResult.hasError ? new ErrorTerm((AyaDocile)e, false) : exprTycker.check((Expr)e, lhsResult.type).wellTyped());
            });
            return new Pat.Preclause(lhsResult.preclause.sourcePos(), lhsResult.preclause.patterns(), term);
        });
    }

    private void addPatSubst(@NotNull AnyVar var, @NotNull Pat pat, @NotNull Term type) {
        this.patSubst.addDirectly(var, pat.toTerm(), type);
    }

    private void addSigSubst(@NotNull Term.Param param, @NotNull Pat pat) {
        this.sigSubst.addDirectly(param.ref(), pat.toTerm(), param.type());
    }

    private boolean hasAbsurdity(@NotNull Pattern pattern) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Absurd.class, Pattern.As.class, Pattern.BinOpSeq.class, Pattern.Ctor.class, Pattern.List.class, Pattern.Tuple.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.Absurd ignored = (Pattern.Absurd)pattern3;
                yield true;
            }
            case 1 -> {
                Pattern.As as = (Pattern.As)pattern3;
                yield this.hasAbsurdity(as.pattern());
            }
            case 2 -> {
                Pattern.BinOpSeq binOpSeq = (Pattern.BinOpSeq)pattern3;
                yield binOpSeq.seq().anyMatch(p -> this.hasAbsurdity((Pattern)p.term()));
            }
            case 3 -> {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                yield ctor.params().anyMatch(p -> this.hasAbsurdity((Pattern)p.term()));
            }
            case 4 -> {
                Pattern.List list = (Pattern.List)pattern3;
                yield list.elements().anyMatch(this::hasAbsurdity);
            }
            case 5 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                yield tuple.patterns().anyMatch(p -> this.hasAbsurdity((Pattern)p.term()));
            }
            default -> false;
        };
    }

    @NotNull
    private Pat doTyck(@NotNull Pattern pattern, @NotNull Term term, boolean resultIsProp) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Absurd.class, Pattern.Tuple.class, Pattern.Ctor.class, Pattern.Bind.class, Pattern.CalmFace.class, Pattern.Number.class, Pattern.List.class, Pattern.As.class, Pattern.QualifiedRef.class, Pattern.BinOpSeq.class}, (Object)pattern3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pattern.Absurd absurd = (Pattern.Absurd)pattern3;
                Tuple3<DataCall, Subst, ConCall.Head> selection = this.selectCtor(term, null, absurd);
                if (selection != null) {
                    this.foundError(new PatternProblem.PossiblePat(absurd, (ConCall.Head)selection._3));
                }
                yield new Pat.Absurd();
            }
            case 1 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                Term var9_9 = term.normalize(this.exprTycker.state, NormalizeMode.WHNF);
                if (!(var9_9 instanceof SigmaTerm)) {
                    yield this.withError(new PatternProblem.TupleNonSig(tuple, term), term);
                }
                SigmaTerm sigma = (SigmaTerm)var9_9;
                boolean tupleIsProp = this.exprTycker.isPropType(sigma);
                if (!resultIsProp && tupleIsProp) {
                    this.foundError(new PatternProblem.IllegalPropPat(tuple));
                }
                Def.Signature<ErrorTerm> sig = new Def.Signature<ErrorTerm>(sigma.params(), new ErrorTerm(Doc.plain((String)"Rua"), false));
                yield new Pat.Tuple((ImmutableSeq<Arg<Pat>>)this.visitInnerPatterns(sig, (SeqView<Arg<Pattern>>)tuple.patterns().view(), tuple, resultIsProp).wellTyped().toImmutableSeq());
            }
            case 2 -> {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                AnyVar var = (AnyVar)ctor.resolved().data();
                Tuple3<DataCall, Subst, ConCall.Head> realCtor = this.selectCtor(term, var, ctor);
                if (realCtor == null) {
                    yield this.randomPat(term);
                }
                DefVar<CtorDef, TeleDecl.DataCtor> ctorRef = ((ConCall.Head)realCtor._3).ref();
                boolean dataIsProp = ((CtorDef)ctorRef.core).inProp();
                if (!resultIsProp && dataIsProp) {
                    this.foundError(new PatternProblem.IllegalPropPat(ctor));
                }
                CtorDef ctorCore = (CtorDef)ctorRef.core;
                DataCall dataCall = (DataCall)realCtor._1;
                Def.Signature<DataCall> sig = new Def.Signature<DataCall>(Term.Param.subst((ImmutableSeq<Term.Param>)ctorCore.selfTele, (Subst)realCtor._2, 0), dataCall);
                ImmutableSeq patterns2 = this.visitInnerPatterns(sig, (SeqView<Arg<Pattern>>)ctor.params().view(), (Pattern)ctor, (boolean)resultIsProp).wellTyped.toImmutableSeq();
                yield new Pat.Ctor(((ConCall.Head)realCtor._3).ref(), (ImmutableSeq<Arg<Pat>>)patterns2, dataCall);
            }
            case 3 -> {
                Object ctorCore;
                SourcePos pos = ctorCore = PatTycker.$proxy$sourcePos((Pattern.Bind)pattern3);
                Object bind = ctorCore = PatTycker.$proxy$bind((Pattern.Bind)pattern3);
                Object tyExpr = ctorCore = PatTycker.$proxy$userType((Pattern.Bind)pattern3);
                Object tyRef = ctorCore = PatTycker.$proxy$type((Pattern.Bind)pattern3);
                this.exprTycker.localCtx.put((LocalVar)bind, term);
                if (tyExpr != null) {
                    this.exprTycker.withSubSubst(() -> this.lambda$doTyck$20((Expr)tyExpr, term));
                }
                tyRef.set((Object)term);
                yield new Pat.Bind((LocalVar)bind, term);
            }
            case 4 -> {
                SourcePos dataCall;
                SourcePos pos = dataCall = PatTycker.$proxy$sourcePos((Pattern.CalmFace)pattern3);
                yield new Pat.Meta((MutableValue<Pat>)MutableValue.create(), new LocalVar("_", pos, GenerateKind.Anonymous.INSTANCE), term);
            }
            case 5 -> {
                SourcePos patterns2;
                SourcePos pos = patterns2 = PatTycker.$proxy$sourcePos((Pattern.Number)pattern3);
                int patterns2 = PatTycker.$proxy$number((Pattern.Number)pattern3);
                int number = patterns2;
                Term ty = term.normalize(this.exprTycker.state, NormalizeMode.WHNF);
                if (ty instanceof DataCall) {
                    DataCall dataCall = (DataCall)ty;
                    DataDef data = (DataDef)((DefVar)dataCall.ref()).core;
                    Option<ShapeRecognition> shape = this.exprTycker.shapeFactory.find(data);
                    if (shape.isDefined() && ((ShapeRecognition)shape.get()).shape() == AyaShape.NAT_SHAPE) {
                        yield new Pat.ShapedInt(number, (ShapeRecognition)shape.get(), dataCall);
                    }
                }
                yield this.withError(new PatternProblem.BadLitPattern(pattern, term), term);
            }
            case 6 -> {
                SourcePos data;
                SourcePos pos = data = PatTycker.$proxy$sourcePos((Pattern.List)pattern3);
                SourcePos el = data = PatTycker.$proxy$elements((Pattern.List)pattern3);
                Term ty = term.normalize(this.exprTycker.state, NormalizeMode.WHNF);
                if (ty instanceof DataCall) {
                    DataCall dataCall = (DataCall)ty;
                    DataDef data = (DataDef)((DefVar)dataCall.ref()).core;
                    Option<ShapeRecognition> shape = this.exprTycker.shapeFactory.find(data);
                    if (shape.isDefined() && ((ShapeRecognition)shape.get()).shape() == AyaShape.LIST_SHAPE) {
                        yield this.doTyck((Pattern)new Pattern.FakeShapedList(pos, (ImmutableSeq<Pattern>)el, (ShapeRecognition)shape.get(), dataCall).constructorForm(), term, resultIsProp);
                    }
                }
                yield this.withError(new PatternProblem.BadLitPattern(pattern, term), term);
            }
            case 7 -> {
                Object var22_47;
                SourcePos pos = var22_47 = PatTycker.$proxy$sourcePos((Pattern.As)pattern3);
                Object inner = var22_47 = PatTycker.$proxy$pattern((Pattern.As)pattern3);
                Object as = var22_47 = PatTycker.$proxy$as((Pattern.As)pattern3);
                Object type = var22_47 = PatTycker.$proxy$type((Pattern.As)pattern3);
                Pat innerPat = this.doTyck((Pattern)inner, term, resultIsProp);
                type.set((Object)term);
                this.addPatSubst((AnyVar)as, innerPat, term);
                yield innerPat;
            }
            case 8 -> {
                Pattern.QualifiedRef ignored = (Pattern.QualifiedRef)pattern3;
                throw new InternalException("QualifiedRef patterns should be desugared");
            }
            case 9 -> {
                Pattern.BinOpSeq ignored = (Pattern.BinOpSeq)pattern3;
                throw new InternalException("BinOpSeq patterns should be desugared");
            }
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    private VisitPatterns visitPatterns(@NotNull Def.Signature<?> sig, @NotNull SeqView<Arg<Pattern>> stream, @Nullable Pattern outerPattern, @Nullable Expr body, boolean resultIsProp) {
        results = MutableList.create();
        lastPat = null;
        while (sig.param().isNotEmpty()) {
            param = (Term.Param)sig.param().first();
            if (!stream.isEmpty()) ** GOTO lbl27
            if (!(body instanceof Expr.Lambda)) ** GOTO lbl-1000
            lamPos = var13_13 /* !! */  = PatTycker.$proxy$sourcePos((Expr.Lambda)body);
            var13_13 /* !! */  = PatTycker.$proxy$param((Expr.Lambda)body);
            lamParam = var13_13 /* !! */ ;
            lamBody /* !! */  = var13_13 /* !! */  = PatTycker.$proxy$body((Expr.Lambda)body);
            if (lamParam.explicit() == param.explicit()) {
                body = lamBody /* !! */ ;
                pattern = new Pattern.Bind(lamPos, lamParam.ref(), lamParam.type(), (MutableValue<Term>)MutableValue.create());
                pat = new Arg((Object)pattern, param.explicit());
            } else lbl-1000:
            // 2 sources

            {
                if (param.explicit()) {
                    if (lastPat == null) {
                        if (!PatTycker.$assertionsDisabled && outerPattern == null) {
                            throw new AssertionError();
                        }
                        errorPattern = outerPattern;
                    } else {
                        errorPattern = (Pattern)lastPat.term();
                    }
                    this.foundError(new PatternProblem.InsufficientPattern(errorPattern, param));
                    return this.done((SeqLike<Arg<Pat>>)results, (Term)sig.result(), body);
                }
                sig = this.generatePat(new PatData(sig, (MutableList<Arg<Pat>>)results, param));
                continue;
lbl27:
                // 1 sources

                if (param.explicit()) {
                    lastPat = pat = (Arg)stream.first();
                    stream = stream.drop(1);
                    if (!pat.explicit()) {
                        this.foundError(new PatternProblem.TooManyImplicitPattern((Pattern)pat.term(), param));
                        return this.done((SeqLike<Arg<Pat>>)results, (Term)sig.result(), body);
                    }
                } else {
                    pat = (Arg)stream.first();
                    if (pat.explicit()) {
                        sig = this.generatePat(new PatData(sig, (MutableList<Arg<Pat>>)results, param));
                        continue;
                    }
                    lastPat = pat;
                    stream = stream.drop(1);
                }
            }
            sig = this.updateSig(new PatData(sig, (MutableList<Arg<Pat>>)results, param), (Arg<Pattern>)pat, resultIsProp);
        }
        if (stream.isNotEmpty()) {
            this.foundError(new PatternProblem.TooManyPattern((Pattern)((Arg)stream.first()).term(), sig.result().freezeHoles(this.exprTycker.state)));
        }
        return this.done((SeqLike<Arg<Pat>>)results, (Term)sig.result(), body);
    }

    @NotNull
    private VisitPatterns visitInnerPatterns(@NotNull Def.Signature<?> sig, @NotNull SeqView<Arg<Pattern>> stream, @NotNull Pattern outerPattern, boolean resultIsProp) {
        PatTycker sub = new PatTycker(this.exprTycker, this.patSubst, new TypedSubst());
        VisitPatterns result = sub.visitPatterns(sig, stream, outerPattern, null, resultIsProp);
        this.hasError = this.hasError || sub.hasError;
        return result;
    }

    @NotNull
    private PatData beforeTyck(@NotNull PatData data) {
        return new PatData(data.sig(), data.results(), data.param().subst(this.sigSubst.map()));
    }

    @NotNull
    private PatData afterTyck(@NotNull PatData data) {
        return new PatData(new Def.Signature((ImmutableSeq<Term.Param>)data.sig().param().drop(1), data.sig().result()), data.results(), data.param());
    }

    @NotNull
    private VisitPatterns done(@NotNull SeqLike<Arg<Pat>> results, @NotNull Term type, @Nullable Expr body) {
        return new VisitPatterns((SeqView<Arg<Pat>>)results.view(), type.subst(this.sigSubst.map()), body);
    }

    @NotNull
    private Def.Signature<?> updateSig(PatData data, Arg<Pattern> arg, boolean resultIsProp) {
        data = this.beforeTyck(data);
        Term type = data.param.type();
        Pattern pat = (Pattern)arg.term();
        Pat res = this.exprTycker.traced(() -> new Trace.PatT(type, pat, pat.sourcePos()), () -> this.doTyck(pat, type, resultIsProp));
        this.addSigSubst(data.param(), res);
        data.results.append((Object)new Arg((Object)res, arg.explicit()));
        return this.afterTyck(data).sig();
    }

    @NotNull
    private Def.Signature<?> generatePat(@NotNull PatData data) {
        Record bind;
        data = this.beforeTyck(data);
        LocalVar ref = data.param.ref();
        LocalVar freshVar = ref.rename();
        Term term = data.param.type().normalize(this.exprTycker.state, NormalizeMode.WHNF);
        if (term instanceof DataCall) {
            DataCall dataCall = (DataCall)term;
            bind = new Pat.Meta((MutableValue<Pat>)MutableValue.create(), freshVar, dataCall);
        } else {
            bind = new Pat.Bind(freshVar, data.param.type());
            this.exprTycker.localCtx.put(freshVar, data.param.type());
        }
        data.results.append((Object)new Arg((Object)bind, false));
        this.addSigSubst(data.param(), (Pat)((Object)bind));
        return this.afterTyck(data).sig();
    }

    @NotNull
    private Pat randomPat(Term param) {
        return new Pat.Bind(new LocalVar("?"), param);
    }

    @Nullable
    private Tuple3<DataCall, Subst, ConCall.Head> selectCtor(Term param, @Nullable AnyVar name, @NotNull Pattern pos) {
        Term term = param.normalize(this.exprTycker.state, NormalizeMode.WHNF);
        if (!(term instanceof DataCall)) {
            this.foundError(new PatternProblem.SplittingOnNonData(pos, param));
            return null;
        }
        DataCall dataCall = (DataCall)term;
        AnyVar dataRef = dataCall.ref();
        DataDef core = (DataDef)((DefVar)dataRef).core;
        if (core == null && name == null) {
            this.foundError(new TyckOrderError.NotYetTyckedError(pos.sourcePos(), dataRef));
            return null;
        }
        Seq<CtorDef> body = Def.dataBody((DefVar<? extends DataDef, ? extends TeleDecl.DataDecl>)dataRef);
        for (CtorDef ctor : body) {
            if (name != null && ctor.ref() != name) continue;
            Result<Subst, Boolean> matchy = PatTycker.mischa(dataCall, ctor, this.exprTycker.state);
            if (matchy.isOk()) {
                return Tuple.of((Object)dataCall, (Object)((Subst)matchy.get()), (Object)dataCall.conHead(ctor.ref()));
            }
            if (name == null) {
                if (!((Boolean)matchy.getErr()).booleanValue()) continue;
                this.foundError(new PatternProblem.BlockedEval(pos, dataCall));
                return null;
            }
            this.foundError(new PatternProblem.UnavailableCtor(pos, dataCall));
            return null;
        }
        if (core == null) {
            this.foundError(new TyckOrderError.NotYetTyckedError(pos.sourcePos(), name));
            return null;
        }
        if (name != null) {
            this.foundError(new PatternProblem.UnknownCtor(pos));
        }
        return null;
    }

    public static Result<Subst, Boolean> mischa(DataCall dataCall, CtorDef ctor, @NotNull TyckState state) {
        if (ctor.pats.isNotEmpty()) {
            return PatMatcher.tryBuildSubst(true, ctor.pats, dataCall.args(), new Expander.WHNFer(state));
        }
        return Result.ok((Object)DeltaExpander.buildSubst(Def.defTele(dataCall.ref()), dataCall.args()));
    }

    private void foundError(@Nullable Problem problem) {
        this.hasError = true;
        if (problem != null) {
            this.exprTycker.reporter.report(problem);
        }
    }

    @NotNull
    private Pat withError(Problem problem, Term param) {
        this.foundError(problem);
        return this.randomPat(param);
    }

    @NotNull
    public static Term inlineTerm(@NotNull Term term) {
        return META_PAT_INLINER.apply(term);
    }

    @NotNull
    public TypedSubst allSubst() {
        return this.patSubst.derive().addDirectly(this.sigSubst);
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Pattern.Bind arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ LocalVar $proxy$bind(Pattern.Bind arg0) {
        try {
            return arg0.bind();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Expr $proxy$userType(Pattern.Bind arg0) {
        try {
            return arg0.userType();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ MutableValue $proxy$type(Pattern.Bind arg0) {
        try {
            return arg0.type();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Pattern.CalmFace arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Pattern.Number arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ int $proxy$number(Pattern.Number arg0) {
        try {
            return arg0.number();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Pattern.List arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ ImmutableSeq $proxy$elements(Pattern.List arg0) {
        try {
            return arg0.elements();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Pattern.As arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Pattern $proxy$pattern(Pattern.As arg0) {
        try {
            return arg0.pattern();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ LocalVar $proxy$as(Pattern.As arg0) {
        try {
            return arg0.as();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ MutableValue $proxy$type(Pattern.As arg0) {
        try {
            return arg0.type();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Expr.Lambda arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Expr.Param $proxy$param(Expr.Lambda arg0) {
        try {
            return arg0.param();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Expr $proxy$body(Expr.Lambda arg0) {
        try {
            return arg0.body();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private /* synthetic */ Object lambda$doTyck$20(Expr tyExpr, Term term) {
        this.exprTycker.lets.addDirectly(this.allSubst());
        ExprTycker.Result syn = this.exprTycker.synthesize(tyExpr);
        this.exprTycker.unifyTyReported(term, syn.wellTyped(), tyExpr);
        return null;
    }

    public record AllLhsResult(@NotNull ImmutableSeq<LhsResult> lhsResult, boolean hasError) {
        public AllLhsResult(@NotNull ImmutableSeq<LhsResult> lhsResults) {
            this(lhsResults, lhsResults.anyMatch(LhsResult::hasError));
        }
    }

    public record PatResult(@NotNull Term result, @NotNull ImmutableSeq<Pat.Preclause<Term>> clauses, @NotNull ImmutableSeq<Term.Matching> matchings, boolean hasLhsError) {
    }

    public record LhsResult(@NotNull LocalCtx gamma, @NotNull Term type, @NotNull TypedSubst bodySubst, boolean hasError, @NotNull Pat.Preclause<Expr> preclause) {
    }

    private record VisitPatterns(@NotNull SeqView<Arg<Pat>> wellTyped, @NotNull Term codomain, @UnknownNullability Expr newBody) {
    }

    private record PatData(@NotNull Def.Signature<?> sig, @NotNull MutableList<Arg<Pat>> results, @NotNull Term.Param param) {
    }
}

