/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import kala.collection.mutable.MutableList;
import org.aya.concrete.remark.CodeOptions;
import org.aya.generic.util.NormalizeMode;
import org.aya.prettier.AyaPrettierOptions;
import org.commonmark.node.Code;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Delimited;
import org.commonmark.node.Node;
import org.commonmark.node.Nodes;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;
import org.jetbrains.annotations.NotNull;

public enum CodeAttrProcessor implements DelimiterProcessor
{
    INSTANCE;

    @NotNull
    private static final Pattern DELIM;
    @NotNull
    private static final Pattern EQ;

    public char getOpeningCharacter() {
        return '{';
    }

    public char getClosingCharacter() {
        return '}';
    }

    public int getMinLength() {
        return 1;
    }

    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        if (openingRun.length() != 1) {
            return 0;
        }
        Text opener = openingRun.getOpener();
        Node node = opener.getPrevious();
        if (!(node instanceof Code)) {
            return 0;
        }
        Code code = (Code)node;
        MutableList toUnlink = MutableList.create();
        StringBuilder content = new StringBuilder();
        for (Node node2 : Nodes.between((Node)opener, (Node)closingRun.getCloser())) {
            if (node2 instanceof Text) {
                Text text = (Text)node2;
                content.append(text.getLiteral());
                toUnlink.append((Object)text);
                continue;
            }
            return 0;
        }
        AyaPrettierOptions dist = new AyaPrettierOptions();
        NormalizeMode mode = NormalizeMode.NULL;
        CodeOptions.ShowCode show = CodeOptions.ShowCode.Core;
        for (String s : DELIM.split(content.toString())) {
            if (s.isBlank()) continue;
            String[] attribute = EQ.split(s, 2);
            if (attribute.length > 1) {
                String key = attribute[0];
                String val = attribute[1];
                if ("mode".equalsIgnoreCase(key)) {
                    mode = (NormalizeMode)this.cbt(val, NormalizeMode.values(), NormalizeMode.NULL);
                    continue;
                }
                if ("show".equalsIgnoreCase(key)) {
                    show = (CodeOptions.ShowCode)this.cbt(val, CodeOptions.ShowCode.values(), CodeOptions.ShowCode.Core);
                    continue;
                }
                AyaPrettierOptions.Key cbt = (AyaPrettierOptions.Key)this.cbt(key, AyaPrettierOptions.Key.values(), null);
                if (cbt != null) {
                    boolean isTrue = val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes");
                    dist.map.put(cbt, isTrue);
                    continue;
                }
            }
            return 0;
        }
        for (Node node3 : toUnlink) {
            node3.unlink();
        }
        if (dist.map.size() > 0) {
            Attr imageAttributes = new Attr(new CodeOptions(mode, dist, show));
            code.appendChild((Node)imageAttributes);
        }
        return 1;
    }

    private <E extends Enum<E>> E cbt(@NotNull String key, E[] values, E otherwise) {
        for (E val : values) {
            if (!StringUtil.containsIgnoreCase((String)((Enum)val).name(), (String)key)) continue;
            return val;
        }
        return otherwise;
    }

    static {
        DELIM = Pattern.compile("[\\s,;]+");
        EQ = Pattern.compile("=");
    }

    public static class Attr
    extends CustomNode
    implements Delimited {
        @NotNull
        public final CodeOptions options;

        public Attr(@NotNull CodeOptions options) {
            this.options = options;
        }

        public String getOpeningDelimiter() {
            return "{";
        }

        public String getClosingDelimiter() {
            return "}";
        }
    }
}

