/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.desugar.Desugarer;
import org.aya.generic.AyaDocile;
import org.aya.prettier.ConcretePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.module.ModuleLoader;
import org.aya.resolve.visitor.StmtResolver;
import org.aya.resolve.visitor.StmtShallowResolver;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Stmt
extends AyaDocile,
TyckUnit {
    @Contract(pure=true)
    @NotNull
    public Accessibility accessibility();

    @Contract(mutates="param1")
    public static void resolve(@NotNull ImmutableSeq<Stmt> statements, @NotNull ResolveInfo resolveInfo, @NotNull ModuleLoader loader) {
        Stmt.resolveWithoutDesugar(statements, resolveInfo, loader);
        statements.forEach(s -> s.desugar(resolveInfo));
    }

    @Contract(mutates="param1")
    public static void resolveWithoutDesugar(@NotNull ImmutableSeq<Stmt> statements, @NotNull ResolveInfo resolveInfo, @NotNull ModuleLoader loader) {
        StmtShallowResolver shallowResolver = new StmtShallowResolver(loader, resolveInfo);
        shallowResolver.resolveStmt((SeqLike<Stmt>)statements, resolveInfo.thisModule());
        StmtResolver.resolveStmt(statements, resolveInfo);
        StmtResolver.resolveBind(statements, resolveInfo);
        AyaBinOpSet opSet = resolveInfo.opSet();
        opSet.reportIfCyclic();
    }

    default public void desugar(@NotNull ResolveInfo resolveInfo) {
        new Desugarer(resolveInfo).accept(this);
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull PrettierOptions options) {
        return new ConcretePrettier(options).stmt(this);
    }

    public static enum Accessibility {
        Private("private"),
        Public("public");

        @NotNull
        public final String keyword;

        private Accessibility(String keyword) {
            this.keyword = keyword;
        }
    }
}

